/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.security.MessageDigest;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.exoplatform.commons.utils.StringCommonUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.rendering.MarkupRenderingService;
import org.exoplatform.forum.rendering.api.Renderer;
import org.exoplatform.forum.rendering.core.SupportedSyntaxes;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.quartz.JobExecutionContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;

public class CommonUtils {
    private static Log log = ExoLogger.getLogger(CommonUtils.class);
    public static final String COMMA = ",";
    public static final String SLASH = "/";
    public static final String EMPTY_STR = "";
    public static final String COLON = ":";
    public static final String SEMICOLON = ";";
    public static final String SPACE = " ";
    public static final String ASTERISK_STR = "*";
    public static final String PERCENT_STR = "%";
    public static final String AMP_NUMBER = "&#";
    public static final String LESS_THAN = "&lt;";
    public static final String GREATER_THAN = "&gt;";
    public static final String QUOT = "&quot;";
    public static final String AMP_SPACE = "&nbsp;";
    public static final String AMP_HEX = "&#x26;";
    public static final String AMP = "&amp;";
    public static final String FROM_KEY = "gatein.email.smtp.from";
    private static final String SPECIAL_CHARACTOR_FORSERACH_REGEX = "[^\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}[\\p{InEnclosedAlphanumerics}&&\\p{So}]\\?\\*%0-9]";
    private static final String SPECIAL_CHARACTOR_FOR_UNIFIED_SERACH_REGEX = "[^\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}[\\p{InEnclosedAlphanumerics}&&\\p{So}]0-9]";
    private static final String SPECIAL_CHARACTOR_REGEX = "[^\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}[\\p{InEnclosedAlphanumerics}&&\\p{So}]\\ %0-9]";
    private static final Pattern EXCEPT_PATTERN = Pattern.compile("~(([1|0]\\.[0-9])|1)+");

    public static String generateCheckSum(byte[] b) throws Exception {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(b);
            byte[] mdbytes = md.digest();
            StringBuffer sb = new StringBuffer(EMPTY_STR);
            for (int i = 0; i < mdbytes.length; ++i) {
                sb.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
            }
            return sb.toString();
        }
        catch (Exception e) {
            log.warn((Object)"Can not generate checksum for exporting data");
            return EMPTY_STR;
        }
    }

    public static File getXMLFile(ByteArrayOutputStream bos, String appName, String objectType, Date createDate, String fileName) throws Exception {
        byte[] byteData = bos.toByteArray();
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        ByteArrayInputStream is = new ByteArrayInputStream(byteData);
        Document document = docBuilder.parse(is);
        Attr namespace = document.createAttribute("xmlns:exoks");
        namespace.setValue("http://www.exoplatform.com/exoks/2.0");
        document.getFirstChild().getAttributes().setNamedItem(namespace);
        Attr attName = document.createAttribute("exoks:applicationName");
        attName.setValue(appName);
        document.getFirstChild().getAttributes().setNamedItem(attName);
        Attr dataType = document.createAttribute("exoks:objectType");
        dataType.setValue(objectType);
        document.getFirstChild().getAttributes().setNamedItem(dataType);
        Attr exportDate = document.createAttribute("exoks:exportDate");
        exportDate.setValue(createDate.toString());
        document.getFirstChild().getAttributes().setNamedItem(exportDate);
        Attr checkSum = document.createAttribute("exoks:checkSum");
        checkSum.setValue(CommonUtils.generateCheckSum(byteData));
        document.getFirstChild().getAttributes().setNamedItem(checkSum);
        DOMSource source = new DOMSource(document.getFirstChild());
        File file = new File(fileName + ".xml");
        file.deleteOnExit();
        file.createNewFile();
        StreamResult result = new StreamResult(file);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        transformer.transform(source, result);
        return file;
    }

    public static String getImageUrl(String imagePath) throws Exception {
        StringBuilder url = new StringBuilder();
        try {
            ExoContainerContext exoContext = CommonUtils.getComponent(ExoContainerContext.class);
            url.append(SLASH).append(exoContext.getRestContextName());
        }
        catch (Exception e) {
            url.append("/portal");
            log.error((Object)"Can not get portal name or rest context name, exception: ", (Throwable)e);
        }
        RepositoryService rService = CommonUtils.getComponent(RepositoryService.class);
        url.append("/jcr/").append(rService.getCurrentRepository().getConfiguration().getName()).append(imagePath).append(SLASH);
        return url.toString();
    }

    public static String convertCodeHTML(String s) {
        if (CommonUtils.isEmpty(s)) {
            return EMPTY_STR;
        }
        s = s.replaceAll("(<p>((\\&nbsp;)*)(\\s*)?</p>)|(<p>((\\&nbsp;)*)?(\\s*)</p>)", "<br/>").trim();
        s = s.replaceFirst("(<br/>)*", EMPTY_STR);
        s = s.replaceAll("(\\w|\\$)(>?,?\\.?\\*?\\!?\\&?\\%?\\]?\\)?\\}?)(<br/><br/>)*", "$1$2");
        try {
            s = CommonUtils.processBBCode(s);
            s = s.replaceAll("(https?|ftp)://", " $0").replaceAll("(=\"|='|'>|\">)( )(https?|ftp)", "$1$3").replaceAll("[^=\"|^='|^'>|^\">](https?://|ftp://)([-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|])", "<a target=\"_blank\" href=\"$1$2\">$1$2</a>");
            s = s.replaceAll("&apos;", "'");
        }
        catch (Exception e) {
            log.error((Object)("Failed to convert HTML" + e.getMessage()));
        }
        return s;
    }

    public static String makeNotificationSender(String from) {
        if (from == null) {
            return null;
        }
        Properties props = new Properties(System.getProperties());
        String mailAddr = props.getProperty(FROM_KEY);
        if (mailAddr == null || mailAddr.length() == 0) {
            mailAddr = props.getProperty("mail.from");
        }
        if (mailAddr != null) {
            try {
                return new InternetAddress(from + "<" + mailAddr + ">").toUnicodeString();
            }
            catch (AddressException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"value of 'gatein.email.smtp.from' or 'mail.from' in configuration file is not in format of mail address", (Throwable)e);
                }
                return null;
            }
        }
        return null;
    }

    public static String getURI(String url) {
        if (!CommonUtils.isEmpty(url) && url.indexOf("http") == 0 && url.indexOf(SLASH, 8) > 0) {
            return url.substring(url.indexOf(SLASH, 8));
        }
        return url;
    }

    public static String processBBCode(String s) {
        MarkupRenderingService markupRenderingService = CommonUtils.getComponent(MarkupRenderingService.class);
        Renderer r = markupRenderingService.getRenderer(SupportedSyntaxes.bbcode.name());
        return r.render(s);
    }

    public static ExoContainer getExoContainer(JobExecutionContext context) {
        if (context == null) {
            return null;
        }
        String portalName = context.getJobDetail().getKey().getGroup();
        if (portalName == null) {
            portalName = PortalContainer.getCurrentPortalContainerName();
        }
        if (portalName.indexOf(COLON) > 0) {
            portalName = portalName.substring(0, portalName.indexOf(COLON));
        }
        return ExoContainerContext.getContainerByName((String)portalName);
    }

    public static String getRSSLink(String appType, String portalName, String objectId) {
        return SLASH + PortalContainer.getInstance().getRestContextName() + "/ks/" + appType + "/rss/" + objectId;
    }

    public static String getUserRSSLink(String apptype, String userId) {
        return SLASH + PortalContainer.getInstance().getRestContextName() + "/ks/" + apptype + "/rss/user/" + userId;
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().length() <= 0;
    }

    public static boolean isEmpty(String[] array) {
        if (array != null && array.length > 0) {
            for (String s : array) {
                if (s == null || s.trim().length() <= 0) continue;
                return false;
            }
        }
        return true;
    }

    public static String removeSpecialCharacterForSearch(String input) {
        if (CommonUtils.isEmpty(input)) {
            return input;
        }
        String result = input.replaceAll(SPECIAL_CHARACTOR_FORSERACH_REGEX, SPACE);
        result = result.replaceAll("\\s+", SPACE);
        return result.trim();
    }

    public static String removeSpecialCharacterForUnifiedSearch(String input) {
        String[] tab;
        if (CommonUtils.isEmpty(input)) {
            return input;
        }
        StringBuilder builder = new StringBuilder();
        for (String s : tab = input.split(SPACE)) {
            if (CommonUtils.isEmpty(s)) continue;
            String searchTerm = s.split("~")[0];
            searchTerm = StringCommonUtils.encodeSpecialCharToHTMLnumber((String)searchTerm.replaceAll(SPECIAL_CHARACTOR_FOR_UNIFIED_SERACH_REGEX, EMPTY_STR), (String)"~", (boolean)true);
            builder.append(searchTerm).append(SPACE);
        }
        return builder.toString().trim();
    }

    public static String processUnifiedSearchSearchCondition(String input) {
        String[] tab;
        if (CommonUtils.isEmpty(input) || input.indexOf("~") < 0 || input.indexOf("\\~") > 0) {
            return input;
        }
        StringBuilder builder = new StringBuilder();
        for (String s : tab = input.split(SPACE)) {
            String searchTerm;
            if (CommonUtils.isEmpty(s)) continue;
            if (s.indexOf("~") > -1) {
                searchTerm = s.split("~")[0];
                String similarity = s.split("~")[1];
                searchTerm = StringCommonUtils.encodeSpecialCharToHTMLnumber((String)searchTerm.replaceAll(SPECIAL_CHARACTOR_FOR_UNIFIED_SERACH_REGEX, EMPTY_STR), (String)"~", (boolean)true);
                builder.append(searchTerm).append("~").append(similarity).append(SPACE);
                continue;
            }
            searchTerm = StringCommonUtils.encodeSpecialCharToHTMLnumber((String)s.replaceAll(SPECIAL_CHARACTOR_FOR_UNIFIED_SERACH_REGEX, EMPTY_STR), (String)"~", (boolean)true);
            builder.append(searchTerm).append(SPACE);
        }
        return builder.toString().trim();
    }

    public static String normalizeUnifiedSearchInput(String input) {
        if (CommonUtils.isEmpty(input)) {
            return input;
        }
        StringBuilder builder = new StringBuilder();
        String keySearch = CommonUtils.removeExceptPattern(input);
        String wildcardCharacters = CommonUtils.has2BytesCharacter(keySearch) ? PERCENT_STR : ASTERISK_STR;
        StringTokenizer tokenizer = new StringTokenizer(keySearch, SPACE);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if ((token = StringCommonUtils.encodeSpecialCharToHTMLnumber((String)token.replaceAll(SPECIAL_CHARACTOR_FOR_UNIFIED_SERACH_REGEX, EMPTY_STR), (String)"~", (boolean)true)).length() <= 0) continue;
            builder.append(wildcardCharacters).append(token).append(wildcardCharacters).append(tokenizer.hasMoreTokens() ? SPACE : EMPTY_STR);
        }
        return builder.toString();
    }

    private static String removeExceptPattern(String input) {
        return EXCEPT_PATTERN.matcher(input.trim()).replaceAll(EMPTY_STR);
    }

    private static boolean has2BytesCharacter(String input) {
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c <= '\u00ff') continue;
            return true;
        }
        return false;
    }

    public static boolean hasSpecialCharacter(String input) {
        if (CommonUtils.isEmpty(input)) {
            return false;
        }
        String result = input.replaceAll(SPECIAL_CHARACTOR_REGEX, EMPTY_STR).replaceAll("_", EMPTY_STR);
        return !result.equals(input);
    }

    public static String processSearchCondition(String searchCondition) {
        if (CommonUtils.isEmpty(searchCondition)) {
            return searchCondition;
        }
        StringBuilder searchConditionBuffer = new StringBuilder();
        searchCondition = CommonUtils.removeSpecialCharacterForSearch(searchCondition);
        searchCondition = searchCondition.replace(ASTERISK_STR, PERCENT_STR);
        searchConditionBuffer.append(PERCENT_STR).append(searchCondition).append(PERCENT_STR);
        return searchConditionBuffer.toString();
    }

    public static String getExcerpt(String str, String textQuery, int maxLength) {
        if (str.length() <= maxLength) {
            return str;
        }
        int position = str.indexOf("<strong>");
        if (position < 0) {
            position = Math.max(0, str.indexOf(textQuery));
        }
        return CommonUtils.centerTrunc(str, position, maxLength);
    }

    public static final String centerTrunc(String str, int middlePosition, int maxLength) {
        StringBuffer buf = null;
        if (str.length() <= maxLength) {
            return str;
        }
        int halfLength = maxLength / 2;
        int start = 0;
        if (middlePosition > halfLength) {
            start = middlePosition - halfLength;
        }
        int end = Math.min(str.length(), start + maxLength);
        buf = new StringBuffer();
        buf.append(str.substring(start, end));
        String ret = buf.substring(buf.indexOf(SPACE));
        if (start > 0) {
            ret = "..." + ret;
        }
        ret = ret.substring(0, ret.lastIndexOf(SPACE)) + " ...";
        return ret;
    }

    public static Calendar getGreenwichMeanTime() {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setLenient(false);
        int gmtoffset = calendar.get(16) + calendar.get(15);
        calendar.setTimeInMillis(System.currentTimeMillis() - (long)gmtoffset);
        return calendar;
    }

    public static <T> T getComponent(Class<T> type) {
        return type.cast(PortalContainer.getInstance().getComponentInstanceOfType(type));
    }

    public static SessionProvider createSystemProvider() {
        SessionProviderService sessionProviderService = CommonUtils.getComponent(SessionProviderService.class);
        return sessionProviderService.getSystemSessionProvider(null);
    }
}

