/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.file.services.impl;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.file.model.FileInfo;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.model.NameSpace;
import org.exoplatform.commons.file.resource.BinaryProvider;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.file.services.FileStorageException;
import org.exoplatform.commons.file.services.impl.FileServiceImpl$AjcClosure1;
import org.exoplatform.commons.file.services.impl.FileServiceImpl$AjcClosure3;
import org.exoplatform.commons.file.services.impl.NameSpaceServiceImpl;
import org.exoplatform.commons.file.storage.DataStorage;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class FileServiceImpl
implements FileService {
    private static final Log LOG;
    private DataStorage dataStorage;
    private BinaryProvider binaryProvider;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public FileServiceImpl(DataStorage dataStorage, BinaryProvider resourceProvider) throws Exception {
        this.dataStorage = dataStorage;
        this.binaryProvider = resourceProvider;
    }

    @Override
    public FileInfo getFileInfo(long id) {
        return this.dataStorage.getFileInfo(id);
    }

    @Override
    public FileItem getFile(long id) throws FileStorageException {
        FileItem fileItem;
        FileInfo fileInfo = this.getFileInfo(id);
        if (fileInfo == null || StringUtils.isEmpty((String)fileInfo.getChecksum())) {
            return null;
        }
        try {
            fileItem = new FileItem(fileInfo, null);
            InputStream inputStream = this.binaryProvider.getStream(fileInfo.getChecksum());
            fileItem.setInputStream(inputStream);
        }
        catch (Exception e) {
            throw new FileStorageException("Cannot get File Item ID=" + id, e);
        }
        return fileItem;
    }

    @Override
    @ExoTransactional
    public FileItem writeFile(FileItem file) throws FileStorageException, IOException {
        FileItem fileItem = file;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)fileItem);
        Object[] objectArray = new Object[]{this, fileItem, joinPoint};
        return (FileItem)ExoTransactionalAspect.aspectOf().around(new FileServiceImpl$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public FileItem updateFile(FileItem file) throws FileStorageException, IOException {
        FileItem fileItem = file;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)fileItem);
        Object[] objectArray = new Object[]{this, fileItem, joinPoint};
        return (FileItem)ExoTransactionalAspect.aspectOf().around(new FileServiceImpl$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    public FileInfo deleteFile(long id) {
        FileInfo fileInfo = this.dataStorage.getFileInfo(id);
        if (fileInfo != null) {
            fileInfo.setDeleted(true);
        }
        return this.dataStorage.updateFileInfo(fileInfo);
    }

    static {
        FileServiceImpl.ajc$preClinit();
        LOG = ExoLogger.getLogger(FileServiceImpl.class);
    }

    static /* synthetic */ FileItem writeFile_aroundBody0(FileServiceImpl ajc$this, FileItem file, JoinPoint joinPoint) {
        FileInfo fileInfo;
        if (file.getFileInfo() == null || StringUtils.isEmpty((String)file.getFileInfo().getChecksum())) {
            throw new IllegalArgumentException("Checksum is required to persist the binary");
        }
        NameSpace nSpace = (fileInfo = file.getFileInfo()).getNameSpace() != null && !fileInfo.getNameSpace().isEmpty() ? ajc$this.dataStorage.getNameSpace(fileInfo.getNameSpace()) : ajc$this.dataStorage.getNameSpace(NameSpaceServiceImpl.getDefaultNameSpace());
        FileStorageTransaction transaction = ajc$this.new FileStorageTransaction(fileInfo, nSpace);
        FileInfo createdFileInfoEntity = transaction.twoPhaseCommit(2, file.getAsStream());
        if (createdFileInfoEntity != null) {
            fileInfo.setId(createdFileInfoEntity.getId());
            file.setFileInfo(fileInfo);
            return file;
        }
        return null;
    }

    static /* synthetic */ FileItem updateFile_aroundBody2(FileServiceImpl ajc$this, FileItem file, JoinPoint joinPoint) {
        FileInfo fileInfo;
        if (file.getFileInfo() == null || StringUtils.isEmpty((String)file.getFileInfo().getChecksum())) {
            throw new IllegalArgumentException("Checksum is required to persist the binary");
        }
        NameSpace nSpace = (fileInfo = file.getFileInfo()).getNameSpace() != null && !fileInfo.getNameSpace().isEmpty() ? ajc$this.dataStorage.getNameSpace(fileInfo.getNameSpace()) : ajc$this.dataStorage.getNameSpace(NameSpaceServiceImpl.getDefaultNameSpace());
        FileStorageTransaction transaction = ajc$this.new FileStorageTransaction(fileInfo, nSpace);
        FileInfo createdFileInfoEntity = transaction.twoPhaseCommit(0, file.getAsStream());
        if (createdFileInfoEntity != null) {
            fileInfo.setId(createdFileInfoEntity.getId());
            file.setFileInfo(fileInfo);
            return file;
        }
        return null;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("FileServiceImpl.java", FileServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "writeFile", "org.exoplatform.commons.file.services.impl.FileServiceImpl", "org.exoplatform.commons.file.model.FileItem", "file", "org.exoplatform.commons.file.services.FileStorageException:java.io.IOException", "org.exoplatform.commons.file.model.FileItem"), 63);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateFile", "org.exoplatform.commons.file.services.impl.FileServiceImpl", "org.exoplatform.commons.file.model.FileItem", "file", "org.exoplatform.commons.file.services.FileStorageException:java.io.IOException", "org.exoplatform.commons.file.model.FileItem"), 86);
    }

    private class FileStorageTransaction {
        final int UPDATE = 0;
        final int REMOVE = 1;
        final int INSERT = 2;
        private FileInfo fileInfo;
        private NameSpace nameSpace;

        public FileStorageTransaction(FileInfo fileInfo, NameSpace nameSpace) {
            this.fileInfo = fileInfo;
            this.nameSpace = nameSpace;
        }

        public FileInfo twoPhaseCommit(int operation, InputStream inputStream) throws FileStorageException {
            FileInfo createdFileInfoEntity = null;
            if (operation == 2) {
                boolean created = false;
                try {
                    if (!FileServiceImpl.this.binaryProvider.exists(this.fileInfo.getChecksum())) {
                        FileServiceImpl.this.binaryProvider.put(this.fileInfo.getChecksum(), inputStream);
                        created = true;
                    }
                    if (FileServiceImpl.this.binaryProvider.exists(this.fileInfo.getChecksum())) {
                        createdFileInfoEntity = FileServiceImpl.this.dataStorage.create(this.fileInfo, this.nameSpace);
                        return createdFileInfoEntity;
                    }
                    throw new FileStorageException("Error while writing file " + this.fileInfo.getName());
                }
                catch (Exception e) {
                    try {
                        if (created) {
                            FileServiceImpl.this.binaryProvider.remove(this.fileInfo.getChecksum());
                        }
                    }
                    catch (IOException e1) {
                        LOG.error((Object)"Error while rollback writing file");
                    }
                    throw new FileStorageException("Error while writing file " + this.fileInfo.getName(), e);
                }
            }
            if (operation == 1) {
                this.fileInfo.setDeleted(true);
                FileServiceImpl.this.dataStorage.updateFileInfo(this.fileInfo);
            } else if (operation == 0) {
                try {
                    boolean updated = false;
                    FileInfo oldFile = FileServiceImpl.this.dataStorage.getFileInfo(this.fileInfo.getId());
                    if (oldFile == null || oldFile.getChecksum().isEmpty() || !oldFile.getChecksum().equals(this.fileInfo.getChecksum())) {
                        if (!FileServiceImpl.this.binaryProvider.exists(this.fileInfo.getChecksum())) {
                            FileServiceImpl.this.binaryProvider.put(this.fileInfo.getChecksum(), inputStream);
                        }
                        updated = true;
                    }
                    if (updated && FileServiceImpl.this.dataStorage.sharedChecksum(oldFile.getChecksum()) == 1) {
                        FileServiceImpl.this.dataStorage.createOrphanFile(oldFile);
                    }
                    if (FileServiceImpl.this.binaryProvider.exists(this.fileInfo.getChecksum())) {
                        createdFileInfoEntity = FileServiceImpl.this.dataStorage.updateFileInfo(this.fileInfo);
                        return createdFileInfoEntity;
                    }
                    throw new FileStorageException("Error while writing file " + this.fileInfo.getName());
                }
                catch (Exception e) {
                    try {
                        FileServiceImpl.this.binaryProvider.remove(this.fileInfo.getChecksum());
                    }
                    catch (IOException e1) {
                        LOG.error((Object)"Error while rollback writing file");
                    }
                    throw new FileStorageException("Error while writing file " + this.fileInfo.getName(), e);
                }
            }
            return null;
        }
    }
}

