/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.pom.config;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import org.exoplatform.commons.chromattic.ChromatticLifeCycle;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.commons.chromattic.SessionContext;
import org.exoplatform.commons.scope.ScopedKey;
import org.exoplatform.portal.pom.config.ExecutorDispatcher;
import org.exoplatform.portal.pom.config.MOPChromatticLifeCycle;
import org.exoplatform.portal.pom.config.POMSession;
import org.exoplatform.portal.pom.config.POMTask;
import org.exoplatform.portal.pom.config.PortalMOPService;
import org.exoplatform.portal.pom.config.TaskExecutionDecorator;
import org.exoplatform.portal.pom.config.cache.DataCache;
import org.exoplatform.portal.pom.config.cache.PortalNamesCache;
import org.exoplatform.portal.pom.data.OwnerKey;
import org.exoplatform.portal.pom.data.PortalKey;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ObjectCacheInfo;
import org.exoplatform.services.jcr.RepositoryService;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.mop.core.api.MOPService;
import org.picocontainer.Startable;

public class POMSessionManager
implements Startable {
    private final Logger log = LoggerFactory.getLogger(POMSessionManager.class);
    private static final String CACHE_NAME = "portal.MOPSessionManager";
    private MOPService pomService;
    private final ExoCache<ScopedKey<?>, Object> cache;
    final ChromatticManager manager;
    private ChromatticLifeCycle configurator;
    private final TaskExecutionDecorator executor;
    private final RepositoryService repositoryService;

    public POMSessionManager(RepositoryService repositoryService, ChromatticManager manager, CacheService cacheService) {
        this.repositoryService = repositoryService;
        this.manager = manager;
        this.cache = cacheService.getCacheInstance(CACHE_NAME);
        this.pomService = null;
        this.executor = new PortalNamesCache(new DataCache(new ExecutorDispatcher()));
    }

    public ChromatticLifeCycle getLifeCycle() {
        return this.configurator;
    }

    public void cachePut(Serializable key, Object value) {
        ScopedKey globalKey = ScopedKey.create((Serializable)key);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Updating cache key=" + globalKey + " with value=" + value));
        }
        this.cache.put((Serializable)globalKey, value);
    }

    public Object cacheGet(Serializable key) {
        ScopedKey globalKey = ScopedKey.create((Serializable)key);
        Object value = this.cache.get((Serializable)globalKey);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Obtained for cache key=" + globalKey + " value=" + value));
        }
        return value;
    }

    public void cacheRemove(Serializable key) {
        final ScopedKey globalKey = ScopedKey.create((Serializable)key);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Removing cache key=" + globalKey));
        }
        if (key instanceof PortalKey) {
            final PortalKey portalKey = (PortalKey)key;
            try {
                this.cache.select(new CachedObjectSelector<ScopedKey<?>, Object>(){

                    public boolean select(ScopedKey<?> selectedGlobalKey, ObjectCacheInfo<?> ocinfo) {
                        OwnerKey selectedOwnerKey;
                        Serializable selectedLocalKey;
                        return globalKey.getScope().equals(selectedGlobalKey.getScope()) && (selectedLocalKey = selectedGlobalKey.getKey()) instanceof OwnerKey && (selectedOwnerKey = (OwnerKey)selectedLocalKey).getType().equals(portalKey.getType()) && selectedOwnerKey.getId().equals(portalKey.getId());
                    }

                    public void onSelect(ExoCache<? extends ScopedKey<?>, ?> exoCache, ScopedKey<?> key, ObjectCacheInfo<?> ocinfo) throws Exception {
                        POMSessionManager.this.cache.remove(key);
                    }
                });
            }
            catch (Exception e) {
                this.log.error((Object)"Unexpected error when clearing pom cache", (Throwable)e);
            }
        } else {
            this.cache.remove((Serializable)globalKey);
        }
    }

    public void start() {
        try {
            MOPChromatticLifeCycle configurator = (MOPChromatticLifeCycle)this.manager.getLifeCycle("mop");
            configurator.manager = this;
            PortalMOPService pomService = new PortalMOPService(configurator.getChromattic());
            pomService.start();
            this.pomService = pomService;
            this.configurator = configurator;
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public void stop() {
    }

    public void clearCache() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Clearing cache");
        }
        this.cache.clearCache();
    }

    public MOPService getPOMService() {
        return this.pomService;
    }

    public <E extends TaskExecutionDecorator> E getDecorator(Class<E> decoratorClass) {
        return (E)((TaskExecutionDecorator)this.executor.getDecorator(decoratorClass));
    }

    public POMSession getSession() {
        SessionContext context = this.configurator.getContext();
        return context != null ? (POMSession)context.getAttachment("mopsession") : null;
    }

    public POMSession openSession() {
        SessionContext context = this.configurator.openContext();
        return (POMSession)context.getAttachment("mopsession");
    }

    public <V> V execute(POMTask<V> task) throws Exception {
        POMSession session = this.getSession();
        return this.executor.execute(session, task);
    }
}

