/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.servlet;

import javax.servlet.ServletRequest;

public class ServletRequestContext {
    public static final String HOST = "host";
    public static final String PORT = "port";
    public static final String SCHEME = "scheme";
    private static ThreadLocal<String> host = new ThreadLocal();
    private static ThreadLocal<String> port = new ThreadLocal();
    private static ThreadLocal<String> scheme = new ThreadLocal();

    public static void setRequestInfo(ServletRequest req) {
        host.set(req.getServerName());
        port.set("" + req.getServerPort());
        scheme.set(req.getScheme());
        System.setProperty(HOST, req.getServerName());
        System.setProperty(PORT, "" + req.getServerPort());
        System.setProperty(SCHEME, req.getScheme());
    }

    public static String getHost() {
        return host.get() != null ? host.get() : System.getProperty(HOST);
    }

    public static String getPort() {
        return port.get() != null ? port.get() : System.getProperty(PORT);
    }

    public static String getScheme() {
        return scheme.get() != null ? scheme.get() : System.getProperty(SCHEME);
    }
}

