/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.shindig.common.crypto.BasicBlobCrypter;
import org.apache.shindig.common.servlet.Authority;
import org.apache.shindig.common.servlet.BasicAuthority;
import org.apache.shindig.common.servlet.GuiceServletContextListener;
import org.apache.shindig.common.util.GenericDigestUtils;
import org.apache.shindig.gadgets.config.DefaultConfigContributorModule;
import org.apache.shindig.gadgets.http.AbstractHttpCache;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.InvalidationHandler;
import org.apache.shindig.gadgets.js.JsCompilerModule;
import org.apache.shindig.gadgets.js.JsServingPipelineModule;
import org.apache.shindig.gadgets.parse.ParseModule;
import org.apache.shindig.gadgets.preload.PreloadModule;
import org.apache.shindig.gadgets.render.RenderModule;
import org.apache.shindig.gadgets.rewrite.RewriteModule;
import org.apache.shindig.gadgets.servlet.GadgetsHandler;
import org.apache.shindig.gadgets.servlet.HttpRequestHandler;
import org.apache.shindig.gadgets.templates.TemplateModule;
import org.apache.shindig.gadgets.uri.ProxyUriBase;
import org.apache.shindig.gadgets.uri.UriModule;
import org.apache.shindig.gadgets.variables.SubstituterModule;

public class DefaultGuiceModule
extends AbstractModule {
    public static final ThreadFactory DAEMON_THREAD_FACTORY = new ThreadFactory(){
        private final ThreadFactory factory = Executors.defaultThreadFactory();

        @Override
        public Thread newThread(Runnable r) {
            Thread t = this.factory.newThread(r);
            t.setDaemon(true);
            return t;
        }
    };

    protected void configure() {
        this.bind(ExecutorService.class).to(ShindigExecutorService.class);
        this.bind(Executor.class).annotatedWith((Annotation)Names.named((String)"shindig.concat.executor")).to(ShindigExecutorService.class);
        this.bind(Authority.class).to(BasicAuthority.class);
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"shindig.jsload.ttl-secs")).to(3600);
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"shindig.jsload.require-onload-with-jsload")).to(true);
        this.install((Module)new DefaultConfigContributorModule());
        this.install((Module)new ParseModule());
        this.install((Module)new PreloadModule());
        this.install((Module)new RenderModule());
        this.install((Module)new RewriteModule());
        this.install((Module)new SubstituterModule());
        this.install((Module)new TemplateModule());
        this.install((Module)new UriModule());
        this.install((Module)new JsCompilerModule());
        this.install((Module)new JsServingPipelineModule());
        this.requestStaticInjection(new Class[]{HttpResponse.class});
        this.requestStaticInjection(new Class[]{AbstractHttpCache.class});
        this.requestStaticInjection(new Class[]{ProxyUriBase.class});
        this.requestStaticInjection(new Class[]{GenericDigestUtils.class});
        this.requestStaticInjection(new Class[]{BasicBlobCrypter.class});
        this.registerGadgetHandlers();
        this.registerFeatureHandlers();
    }

    protected void registerGadgetHandlers() {
        Multibinder handlerBinder = Multibinder.newSetBinder((Binder)this.binder(), Object.class, (Annotation)Names.named((String)"org.apache.shindig.handlers"));
        handlerBinder.addBinding().to(InvalidationHandler.class);
        handlerBinder.addBinding().to(HttpRequestHandler.class);
        handlerBinder.addBinding().to(GadgetsHandler.class);
    }

    protected void registerFeatureHandlers() {
        Multibinder.newSetBinder((Binder)this.binder(), String.class, (Annotation)Names.named((String)"org.apache.shindig.features-extended"));
    }

    @Provides
    @Singleton
    @Named(value="org.apache.shindig.features")
    protected List<String> defaultFeatures(@Named(value="shindig.features.default") String features, @Named(value="org.apache.shindig.features-extended") Set<String> extended) {
        return ImmutableList.builder().addAll(Splitter.on((char)',').split((CharSequence)features)).addAll(extended).build();
    }

    @Singleton
    public static class ShindigExecutorService
    extends ThreadPoolExecutor
    implements GuiceServletContextListener.CleanupCapable {
        @Inject
        public ShindigExecutorService(GuiceServletContextListener.CleanupHandler cleanupHandler) {
            super(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), DAEMON_THREAD_FACTORY);
            cleanupHandler.register((GuiceServletContextListener.CleanupCapable)this);
        }

        public void cleanup() {
            this.shutdown();
        }
    }
}

