/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.config;

import com.google.common.collect.Maps;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.AuthType;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.config.ConfigContributor;
import org.apache.shindig.gadgets.oauth.OAuthArguments;
import org.apache.shindig.gadgets.oauth2.OAuth2Arguments;
import org.apache.shindig.gadgets.spec.View;

@Singleton
public class XhrwrapperConfigContributor
implements ConfigContributor {
    @Override
    public void contribute(Map<String, Object> config, Gadget gadget) {
        HashMap xhrWrapperConfig = Maps.newHashMapWithExpectedSize((int)2);
        View view = gadget.getCurrentView();
        Uri contentsUri = view.getHref();
        xhrWrapperConfig.put("contentUrl", contentsUri == null ? "" : contentsUri.toString());
        if (AuthType.OAUTH.equals((Object)view.getAuthType())) {
            this.addOAuthConfig(xhrWrapperConfig, view);
        } else if (AuthType.SIGNED.equals((Object)view.getAuthType())) {
            xhrWrapperConfig.put("authorization", "signed");
        } else if (AuthType.OAUTH2.equals((Object)view.getAuthType())) {
            this.addOAuth2Config(xhrWrapperConfig, view);
        }
        config.put("shindig.xhrwrapper", xhrWrapperConfig);
    }

    private void addOAuthConfig(Map<String, String> xhrWrapperConfig, View view) {
        HashMap oAuthConfig = Maps.newHashMapWithExpectedSize((int)3);
        try {
            OAuthArguments oAuthArguments = new OAuthArguments(view);
            oAuthConfig.put("authorization", "oauth");
            oAuthConfig.put("oauthService", oAuthArguments.getServiceName());
            if (!"".equals(oAuthArguments.getTokenName())) {
                oAuthConfig.put("oauthTokenName", oAuthArguments.getTokenName());
            }
            xhrWrapperConfig.putAll(oAuthConfig);
        }
        catch (GadgetException e) {
            // empty catch block
        }
    }

    private void addOAuth2Config(Map<String, String> xhrWrapperConfig, View view) {
        HashMap oAuth2Config = Maps.newHashMapWithExpectedSize((int)3);
        OAuth2Arguments oAuth2Arguments = new OAuth2Arguments(view);
        oAuth2Config.put("authorization", "oauth2");
        oAuth2Config.put("oauthService", oAuth2Arguments.getServiceName());
        xhrWrapperConfig.putAll(oAuth2Config);
    }

    @Override
    public void contribute(Map<String, Object> config, String container, String host) {
    }
}

