/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.HashSet;
import java.util.List;
import org.apache.shindig.auth.AuthenticationMode;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.http.InvalidationService;
import org.apache.shindig.protocol.BaseRequestItem;
import org.apache.shindig.protocol.Operation;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.Service;

@Service(name="cache")
public class InvalidationHandler {
    public static final String KEYS_PARAM = "invalidationKeys";
    private final InvalidationService invalidation;

    @Inject
    public InvalidationHandler(InvalidationService invalidation) {
        this.invalidation = invalidation;
    }

    @Operation(httpMethods={"POST", "GET"}, path="/invalidate")
    public void invalidate(BaseRequestItem request) {
        if (Strings.isNullOrEmpty((String)request.getToken().getAppId()) && Strings.isNullOrEmpty((String)request.getToken().getAppUrl())) {
            throw new ProtocolException(400, "Cannot invalidate content without specifying application");
        }
        boolean isBackendInvalidation = AuthenticationMode.OAUTH_CONSUMER_REQUEST.name().equals(request.getToken().getAuthenticationMode());
        List keys = request.getListParameter(KEYS_PARAM);
        HashSet userIds = Sets.newHashSet();
        HashSet resources = Sets.newHashSet();
        if (!Strings.isNullOrEmpty((String)request.getToken().getViewerId())) {
            userIds.add(request.getToken().getViewerId());
        }
        if (keys != null) {
            for (String key : keys) {
                String lowerKey = key.toLowerCase();
                if (lowerKey.startsWith("http")) {
                    if (!isBackendInvalidation) {
                        throw new ProtocolException(400, "Cannot flush application resources from a gadget. Must use OAuth consumer request");
                    }
                    resources.add(Uri.parse((String)key));
                    continue;
                }
                if ("@viewer".equals(key)) continue;
                if (!isBackendInvalidation && !key.equals(request.getToken().getViewerId())) {
                    throw new ProtocolException(400, "Cannot invalidate the content for a user other than the viewer from a gadget.");
                }
                userIds.add(key);
            }
        }
        this.invalidation.invalidateApplicationResources(resources, request.getToken());
        this.invalidation.invalidateUserResources(userIds, request.getToken());
    }
}

