/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.js;

import com.google.inject.Inject;
import org.apache.shindig.gadgets.js.JsException;
import org.apache.shindig.gadgets.js.JsProcessorRegistry;
import org.apache.shindig.gadgets.js.JsRequest;
import org.apache.shindig.gadgets.js.JsResponse;
import org.apache.shindig.gadgets.js.JsResponseBuilder;
import org.apache.shindig.gadgets.js.JsServingPipeline;

public class DefaultJsServingPipeline
implements JsServingPipeline {
    private final JsProcessorRegistry jsProcessorRegistry;

    @Inject
    public DefaultJsServingPipeline(JsProcessorRegistry jsProcessorRegistry) {
        this.jsProcessorRegistry = jsProcessorRegistry;
    }

    @Override
    public JsResponse execute(JsRequest jsRequest) throws JsException {
        JsResponseBuilder resp = new JsResponseBuilder();
        this.jsProcessorRegistry.process(jsRequest, resp);
        JsResponse response = resp.build();
        if (response.isError()) {
            throw new JsException(response.getStatusCode(), response.toErrorString());
        }
        return response;
    }
}

