/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.js;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.List;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.features.FeatureRegistry;
import org.apache.shindig.gadgets.features.FeatureRegistryProvider;
import org.apache.shindig.gadgets.js.BaseSurfaceJsProcessor;
import org.apache.shindig.gadgets.js.JsContent;
import org.apache.shindig.gadgets.js.JsException;
import org.apache.shindig.gadgets.js.JsProcessor;
import org.apache.shindig.gadgets.js.JsRequest;
import org.apache.shindig.gadgets.js.JsResponseBuilder;
import org.apache.shindig.gadgets.uri.JsUriManager;

public class ExportJsProcessor
extends BaseSurfaceJsProcessor
implements JsProcessor {
    @VisibleForTesting
    static final String FEATURE_NAME = "exportjs";
    private static final String FUNCTION_NAME = "exportJs";

    @Inject
    public ExportJsProcessor(FeatureRegistryProvider featureRegistryProvider, Provider<GadgetContext> context) {
        super(featureRegistryProvider, context);
    }

    @Override
    public boolean process(JsRequest jsRequest, JsResponseBuilder builder) throws JsException {
        JsUriManager.JsUri jsUri = jsRequest.getJsUri();
        ImmutableList.Builder resp = ImmutableList.builder();
        FeatureRegistry featureRegistry = this.getFeatureRegistry(jsUri);
        boolean needExports = false;
        FeatureRegistry.FeatureBundle last = null;
        if (!jsUri.isJsload()) {
            for (JsContent jsc : builder.build().getAllJsContent()) {
                FeatureRegistry.FeatureBundle current = jsc.getFeatureBundle();
                if (last != null && current != last) {
                    needExports |= this.appendExportJsStatements((ImmutableList.Builder<JsContent>)resp, jsUri, last);
                }
                resp.add((Object)jsc);
                last = current;
            }
            if (last != null) {
                needExports |= this.appendExportJsStatements((ImmutableList.Builder<JsContent>)resp, jsUri, last);
            }
        }
        builder.clearJs();
        if (needExports) {
            builder.appendAllJs(this.getSurfaceJsContents(featureRegistry, FEATURE_NAME));
        }
        builder.appendAllJs((Iterable<JsContent>)resp.build());
        return true;
    }

    private boolean appendExportJsStatements(ImmutableList.Builder<JsContent> builder, JsUriManager.JsUri jsUri, FeatureRegistry.FeatureBundle bundle) {
        List<String> exports = this.getExports(bundle, jsUri);
        if (!exports.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (BaseSurfaceJsProcessor.Input input : this.generateInputs(exports)) {
                sb.append(this.toExportStatement(input));
            }
            builder.add((Object)JsContent.fromFeature(sb.toString(), "[generated-symbol-exports]", bundle, null));
            return true;
        }
        return false;
    }

    private String toExportStatement(BaseSurfaceJsProcessor.Input input) {
        StringBuilder result = new StringBuilder();
        if (input.namespace != null) {
            result.append(FUNCTION_NAME).append("('").append(input.namespace).append("',[");
            result.append(Joiner.on((char)',').join(input.components));
            result.append("],{");
            for (int i = 0; i < input.properties.size(); ++i) {
                String prop = input.properties.get(i);
                if (i > 0) {
                    result.append(',');
                }
                result.append(prop).append(":'").append(prop).append('\'');
            }
            result.append("});");
        } else {
            for (String prop : input.properties) {
                result.append(FUNCTION_NAME).append('(');
                result.append('\'').append(prop).append("',[");
                result.append(prop);
                result.append("]);");
            }
        }
        return result.toString();
    }
}

