/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypterException;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.LockedDomainService;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.oauth.OAuthArguments;
import org.apache.shindig.gadgets.oauth.OAuthCallbackGenerator;
import org.apache.shindig.gadgets.oauth.OAuthCallbackState;
import org.apache.shindig.gadgets.oauth.OAuthError;
import org.apache.shindig.gadgets.oauth.OAuthFetcherConfig;
import org.apache.shindig.gadgets.oauth.OAuthGadgetContext;
import org.apache.shindig.gadgets.oauth.OAuthRequestException;
import org.apache.shindig.gadgets.oauth.OAuthResponseParams;
import org.apache.shindig.gadgets.process.ProcessingException;
import org.apache.shindig.gadgets.process.Processor;
import org.apache.shindig.gadgets.uri.OAuthUriManager;

public class GadgetOAuthCallbackGenerator
implements OAuthCallbackGenerator {
    private final Processor processor;
    private final LockedDomainService lockedDomainService;
    private final OAuthUriManager oauthUriManager;
    private final BlobCrypter stateCrypter;

    @Inject
    public GadgetOAuthCallbackGenerator(Processor processor, LockedDomainService lockedDomainService, OAuthUriManager oauthUriManager, @Named(value="shindig.oauth.state-crypter") BlobCrypter stateCrypter) {
        this.processor = processor;
        this.lockedDomainService = lockedDomainService;
        this.oauthUriManager = oauthUriManager;
        this.stateCrypter = stateCrypter;
    }

    @Override
    public String generateCallback(OAuthFetcherConfig fetcherConfig, String baseCallback, HttpRequest request, OAuthResponseParams responseParams) throws OAuthRequestException {
        Uri activeUrl = this.checkGadgetCanRender(request.getSecurityToken(), request.getOAuthArguments(), responseParams);
        String gadgetDomainCallback = this.getGadgetDomainCallback(request.getSecurityToken(), activeUrl);
        if (gadgetDomainCallback == null) {
            return null;
        }
        return this.generateCallbackForProvider(responseParams, baseCallback, gadgetDomainCallback);
    }

    private Uri checkGadgetCanRender(SecurityToken securityToken, OAuthArguments arguments, OAuthResponseParams responseParams) throws OAuthRequestException {
        try {
            OAuthGadgetContext context = new OAuthGadgetContext(securityToken, arguments);
            Gadget gadget = this.processor.process(context);
            Uri activeUrl = Uri.parse((String)securityToken.getActiveUrl());
            String hostname = activeUrl.getAuthority();
            if (!this.lockedDomainService.isGadgetValidForHost(hostname, gadget, securityToken.getContainer())) {
                throw new OAuthRequestException(OAuthError.UNKNOWN_PROBLEM, "Gadget should not be using URL " + activeUrl);
            }
            return activeUrl;
        }
        catch (ProcessingException e) {
            throw new OAuthRequestException(OAuthError.UNKNOWN_PROBLEM, "Unable to check if gadget is using locked-domain", (Throwable)e);
        }
    }

    private String getGadgetDomainCallback(SecurityToken securityToken, Uri activeUrl) {
        Uri gadgetCallback = this.oauthUriManager.makeOAuthCallbackUri(securityToken.getContainer(), activeUrl.getAuthority());
        if (gadgetCallback == null) {
            return null;
        }
        if (Strings.isNullOrEmpty((String)gadgetCallback.getScheme())) {
            gadgetCallback = new UriBuilder(gadgetCallback).setScheme(activeUrl.getScheme()).toUri();
        }
        return gadgetCallback.toString();
    }

    private String generateCallbackForProvider(OAuthResponseParams responseParams, String callbackForProvider, String gadgetDomainCallback) throws OAuthRequestException {
        OAuthCallbackState state = new OAuthCallbackState(this.stateCrypter);
        state.setRealCallbackUrl(gadgetDomainCallback);
        UriBuilder callback = UriBuilder.parse((String)callbackForProvider);
        try {
            callback.addQueryParameter("cs", state.getEncryptedState());
        }
        catch (BlobCrypterException e) {
            throw new OAuthRequestException(OAuthError.UNKNOWN_PROBLEM, "Failure generating callback URL", (Throwable)e);
        }
        return callback.toString();
    }
}

