/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth2;

import com.google.common.base.Joiner;
import com.google.inject.Inject;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetSpecFactory;
import org.apache.shindig.gadgets.oauth2.BasicOAuth2Accessor;
import org.apache.shindig.gadgets.oauth2.OAuth2Accessor;
import org.apache.shindig.gadgets.oauth2.OAuth2Arguments;
import org.apache.shindig.gadgets.oauth2.OAuth2Error;
import org.apache.shindig.gadgets.oauth2.OAuth2GadgetContext;
import org.apache.shindig.gadgets.oauth2.OAuth2RequestException;
import org.apache.shindig.gadgets.oauth2.OAuth2Store;
import org.apache.shindig.gadgets.oauth2.logger.FilteredLogger;
import org.apache.shindig.gadgets.spec.BaseOAuthService;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.OAuth2Service;
import org.apache.shindig.gadgets.spec.OAuth2Spec;

public class GadgetOAuth2TokenStore {
    private static final String LOG_CLASS = GadgetOAuth2TokenStore.class.getName();
    private static final FilteredLogger LOG = FilteredLogger.getFilteredLogger(LOG_CLASS);
    private final GadgetSpecFactory specFactory;
    private final OAuth2Store store;

    @Inject
    public GadgetOAuth2TokenStore(OAuth2Store store, GadgetSpecFactory specFactory) {
        this.store = store;
        this.specFactory = specFactory;
        if (LOG.isLoggable()) {
            LOG.log("this.store = {0}", this.store);
            LOG.log("this.specFactory = {0}", this.specFactory);
        }
    }

    private GadgetSpec findSpec(SecurityToken securityToken, OAuth2Arguments arguments, Uri gadgetUri) throws OAuth2RequestException {
        GadgetSpec ret;
        boolean isLogging = LOG.isLoggable();
        if (isLogging) {
            LOG.entering(LOG_CLASS, "findSpec", new Object[]{arguments, gadgetUri});
        }
        try {
            OAuth2GadgetContext context = new OAuth2GadgetContext(securityToken, arguments, gadgetUri);
            ret = this.specFactory.getGadgetSpec(context);
        }
        catch (IllegalArgumentException e) {
            if (isLogging) {
                LOG.log("Error finding GadgetContext " + gadgetUri.toString(), e);
            }
            throw new OAuth2RequestException(OAuth2Error.GADGET_SPEC_PROBLEM, gadgetUri.toString(), e);
        }
        catch (GadgetException e) {
            if (isLogging) {
                LOG.log("Error finding GadgetContext " + gadgetUri.toString(), e);
            }
            throw new OAuth2RequestException(OAuth2Error.GADGET_SPEC_PROBLEM, gadgetUri.toString(), e);
        }
        if (isLogging) {
            if (ret == null) {
                LOG.exiting(LOG_CLASS, "findSpec", null);
            } else {
                LOG.exiting(LOG_CLASS, "findSpec", "non-null spec omitted from logs");
            }
        }
        return ret;
    }

    public OAuth2Accessor getOAuth2Accessor(SecurityToken securityToken, OAuth2Arguments arguments, Uri gadgetUri) {
        boolean isLogging = LOG.isLoggable();
        if (isLogging) {
            LOG.entering(LOG_CLASS, "getOAuth2Accessor", new Object[]{securityToken, arguments, gadgetUri});
        }
        BasicOAuth2Accessor ret = null;
        if (this.store == null || gadgetUri == null || securityToken == null) {
            ret = new BasicOAuth2Accessor(null, OAuth2Error.GET_OAUTH2_ACCESSOR_PROBLEM, "OAuth2Accessor missing a param --- store = " + this.store + " , gadgetUri = " + gadgetUri + " , securityToken = " + securityToken, "");
        } else {
            String serviceName = arguments != null ? arguments.getServiceName() : "";
            OAuth2SpecInfo specInfo = null;
            try {
                specInfo = this.lookupSpecInfo(securityToken, arguments, gadgetUri);
            }
            catch (OAuth2RequestException e1) {
                if (isLogging) {
                    LOG.log("No gadget spec", e1);
                }
                ret = new BasicOAuth2Accessor(e1, OAuth2Error.NO_GADGET_SPEC, "gadgetUri = " + gadgetUri + " , serviceName = " + serviceName, "");
            }
            if (specInfo == null) {
                ret = new BasicOAuth2Accessor(null, OAuth2Error.NO_GADGET_SPEC, "gadgetUri = " + gadgetUri + " , serviceName = " + serviceName, "");
            }
            if (ret == null && arguments != null) {
                OAuth2Accessor persistedAccessor;
                String scope = arguments.getScope();
                if (scope == null || scope.length() == 0) {
                    scope = specInfo.getScope();
                }
                if (scope == null || scope.length() == 0) {
                    scope = "";
                }
                try {
                    persistedAccessor = this.store.getOAuth2Accessor(gadgetUri.toString(), serviceName, securityToken.getViewerId(), scope);
                }
                catch (GadgetException e) {
                    if (isLogging) {
                        LOG.log("Exception in getOAuth2Accessor", e);
                    }
                    persistedAccessor = null;
                }
                if (persistedAccessor == null) {
                    ret = new BasicOAuth2Accessor(null, OAuth2Error.GET_OAUTH2_ACCESSOR_PROBLEM, "gadgetUri = " + gadgetUri + " , serviceName = " + serviceName, "");
                } else {
                    BasicOAuth2Accessor mergedAccessor = new BasicOAuth2Accessor(persistedAccessor);
                    if (persistedAccessor.isAllowModuleOverrides()) {
                        String specAuthorizationUrl = specInfo.getAuthorizationUrl();
                        String specTokenUrl = specInfo.getTokenUrl();
                        if (specAuthorizationUrl != null && specAuthorizationUrl.length() > 0) {
                            mergedAccessor.setAuthorizationUrl(specAuthorizationUrl);
                        }
                        if (specTokenUrl != null && specTokenUrl.length() > 0) {
                            mergedAccessor.setTokenUrl(specTokenUrl);
                        }
                    }
                    this.store.storeOAuth2Accessor(mergedAccessor);
                    ret = mergedAccessor;
                }
            }
        }
        if (isLogging) {
            LOG.exiting(LOG_CLASS, "getOAuth2Accessor", ret);
        }
        return ret;
    }

    public OAuth2Store getOAuth2Store() {
        return this.store;
    }

    private OAuth2SpecInfo lookupSpecInfo(SecurityToken securityToken, OAuth2Arguments arguments, Uri gadgetUri) throws OAuth2RequestException {
        GadgetSpec spec;
        OAuth2Spec oauthSpec;
        boolean isLogging = LOG.isLoggable();
        if (isLogging) {
            LOG.entering(LOG_CLASS, "lookupSpecInfo", new Object[]{securityToken, arguments, gadgetUri});
        }
        if ((oauthSpec = (spec = this.findSpec(securityToken, arguments, gadgetUri)).getModulePrefs().getOAuth2Spec()) == null) {
            throw new OAuth2RequestException(OAuth2Error.LOOKUP_SPEC_PROBLEM, "Failed to retrieve OAuth URLs, spec for gadget " + securityToken.getAppUrl() + " does not contain OAuth element.", null);
        }
        OAuth2Service service = oauthSpec.getServices().get(arguments.getServiceName());
        if (service == null) {
            throw new OAuth2RequestException(OAuth2Error.LOOKUP_SPEC_PROBLEM, "Failed to retrieve OAuth URLs, spec for gadget does not contain OAuth service " + arguments.getServiceName() + ".  Known services: " + Joiner.on((char)',').join(oauthSpec.getServices().keySet()) + '.', null);
        }
        String authorizationUrl = null;
        BaseOAuthService.EndPoint authorizationUrlEndpoint = service.getAuthorizationUrl();
        if (authorizationUrlEndpoint != null) {
            authorizationUrl = authorizationUrlEndpoint.url.toString();
        }
        String tokenUrl = null;
        BaseOAuthService.EndPoint tokenUrlEndpoint = service.getTokenUrl();
        if (tokenUrlEndpoint != null) {
            tokenUrl = tokenUrlEndpoint.url.toString();
        }
        OAuth2SpecInfo ret = new OAuth2SpecInfo(authorizationUrl, tokenUrl, service.getScope());
        if (isLogging) {
            LOG.exiting(LOG_CLASS, "lookupSpecInfo", ret);
        }
        return ret;
    }

    private static class OAuth2SpecInfo {
        private final String authorizationUrl;
        private final String scope;
        private final String tokenUrl;

        public OAuth2SpecInfo(String authorizationUrl, String tokenUrl, String scope) {
            this.authorizationUrl = authorizationUrl;
            this.tokenUrl = tokenUrl;
            this.scope = scope;
        }

        public String getAuthorizationUrl() {
            return this.authorizationUrl;
        }

        public String getScope() {
            return this.scope;
        }

        public String getTokenUrl() {
            return this.tokenUrl;
        }
    }
}

