/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth2;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import org.apache.shindig.gadgets.oauth2.GadgetOAuth2TokenStore;
import org.apache.shindig.gadgets.oauth2.OAuth2Store;

public class OAuth2FetcherConfig {
    private final GadgetOAuth2TokenStore tokenStore;
    private final boolean viewerAccessTokensEnabled;
    public static final String OAUTH2_STATE_CRYPTER = "shindig.oauth2.state-crypter";

    @Inject
    public OAuth2FetcherConfig(GadgetOAuth2TokenStore tokenStore, @Named(value="shindig.oauth2.viewer-access-tokens-enabled") boolean viewerAccessTokensEnabled) {
        this.tokenStore = tokenStore;
        this.viewerAccessTokensEnabled = viewerAccessTokensEnabled;
    }

    public OAuth2Store getOAuth2Store() {
        return this.tokenStore.getOAuth2Store();
    }

    public GadgetOAuth2TokenStore getTokenStore() {
        return this.tokenStore;
    }

    public boolean isViewerAccessTokensEnabled() {
        return this.viewerAccessTokensEnabled;
    }
}

