/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth2;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.shindig.common.Pair;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.oauth2.logger.FilteredLogger;

public class OAuth2ResponseParams {
    public static final String APPROVAL_URL = "oauthApprovalUrl";
    public static final String ERROR_CODE = "oauthError";
    public static final String ERROR_TEXT = "oauthErrorText";
    public static final String ERROR_TRACE = "oauthErrorTrace";
    public static final String ERROR_URI = "oauthErrorUri";
    public static final String ERROR_EXPLANATION = "oauthErrorExplanation";
    private String authorizationUrl;
    private String requestTraceString;
    private String message;

    public void addRequestTrace(HttpRequest request, HttpResponse response) {
        ArrayList requestTrace = Lists.newArrayList();
        requestTrace.add(Pair.of((Object)request, (Object)response));
        this.requestTraceString = OAuth2ResponseParams.getRequestTrace(requestTrace);
    }

    public void addDebug(String debugMessage) {
        this.message = debugMessage;
    }

    public void addToResponse(HttpResponseBuilder responseBuilder, String errorCode, String errorDescription, String errorUri, String errorExplanation) {
        if (errorCode != null) {
            responseBuilder.setMetadata(ERROR_CODE, errorCode);
        } else {
            responseBuilder.setMetadata(ERROR_CODE, "");
        }
        if (errorUri != null) {
            responseBuilder.setMetadata(ERROR_URI, errorUri);
        } else {
            responseBuilder.setMetadata(ERROR_URI, "");
        }
        if (errorDescription != null) {
            responseBuilder.setMetadata(ERROR_TEXT, errorDescription);
        } else {
            responseBuilder.setMetadata(ERROR_TEXT, "");
        }
        if (errorExplanation != null) {
            responseBuilder.setMetadata(ERROR_EXPLANATION, errorExplanation);
        } else {
            responseBuilder.setMetadata(ERROR_EXPLANATION, "");
        }
        String _message = "\n";
        if (this.message != null) {
            _message = _message + this.message + '\n';
        }
        if (this.requestTraceString != null) {
            _message = _message + this.requestTraceString;
        }
        responseBuilder.setMetadata(ERROR_TRACE, _message);
    }

    public String getAuthorizationUrl() {
        return this.authorizationUrl;
    }

    public void setAuthorizationUrl(String authorizationUrl) {
        this.authorizationUrl = authorizationUrl;
    }

    private static String getRequestTrace(List<Pair<HttpRequest, HttpResponse>> requestTrace) {
        StringBuilder trace = new StringBuilder();
        int i = 1;
        for (Pair<HttpRequest, HttpResponse> event : requestTrace) {
            trace.append("\n==== Sent request ").append(i).append(":\n");
            if (event.one != null) {
                trace.append(FilteredLogger.filterSecrets(((HttpRequest)event.one).toString()));
            }
            trace.append("\n==== Received response ").append(i).append(":\n");
            if (event.two != null) {
                trace.append(FilteredLogger.filterSecrets(((HttpResponse)event.two).toString()));
            }
            trace.append("\n====");
            ++i;
        }
        return trace.toString();
    }
}

