/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth2.handler;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.shindig.auth.AnonymousSecurityToken;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpFetcher;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.oauth2.OAuth2Accessor;
import org.apache.shindig.gadgets.oauth2.OAuth2Error;
import org.apache.shindig.gadgets.oauth2.OAuth2Message;
import org.apache.shindig.gadgets.oauth2.OAuth2Utils;
import org.apache.shindig.gadgets.oauth2.handler.AuthorizationEndpointResponseHandler;
import org.apache.shindig.gadgets.oauth2.handler.ClientAuthenticationHandler;
import org.apache.shindig.gadgets.oauth2.handler.OAuth2HandlerError;
import org.apache.shindig.gadgets.oauth2.handler.TokenEndpointResponseHandler;
import org.apache.shindig.gadgets.oauth2.logger.FilteredLogger;

public class CodeAuthorizationResponseHandler
implements AuthorizationEndpointResponseHandler {
    private static final String LOG_CLASS = CodeAuthorizationResponseHandler.class.getName();
    private static final FilteredLogger LOG = FilteredLogger.getFilteredLogger(LOG_CLASS);
    private final List<ClientAuthenticationHandler> clientAuthenticationHandlers;
    private final HttpFetcher fetcher;
    private final Provider<OAuth2Message> oauth2MessageProvider;
    private final List<TokenEndpointResponseHandler> tokenEndpointResponseHandlers;

    @Inject
    public CodeAuthorizationResponseHandler(Provider<OAuth2Message> oauth2MessageProvider, List<ClientAuthenticationHandler> clientAuthenticationHandlers, List<TokenEndpointResponseHandler> tokenEndpointResponseHandlers, HttpFetcher fetcher) {
        this.oauth2MessageProvider = oauth2MessageProvider;
        this.clientAuthenticationHandlers = clientAuthenticationHandlers;
        this.tokenEndpointResponseHandlers = tokenEndpointResponseHandlers;
        this.fetcher = fetcher;
        if (LOG.isLoggable()) {
            LOG.log("this.oauth2MessageProvider = {0}", this.oauth2MessageProvider);
            LOG.log("this.clientAuthenticationHandlers = {0}", this.clientAuthenticationHandlers);
            LOG.log("this.tokenEndpointResponseHandlers = {0}", this.tokenEndpointResponseHandlers);
            LOG.log("this.fetcher = {0}", this.fetcher);
        }
    }

    private static String getAuthorizationBody(OAuth2Accessor accessor, String authorizationCode) throws UnsupportedEncodingException {
        boolean isLogging = LOG.isLoggable();
        if (isLogging) {
            if (authorizationCode != null) {
                LOG.entering(LOG_CLASS, "getAuthorizationBody", "non-null authorizationCode");
            } else {
                LOG.entering(LOG_CLASS, "getAuthorizationBody", null);
            }
        }
        String ret = "";
        HashMap queryParams = Maps.newHashMapWithExpectedSize((int)5);
        queryParams.put("grant_type", "authorization_code");
        if (authorizationCode != null) {
            queryParams.put("code", authorizationCode);
        }
        queryParams.put("redirect_uri", accessor.getRedirectUri());
        String clientId = accessor.getClientId();
        byte[] secretBytes = accessor.getClientSecret();
        String secret = new String(secretBytes, "UTF-8");
        queryParams.put("client_id", clientId);
        queryParams.put("client_secret", secret);
        for (Map.Entry<String, String> entry : accessor.getAdditionalRequestParams().entrySet()) {
            queryParams.put(entry.getKey(), entry.getValue());
        }
        char firstChar = (ret = OAuth2Utils.buildUrl(ret, queryParams, null)).charAt(0);
        if (firstChar == '?' || firstChar == '&') {
            ret = ret.substring(1);
        }
        if (isLogging) {
            LOG.exiting(LOG_CLASS, "getAuthorizationBody");
        }
        return ret;
    }

    private static String getCompleteTokenUrl(String accessTokenUrl) {
        return OAuth2Utils.buildUrl(accessTokenUrl, null, null);
    }

    @Override
    public OAuth2HandlerError handleRequest(OAuth2Accessor accessor, HttpServletRequest request) {
        boolean isLogging = LOG.isLoggable();
        if (isLogging) {
            LOG.entering(LOG_CLASS, "handleRequest", new Object[]{accessor, request != null});
        }
        OAuth2HandlerError ret = null;
        if (accessor == null) {
            ret = new OAuth2HandlerError(OAuth2Error.AUTHORIZATION_CODE_PROBLEM, "accessor is null", null);
        } else if (request == null) {
            ret = new OAuth2HandlerError(OAuth2Error.AUTHORIZATION_CODE_PROBLEM, "request is null", null);
        } else if (!accessor.isValid() || accessor.isErrorResponse() || !accessor.isRedirecting()) {
            ret = new OAuth2HandlerError(OAuth2Error.AUTHORIZATION_CODE_PROBLEM, "accessor is invalid", null);
        } else if (!accessor.getGrantType().equalsIgnoreCase("code")) {
            ret = new OAuth2HandlerError(OAuth2Error.AUTHORIZATION_CODE_PROBLEM, "grant_type is not code", null);
        }
        if (ret == null) {
            try {
                OAuth2Message msg = (OAuth2Message)this.oauth2MessageProvider.get();
                msg.parseRequest(request);
                ret = msg.getError() != null ? new OAuth2HandlerError(msg.getError(), "error parsing authorization response", null, msg.getErrorUri(), msg.getErrorDescription()) : this.setAuthorizationCode(msg.getAuthorization(), accessor);
            }
            catch (Exception e) {
                if (LOG.isLoggable()) {
                    LOG.log("Exception exchanging authorization code for access_token", e);
                }
                ret = new OAuth2HandlerError(OAuth2Error.AUTHORIZATION_CODE_PROBLEM, "Exception exchanging authorization code for access_token", e);
            }
        }
        if (isLogging) {
            LOG.exiting(LOG_CLASS, "handleRequest", ret);
        }
        return ret;
    }

    @Override
    public OAuth2HandlerError handleResponse(OAuth2Accessor accessor, HttpResponse response) {
        return new OAuth2HandlerError(OAuth2Error.AUTHORIZATION_CODE_PROBLEM, "doesn't handle responses", null);
    }

    @Override
    public boolean handlesRequest(OAuth2Accessor accessor, HttpServletRequest request) {
        if (accessor == null) {
            return false;
        }
        if (request == null) {
            return false;
        }
        if (!accessor.isValid() || accessor.isErrorResponse() || !accessor.isRedirecting()) {
            return false;
        }
        return accessor.getGrantType().equalsIgnoreCase("code");
    }

    @Override
    public boolean handlesResponse(OAuth2Accessor accessor, HttpResponse response) {
        return false;
    }

    private OAuth2HandlerError setAuthorizationCode(String authorizationCode, OAuth2Accessor accessor) {
        boolean isLogging = LOG.isLoggable();
        if (isLogging) {
            if (authorizationCode != null) {
                LOG.entering(LOG_CLASS, "setAuthorizationCode", new Object[]{"non-null authorizationCode", accessor});
            } else {
                LOG.entering(LOG_CLASS, "setAuthorizationCode", new Object[]{null, accessor});
            }
        }
        OAuth2HandlerError ret = null;
        String tokenUrl = CodeAuthorizationResponseHandler.getCompleteTokenUrl(accessor.getTokenUrl());
        HttpRequest request = new HttpRequest(Uri.parse((String)tokenUrl));
        request.setMethod("POST");
        request.setHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
        request.setSecurityToken((SecurityToken)new AnonymousSecurityToken("", Long.valueOf(0L), accessor.getGadgetUri()));
        if (!OAuth2Utils.isUriAllowed(request.getUri(), accessor.getAllowedDomains())) {
            ret = new OAuth2HandlerError(OAuth2Error.AUTHORIZATION_CODE_PROBLEM, "Exception exchanging authorization code for access_token - domain not allowed", null);
        }
        if (ret == null) {
            for (ClientAuthenticationHandler clientAuthenticationHandler : this.clientAuthenticationHandlers) {
                OAuth2HandlerError error;
                if (!clientAuthenticationHandler.geClientAuthenticationType().equalsIgnoreCase(accessor.getClientAuthenticationType()) || (error = clientAuthenticationHandler.addOAuth2Authentication(request, accessor)) == null) continue;
                ret = error;
            }
        }
        if (ret == null) {
            try {
                byte[] body = CodeAuthorizationResponseHandler.getAuthorizationBody(accessor, authorizationCode).getBytes("UTF-8");
                request.setPostBody(body);
            }
            catch (UnsupportedEncodingException e) {
                if (LOG.isLoggable()) {
                    LOG.log("UnsupportedEncodingException getting authorization body", e);
                }
                ret = new OAuth2HandlerError(OAuth2Error.AUTHORIZATION_CODE_PROBLEM, "error getting authorization body", e);
            }
            HttpResponse response = null;
            try {
                response = this.fetcher.fetch(request);
            }
            catch (GadgetException e) {
                if (LOG.isLoggable()) {
                    LOG.log("error exchanging code for access_token", e);
                }
                ret = new OAuth2HandlerError(OAuth2Error.AUTHORIZATION_CODE_PROBLEM, "error exchanging code for access_token", e);
            }
            if (ret == null && response != null) {
                if (response.getHttpStatusCode() != 200) {
                    OAuth2Message msg = (OAuth2Message)this.oauth2MessageProvider.get();
                    msg.parseJSON(response.getResponseAsString());
                    if (msg.getError() != null) {
                        ret = new OAuth2HandlerError(msg.getError(), "error exchanging code for access_token", null, msg.getErrorUri(), msg.getErrorDescription());
                    }
                }
                if (ret == null) {
                    for (TokenEndpointResponseHandler tokenEndpointResponseHandler : this.tokenEndpointResponseHandlers) {
                        if (tokenEndpointResponseHandler.handlesResponse(accessor, response) && (ret = tokenEndpointResponseHandler.handleResponse(accessor, response)) != null) break;
                    }
                }
            }
        }
        if (isLogging) {
            LOG.exiting(LOG_CLASS, "setAuthorizationCode", ret);
        }
        return ret;
    }
}

