/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.uri;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.rewrite.DomWalker;
import org.apache.shindig.gadgets.uri.AccelUriManager;
import org.apache.shindig.gadgets.uri.ProxyUriManager;
import org.apache.shindig.gadgets.uri.UriCommon;

public class DefaultAccelUriManager
implements AccelUriManager,
ContainerConfig.ConfigObserver {
    String accelHost;
    String accelPath;
    ProxyUriManager proxyUriManager;

    @Inject
    public DefaultAccelUriManager(ContainerConfig config, ProxyUriManager proxyUriManager) {
        this.proxyUriManager = proxyUriManager;
        config.addConfigObserver((ContainerConfig.ConfigObserver)this, true);
    }

    public void containersChanged(ContainerConfig config, Collection<String> changed, Collection<String> removed) {
        this.accelHost = config.getString("accel", "gadgets.uri.proxy.host");
        this.accelPath = config.getString("accel", "gadgets.uri.proxy.path");
    }

    @Override
    public Uri parseAndNormalize(HttpRequest httpRequest) throws GadgetException {
        Gadget gadget = DomWalker.makeGadget(httpRequest);
        gadget.setContext(new GadgetContext(gadget.getContext()){

            @Override
            public String getContainer() {
                return "accel";
            }
        });
        ProxyUriManager.ProxyUri proxied = this.looksLikeAccelUri(httpRequest.getUri()) ? this.proxyUriManager.process(httpRequest.getUri()) : new ProxyUriManager.ProxyUri(gadget, httpRequest.getUri());
        return this.proxyUriManager.make((List<ProxyUriManager.ProxyUri>)ImmutableList.of((Object)proxied), 0).get(0);
    }

    protected boolean looksLikeAccelUri(Uri requestUri) {
        return this.accelHost.equals(requestUri.getAuthority()) && this.accelPath.equals(requestUri.getPath()) && !Strings.isNullOrEmpty((String)requestUri.getQueryParameter(UriCommon.Param.URL.getKey()));
    }
}

