/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl.jpa.email;

import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.service.QueueMessage;
import org.exoplatform.commons.api.persistence.DataInitializer;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.notification.NotificationContextFactory;
import org.exoplatform.commons.notification.NotificationUtils;
import org.exoplatform.commons.notification.impl.jpa.EntityConverter;
import org.exoplatform.commons.notification.impl.jpa.email.dao.MailQueueDAO;
import org.exoplatform.commons.notification.impl.jpa.email.entity.MailQueueEntity;
import org.exoplatform.commons.notification.impl.service.MailQueueMessageManager;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.management.annotations.ManagedBy;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.mail.MailService;
import org.hibernate.TransactionException;
import org.picocontainer.Startable;

@ManagedBy(value=MailQueueMessageManager.class)
public class JPAQueueMessageImpl
implements QueueMessage,
Startable {
    private static final Log LOG;
    private static final String MAX_TO_SEND_SYS_KEY = "conf.notification.service.QueueMessage.numberOfMailPerBatch";
    private static final String MAX_TO_SEND_KEY = "numberOfMailPerBatch";
    private static final int MAX_TO_SEND_DEFAULT = 20;
    private boolean enabled = true;
    private int maxToSend;
    private MailService mailService;
    private MailQueueDAO mailQueueDAO;
    private ListenerService listenerService;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public JPAQueueMessageImpl(MailService mailService, MailQueueDAO mailQueueDAO, ListenerService listenerService, DataInitializer dataInitializer, InitParams params) {
        this.mailService = mailService;
        this.mailQueueDAO = mailQueueDAO;
        this.listenerService = listenerService;
        this.maxToSend = NotificationUtils.getSystemValue(params, MAX_TO_SEND_SYS_KEY, MAX_TO_SEND_KEY, 20);
    }

    public void enable(boolean enabled) {
        this.enabled = enabled;
    }

    public void start() {
    }

    public void stop() {
    }

    @ExoTransactional
    public boolean put(MessageInfo message) throws Exception {
        MessageInfo messageInfo = message;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)messageInfo);
        return Conversions.booleanValue((Object)JPAQueueMessageImpl.put_aroundBody1$advice(this, messageInfo, joinPoint, ExoTransactionalAspect.aspectOf(), (ProceedingJoinPoint)joinPoint));
    }

    @ExoTransactional
    public void send() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        JPAQueueMessageImpl.send_aroundBody3$advice(this, joinPoint, ExoTransactionalAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    public boolean sendMessage(MessageInfo message) throws Exception {
        if (message == null) {
            throw new IllegalArgumentException("Message is null");
        }
        if (message.getFrom() == null) {
            throw new IllegalStateException("Message with id '" + message.getId() + "' has an empty 'from' field");
        }
        if (this.enabled) {
            this.mailService.sendMessage(message.makeEmailNotification());
            return true;
        }
        this.listenerService.broadcast(new Event("MESSAGE_SENT_FROM_QUEUE", (Object)this, (Object)message.getId()));
        return true;
    }

    public void removeAll() {
        LOG.debug((Object)"Removing messages: ");
        this.mailQueueDAO.deleteAll();
        LOG.debug((Object)"Done to removed messages! ");
    }

    private void saveMessageInfo(MessageInfo message) {
        MailQueueEntity mailQueueEntity = new MailQueueEntity();
        mailQueueEntity.setType(message.getPluginId());
        mailQueueEntity.setFrom(message.getFrom());
        mailQueueEntity.setTo(message.getTo());
        mailQueueEntity.setSubject(message.getSubject());
        mailQueueEntity.setBody(message.getBody());
        mailQueueEntity.setFooter(message.getFooter());
        mailQueueEntity.setCreationDate(Calendar.getInstance());
        this.mailQueueDAO.create(mailQueueEntity);
    }

    private Set<MessageInfo> load() {
        HashSet<MessageInfo> messages = new HashSet<MessageInfo>();
        for (MailQueueEntity mailQueueEntity : this.mailQueueDAO.findAll(0, this.maxToSend)) {
            try {
                messages.add(EntityConverter.convertQueueEntityToMessageInfo(mailQueueEntity));
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to load message with id = " + mailQueueEntity.getId()), (Throwable)e);
            }
        }
        return messages;
    }

    private void removeMessageInfo(String id) throws Exception {
        LOG.debug((Object)("Removing messageId: " + id));
        this.mailQueueDAO.delete(this.mailQueueDAO.find(Long.parseLong(id)));
        this.listenerService.broadcast(new Event("MESSAGE_DELETED_FROM_QUEUE", (Object)this, (Object)id));
    }

    static {
        JPAQueueMessageImpl.ajc$preClinit();
        LOG = ExoLogger.getExoLogger(JPAQueueMessageImpl.class);
    }

    private static /* synthetic */ boolean put_aroundBody0(JPAQueueMessageImpl ajc$this, MessageInfo message, JoinPoint joinPoint) {
        if (message == null || message.getTo() == null || message.getTo().length() == 0) {
            return false;
        }
        if (!NotificationUtils.isValidEmailAddresses(message.getTo())) {
            LOG.warn((Object)String.format("The email %s is not valid for sending notification", message.getTo()));
            return false;
        }
        ajc$this.saveMessageInfo(message);
        ajc$this.listenerService.broadcast(new Event("MESSAGE_SENT_FROM_QUEUE", (Object)ajc$this, (Object)message.getId()));
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ Object put_aroundBody1$advice(JPAQueueMessageImpl ajc$this, MessageInfo message, JoinPoint thisJoinPoint, ExoTransactionalAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        boolean begunTx = false;
        boolean emStarted = false;
        EntityManagerService service = (EntityManagerService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(EntityManagerService.class);
        EntityManager entityManager = service.getEntityManager();
        if (entityManager == null) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Injecting new PersistenceContext");
            entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
            emStarted = true;
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using existing PersistenceContext");
        }
        EntityTransaction tx = entityManager.getTransaction();
        if (tx.isActive()) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using current transaction");
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Starting new transaction");
            try {
                tx.begin();
            }
            catch (PersistenceException | TransactionException e) {
                ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while starting JPA transaction. The transaction will be restarted.", e);
                try {
                    ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                }
                catch (Exception e1) {
                    ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while closing current JPA entity manager. The transaction will be recreated.", e);
                }
                entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
                tx = entityManager.getTransaction();
                tx.begin();
            }
            begunTx = true;
        }
        try {
            Object result;
            ProceedingJoinPoint proceedingJoinPoint = point;
            Object object = result = Conversions.booleanObject((boolean)JPAQueueMessageImpl.put_aroundBody0(ajc$this, message, (JoinPoint)proceedingJoinPoint));
            return object;
        }
        catch (RuntimeException e) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Error while processing transactional method.", (Throwable)e);
            throw e;
        }
        finally {
            block29: {
                try {
                    if (!begunTx || !tx.isActive()) break block29;
                    if (!tx.getRollbackOnly()) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Committing current transaction");
                        tx.commit();
                    } else {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Rollback current transaction set as RollbackOnly");
                        tx.rollback();
                    }
                }
                catch (RuntimeException ex) {
                    try {
                        if (tx == null) throw ex;
                        if (!tx.isActive()) throw ex;
                        tx.rollback();
                        throw ex;
                    }
                    catch (RuntimeException rbEx) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Could not roll back transaction", (Throwable)rbEx);
                    }
                    throw ex;
                }
                finally {
                    if (emStarted && entityManager != null) {
                        ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                    }
                }
            }
        }
    }

    private static /* synthetic */ void send_aroundBody2(JPAQueueMessageImpl ajc$this, JoinPoint joinPoint) {
        boolean statsEnabled = NotificationContextFactory.getInstance().getStatistics().isStatisticsEnabled();
        int messagesSize = 0;
        Set<MessageInfo> messages = ajc$this.load();
        int originalMessagesSize = messages.size();
        messagesSize = originalMessagesSize;
        if (messagesSize > 0) {
            LOG.info((Object)(messagesSize + " message(s) will be sent."));
        }
        for (MessageInfo messageInfo : messages) {
            if (messageInfo == null) continue;
            try {
                if (!ajc$this.sendMessage(messageInfo)) continue;
                LOG.debug("Mail message '{}' sent to user: {}", new Object[]{messageInfo.getId(), messageInfo.getTo()});
                ajc$this.removeMessageInfo(messageInfo.getId());
                LOG.debug("Mail message '{}' removed from queue, to user: {}", new Object[]{messageInfo.getId(), messageInfo.getTo()});
                if (!statsEnabled) continue;
                NotificationContextFactory.getInstance().getStatisticsCollector().pollQueue(messageInfo.getPluginId());
            }
            catch (Exception e) {
                --messagesSize;
                LOG.error((Object)("Error sending message from = '" + messageInfo.getFrom() + "', to = '" + messageInfo.getTo() + "', id = '" + messageInfo.getId() + "'"), (Throwable)e);
            }
        }
        if (originalMessagesSize > 0) {
            LOG.info("{}/{} message(s) are loaded, sent and deleted from queue.", new Object[]{messagesSize, originalMessagesSize});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ Object send_aroundBody3$advice(JPAQueueMessageImpl ajc$this, JoinPoint thisJoinPoint, ExoTransactionalAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        boolean begunTx = false;
        boolean emStarted = false;
        EntityManagerService service = (EntityManagerService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(EntityManagerService.class);
        EntityManager entityManager = service.getEntityManager();
        if (entityManager == null) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Injecting new PersistenceContext");
            entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
            emStarted = true;
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using existing PersistenceContext");
        }
        EntityTransaction tx = entityManager.getTransaction();
        if (tx.isActive()) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using current transaction");
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Starting new transaction");
            try {
                tx.begin();
            }
            catch (PersistenceException | TransactionException e) {
                ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while starting JPA transaction. The transaction will be restarted.", e);
                try {
                    ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                }
                catch (Exception e1) {
                    ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while closing current JPA entity manager. The transaction will be recreated.", e);
                }
                entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
                tx = entityManager.getTransaction();
                tx.begin();
            }
            begunTx = true;
        }
        try {
            Object result;
            ProceedingJoinPoint proceedingJoinPoint = point;
            JPAQueueMessageImpl.send_aroundBody2(ajc$this, (JoinPoint)proceedingJoinPoint);
            Object var10_13 = result = null;
            return var10_13;
        }
        catch (RuntimeException e) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Error while processing transactional method.", (Throwable)e);
            throw e;
        }
        finally {
            block29: {
                try {
                    if (!begunTx || !tx.isActive()) break block29;
                    if (!tx.getRollbackOnly()) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Committing current transaction");
                        tx.commit();
                    } else {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Rollback current transaction set as RollbackOnly");
                        tx.rollback();
                    }
                }
                catch (RuntimeException ex) {
                    try {
                        if (tx == null) throw ex;
                        if (!tx.isActive()) throw ex;
                        tx.rollback();
                        throw ex;
                    }
                    catch (RuntimeException rbEx) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Could not roll back transaction", (Throwable)rbEx);
                    }
                    throw ex;
                }
                finally {
                    if (emStarted && entityManager != null) {
                        ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                    }
                }
            }
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JPAQueueMessageImpl.java", JPAQueueMessageImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "put", "org.exoplatform.commons.notification.impl.jpa.email.JPAQueueMessageImpl", "org.exoplatform.commons.api.notification.model.MessageInfo", "message", "java.lang.Exception", "boolean"), 88);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "send", "org.exoplatform.commons.notification.impl.jpa.email.JPAQueueMessageImpl", "", "", "", "void"), 110);
    }
}

