/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.settings.jpa;

import java.io.Serializable;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.commons.api.notification.service.setting.UserSettingService;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.future.FutureExoCache;
import org.exoplatform.services.cache.future.Loader;
import org.exoplatform.services.organization.User;
import org.exoplatform.settings.jpa.JPAUserSettingServiceImpl;

public class CacheUserSettingServiceImpl
implements UserSettingService {
    public static final String CACHE_NAME = "commons.UserSettingService";
    private UserSettingService userSettingService;
    private ExoCache<String, UserSetting> userSettingCache;
    private FutureExoCache<String, UserSetting, UserSettingService> userSettingFutureCache;

    public CacheUserSettingServiceImpl(CacheService cacheService, JPAUserSettingServiceImpl userSettingService) {
        this.userSettingService = userSettingService;
        this.userSettingCache = cacheService.getCacheInstance(CACHE_NAME);
        Loader<String, UserSetting, UserSettingService> loader = new Loader<String, UserSetting, UserSettingService>(){

            public UserSetting retrieve(UserSettingService service, String userId) throws Exception {
                return service.get(userId);
            }
        };
        this.userSettingFutureCache = new FutureExoCache((Loader)loader, this.userSettingCache);
    }

    public void save(UserSetting notificationSetting) {
        if (notificationSetting == null) {
            throw new IllegalArgumentException("notificationSetting argument is null");
        }
        this.userSettingCache.remove((Serializable)((Object)notificationSetting.getUserId()));
        this.userSettingService.save(notificationSetting);
    }

    public UserSetting get(String userId) {
        return (UserSetting)this.userSettingFutureCache.get((Object)this.userSettingService, (Object)userId);
    }

    public List<UserSetting> getDigestSettingForAllUser(NotificationContext context, int offset, int limit) {
        return this.userSettingService.getDigestSettingForAllUser(context, offset, limit);
    }

    public List<UserSetting> getDigestDefaultSettingForAllUser(int offset, int limit) {
        return this.userSettingService.getDigestDefaultSettingForAllUser(offset, limit);
    }

    public void initDefaultSettings(String userId) {
        this.userSettingService.initDefaultSettings(userId);
    }

    public void initDefaultSettings(User[] users) {
        this.userSettingService.initDefaultSettings(users);
    }

    public void saveLastReadDate(String userId, Long time) {
        this.userSettingCache.remove((Serializable)((Object)userId));
        this.userSettingService.saveLastReadDate(userId, time);
    }

    public void setUserEnabled(String username, boolean enabled) {
        this.userSettingCache.remove((Serializable)((Object)username));
        this.userSettingService.setUserEnabled(username, enabled);
    }
}

