/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.model.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.exoplatform.commons.api.event.data.BaseObject;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class AbtractBaseObject
implements BaseObject {
    protected static final Log LOG = ExoLogger.getLogger(AbtractBaseObject.class);
    protected String workspace;
    protected String path;
    protected String UUID;
    protected boolean isSystem = false;

    public AbtractBaseObject(String workspace, String path) {
        this.workspace = workspace;
        this.path = path;
    }

    public AbtractBaseObject(String workspace, String path, boolean isSystem) {
        this.workspace = workspace;
        this.path = path;
        this.isSystem = isSystem;
    }

    public String getName() {
        return this.path.substring(this.path.lastIndexOf("/") + 1, this.path.length());
    }

    public String getPath() {
        return this.path;
    }

    public Calendar getCreatedDate() {
        block6: {
            try {
                return this.getJCRNode().getProperty("exo:dateCreated").getDate();
            }
            catch (ValueFormatException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.error((Object)e);
                }
            }
            catch (PathNotFoundException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.error((Object)e);
                }
            }
            catch (RepositoryException e) {
                if (!LOG.isDebugEnabled()) break block6;
                LOG.error((Object)e);
            }
        }
        return null;
    }

    public Calendar getLastModifiedDate() {
        block6: {
            try {
                return this.getJCRNode().getProperty("exo:lastModifiedDate").getDate();
            }
            catch (ValueFormatException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.error((Object)e);
                }
            }
            catch (PathNotFoundException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.error((Object)e);
                }
            }
            catch (RepositoryException e) {
                if (!LOG.isDebugEnabled()) break block6;
                LOG.error((Object)e);
            }
        }
        return null;
    }

    public String getCreator() {
        block4: {
            try {
                return this.getJCRNode().getProperty("exo:owner").toString();
            }
            catch (PathNotFoundException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.error((Object)e);
                }
            }
            catch (RepositoryException e) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.error((Object)e);
            }
        }
        return null;
    }

    public String getPrimaryType() {
        block4: {
            try {
                return this.getJCRNode().getPrimaryNodeType().getName();
            }
            catch (PathNotFoundException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.error((Object)e);
                }
            }
            catch (RepositoryException e) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.error((Object)e);
            }
        }
        return null;
    }

    public List<String> getMixinTypes() {
        block4: {
            try {
                return new ArrayList<String>(Arrays.asList(((NodeImpl)this.getJCRNode()).getMixinTypeNames()));
            }
            catch (PathNotFoundException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.error((Object)e);
                }
            }
            catch (RepositoryException e) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.error((Object)e);
            }
        }
        return new ArrayList<String>();
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public String getUUID() {
        block6: {
            try {
                return this.getJCRNode().getUUID();
            }
            catch (UnsupportedRepositoryOperationException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.error((Object)e);
                }
            }
            catch (PathNotFoundException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.error((Object)e);
                }
            }
            catch (RepositoryException e) {
                if (!LOG.isDebugEnabled()) break block6;
                LOG.error((Object)e);
            }
        }
        return null;
    }

    protected Session getSession() throws LoginException, NoSuchWorkspaceException, RepositoryException {
        if (this.isSystem) {
            return CommonsUtils.getSystemSessionProvider().getSession(this.workspace, CommonsUtils.getRepository());
        }
        return CommonsUtils.getUserSessionProvider().getSession(this.workspace, CommonsUtils.getRepository());
    }

    public void save() {
        block20: {
            try {
                this.getSession().save();
            }
            catch (AccessDeniedException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.error((Object)e);
                }
            }
            catch (ItemExistsException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.error((Object)e);
                }
            }
            catch (ConstraintViolationException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.error((Object)e);
                }
            }
            catch (InvalidItemStateException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.error((Object)e);
                }
            }
            catch (VersionException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.error((Object)e);
                }
            }
            catch (LockException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.error((Object)e);
                }
            }
            catch (NoSuchNodeTypeException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.error((Object)e);
                }
            }
            catch (LoginException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.error((Object)e);
                }
            }
            catch (NoSuchWorkspaceException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.error((Object)e);
                }
            }
            catch (RepositoryException e) {
                if (!LOG.isDebugEnabled()) break block20;
                LOG.error((Object)e);
            }
        }
    }

    public String getTitle() {
        block6: {
            try {
                return this.getJCRNode().getProperty("exo:title").getString();
            }
            catch (ValueFormatException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.error((Object)e);
                }
            }
            catch (PathNotFoundException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.error((Object)e);
                }
            }
            catch (RepositoryException e) {
                if (!LOG.isDebugEnabled()) break block6;
                LOG.error((Object)e);
            }
        }
        return null;
    }

    public String getLastModifier() {
        block6: {
            try {
                return this.getJCRNode().getProperty("exo:lastModifier").getString();
            }
            catch (ValueFormatException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.error((Object)e);
                }
            }
            catch (PathNotFoundException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.error((Object)e);
                }
            }
            catch (RepositoryException e) {
                if (!LOG.isDebugEnabled()) break block6;
                LOG.error((Object)e);
            }
        }
        return null;
    }

    public String getOwner() {
        block6: {
            try {
                return this.getJCRNode().getProperty("exo:owner").getString();
            }
            catch (ValueFormatException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.error((Object)e);
                }
            }
            catch (PathNotFoundException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.error((Object)e);
                }
            }
            catch (RepositoryException e) {
                if (!LOG.isDebugEnabled()) break block6;
                LOG.error((Object)e);
            }
        }
        return null;
    }

    public List<String> getTags() {
        return new ArrayList<String>();
    }

    public String getRating() {
        return "";
    }

    public abstract String getObjectType();

    protected Node getJCRNode() {
        block8: {
            try {
                return (Node)this.getSession().getItem(this.path);
            }
            catch (PathNotFoundException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.error((Object)e);
                }
            }
            catch (LoginException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.error((Object)e);
                }
            }
            catch (NoSuchWorkspaceException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.error((Object)e);
                }
            }
            catch (RepositoryException e) {
                if (!LOG.isDebugEnabled()) break block8;
                LOG.error((Object)e);
            }
        }
        return null;
    }
}

