/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.folksonomy;

import java.util.ArrayList;
import javax.jcr.Node;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.folksonomy.UITagManager;
import org.exoplatform.ecm.webui.core.UIPagingGrid;
import org.exoplatform.services.cms.folksonomy.NewFolksonomyService;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="system:/groovy/ecm/webui/UIGridWithButton.gtmpl", events={@EventConfig(listeners={EditActionListener.class}), @EventConfig(listeners={RemoveActionListener.class}, confirm="UIFolksonomyManager.msg.confirm-delete"), @EventConfig(listeners={AddStyleActionListener.class})})
public class UITagStyleList
extends UIPagingGrid {
    static final String RANGE_PROP = "exo:styleRange";
    static final String HTML_STYLE_PROP = "exo:htmlStyle";
    private static String[] BEAN_FIELD = new String[]{"name", "documentRange", "tagHTML"};
    private static String[] ACTIONS = new String[]{"Edit", "Remove"};

    public UITagStyleList() throws Exception {
        this.getUIPageIterator().setId("TagStyleIterator");
        this.configure("name", BEAN_FIELD, ACTIONS);
    }

    public String[] getActions() {
        return new String[]{"AddStyle"};
    }

    public void refresh(int currentPage) throws Exception {
        ArrayList<TagStyleData> tagStyleList = new ArrayList<TagStyleData>();
        NewFolksonomyService newFolksonomyService = (NewFolksonomyService)this.getApplicationComponent(NewFolksonomyService.class);
        String repository = ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
        String workspace = ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getDMSSystemWorkspace(repository);
        TagStyleData tagStyleData = null;
        for (Node node : newFolksonomyService.getAllTagStyle(workspace)) {
            tagStyleData = new TagStyleData(node.getName(), this.getRangeOfStyle(node), this.getHtmlStyleOfStyle(node));
            tagStyleList.add(tagStyleData);
        }
        ListAccessImpl tagStyleListAccess = new ListAccessImpl(TagStyleData.class, tagStyleList);
        LazyPageList dataPageList = new LazyPageList((ListAccess)tagStyleListAccess, this.getUIPageIterator().getItemsPerPage());
        this.getUIPageIterator().setPageList((PageList)dataPageList);
        this.getUIPageIterator().setTotalItems(tagStyleList.size());
        if (currentPage > this.getUIPageIterator().getAvailablePage()) {
            this.getUIPageIterator().setCurrentPage(this.getUIPageIterator().getAvailablePage());
        } else {
            this.getUIPageIterator().setCurrentPage(currentPage);
        }
    }

    public String getRangeOfStyle(Node tagStyle) throws Exception {
        return tagStyle.getProperty(RANGE_PROP).getValue().getString();
    }

    public String getHtmlStyleOfStyle(Node tagStyle) throws Exception {
        return tagStyle.getProperty(HTML_STYLE_PROP).getValue().getString();
    }

    public static class RemoveActionListener
    extends EventListener<UITagStyleList> {
        public void execute(Event<UITagStyleList> event) throws Exception {
            UITagStyleList uiTagStyleList = (UITagStyleList)((Object)event.getSource());
            UITagManager uiManager = (UITagManager)uiTagStyleList.getParent();
            String selectedName = event.getRequestContext().getRequestParameter("objectId");
            Node selectedTagStyle = uiManager.getSelectedTagStyle(selectedName);
            Node parentNode = selectedTagStyle.getParent();
            selectedTagStyle.remove();
            parentNode.getSession().save();
            Utils.addEditedConfiguredData((String)selectedName, (String)"TagStyle", (String)"EditedConfiguredTagStyle", (boolean)true);
            uiTagStyleList.refresh(uiTagStyleList.getUIPageIterator().getCurrentPage());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    public static class AddStyleActionListener
    extends EventListener<UITagStyleList> {
        public void execute(Event<UITagStyleList> event) throws Exception {
            UITagStyleList uiTagStyleList = (UITagStyleList)((Object)event.getSource());
            UITagManager uiManager = (UITagManager)uiTagStyleList.getParent();
            uiManager.initTaggingFormPopup(null);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    public static class EditActionListener
    extends EventListener<UITagStyleList> {
        public void execute(Event<UITagStyleList> event) throws Exception {
            UITagStyleList uiTagStyleList = (UITagStyleList)((Object)event.getSource());
            UITagManager uiManager = (UITagManager)uiTagStyleList.getParent();
            String selectedName = event.getRequestContext().getRequestParameter("objectId");
            Node selectedTagStyle = uiManager.getSelectedTagStyle(selectedName);
            uiManager.initTaggingFormPopup(selectedTagStyle);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    public static class TagStyleData {
        private String tagName_;
        private String documentRange_;
        private String tagHTML_;

        public TagStyleData(String tagName, String documentRange, String tagHTML) {
            this.tagName_ = tagName;
            this.documentRange_ = documentRange;
            this.tagHTML_ = tagHTML;
        }

        public String getName() {
            return this.tagName_;
        }

        public String getDocumentRange() {
            return this.documentRange_;
        }

        public String getTagHTML() {
            return this.tagHTML_;
        }
    }
}

