/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.conf;

import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.job.MultiTenancyJob;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;

public class DeactiveJob
extends MultiTenancyJob {
    private static Log log_ = ExoLogger.getLogger((String)"job.forum.DesactiveJob");

    public Class<? extends MultiTenancyJob.MultiTenancyTask> getTask() {
        return DeactiveTask.class;
    }

    public class DeactiveTask
    extends MultiTenancyJob.MultiTenancyTask {
        public DeactiveTask(JobExecutionContext context, String repoName) {
            super((MultiTenancyJob)DeactiveJob.this, context, repoName);
        }

        public void run() {
            block10: {
                super.run();
                try {
                    ForumService forumService = (ForumService)this.container.getComponentInstanceOfType(ForumService.class);
                    if (forumService != null) {
                        int days;
                        JobDataMap jdatamap = this.context.getJobDetail().getJobDataMap();
                        String inactiveDays = jdatamap.getString("inactiveDays");
                        String forumName = jdatamap.getString("forumName");
                        if (inactiveDays != null && inactiveDays.length() > 0 && (days = Integer.parseInt(inactiveDays)) > 0) {
                            long oneDay = 86400000L;
                            Calendar calendar = GregorianCalendar.getInstance();
                            long currentDay = calendar.getTimeInMillis();
                            calendar.setTimeInMillis(currentDay -= (long)days * oneDay);
                            String path = forumService.getForumHomePath();
                            StringBuilder stringBuffer = new StringBuilder();
                            stringBuffer.append("/jcr:root/").append(path).append("//element(*,exo:topic)[");
                            stringBuffer.append("@exo:lastPostDate <= xs:dateTime('" + ISO8601.format((Calendar)calendar) + "') and @exo:isActive = 'true']");
                            NodeIterator iter = forumService.search(stringBuffer.toString());
                            if (iter != null) {
                                while (iter.hasNext()) {
                                    Node topic = iter.nextNode();
                                    if (forumName != null && forumName.length() > 0) {
                                        if (forumName.equals(topic.getParent().getProperty("exo:name").getString())) {
                                            topic.setProperty("exo:isActive", false);
                                            topic.save();
                                        }
                                    } else {
                                        topic.setProperty("exo:isActive", false);
                                        topic.save();
                                    }
                                    if (!log_.isDebugEnabled()) continue;
                                    log_.debug((Object)("\n\n The DeactiveJob have been running: The topic '" + topic.getProperty("exo:name").getString() + "' deactived"));
                                }
                            }
                        }
                    }
                }
                catch (NumberFormatException nfe) {
                    log_.trace((Object)("\nThe DeactiveJob can not run, a number is not format: " + nfe.getMessage() + "\n" + nfe.getCause()));
                }
                catch (Exception e) {
                    if (!log_.isDebugEnabled()) break block10;
                    log_.debug((Object)e.getMessage());
                }
            }
        }
    }
}

