/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.search.listener;

import java.util.List;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.jpa.storage.dao.ConnectionDAO;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.relationship.model.Relationship;

public class UserESListenerImpl
extends UserEventListener {
    private static final Log LOG = ExoLogger.getLogger(UserESListenerImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preDelete(User user) throws Exception {
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            IdentityManager idm = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
            Identity identity = idm.getOrCreateIdentity("organization", user.getUserName(), false);
            LOG.info("Notifying indexing service for user deletion id={}", new Object[]{identity.getId()});
            ((IndexingService)CommonsUtils.getService(IndexingService.class)).unindex("profile", identity.getId());
            this.reIndexAllConnector(identity);
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSetEnabled(User user) throws Exception {
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            IdentityManager idm = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
            Identity identity = idm.getOrCreateIdentity("organization", user.getUserName(), false);
            LOG.info("Notifying indexing service for user enable status change id={}", new Object[]{identity.getId()});
            if (!user.isEnabled()) {
                ((IndexingService)CommonsUtils.getService(IndexingService.class)).unindex("profile", identity.getId());
            } else {
                ((IndexingService)CommonsUtils.getService(IndexingService.class)).reindex("profile", identity.getId());
            }
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    private void reIndexAllConnector(Identity identity) {
        ConnectionDAO connectionDAO = (ConnectionDAO)CommonsUtils.getService(ConnectionDAO.class);
        IndexingService indexingService = (IndexingService)CommonsUtils.getService(IndexingService.class);
        long identityId = Long.parseLong(identity.getId());
        int limit = 500;
        List<Long> connections = null;
        int start = 0;
        do {
            connections = connectionDAO.getSenderIds(identityId, Relationship.Type.ALL, start, 500);
            for (Long id : connections) {
                indexingService.reindex("profile", String.valueOf(id));
            }
            start += 500;
        } while (connections.size() >= 500);
        start = 0;
        do {
            connections = connectionDAO.getReceiverIds(identityId, Relationship.Type.ALL, start, 500);
            for (Long id : connections) {
                indexingService.reindex("profile", String.valueOf(id));
            }
            start += 500;
        } while (connections.size() >= 500);
    }
}

