/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.upgrade.plugins;

import java.util.ArrayList;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class AnswerPageUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger((String)AnswerPageUpgradePlugin.class.getName());
    private static final String INTRANET = "intranet";
    private static final String NAVIGATION = "UIUserNavigationPortlet";
    private DataStorage dataStorage;

    public AnswerPageUpgradePlugin(DataStorage dataStorage, InitParams initParams) {
        super(initParams);
        this.dataStorage = dataStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Start " + ((Object)((Object)this)).getClass().getName() + "............."));
        }
        try {
            RequestLifeCycle.begin((ExoContainer)ExoContainerContext.getCurrentContainer());
            String[] stringArray = new String[]{"answers", "faq"};
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                SiteKey siteKey = new SiteKey(SiteType.PORTAL, INTRANET);
                String pageName = stringArray[i];
                PageKey pageKey = new PageKey(siteKey, pageName);
                Page page = this.dataStorage.getPage(pageKey.format());
                if (page == null) continue;
                ArrayList children = page.getChildren();
                for (int i2 = 0; i2 < children.size(); ++i2) {
                    ModelObject child = (ModelObject)children.get(i2);
                    if (!(child instanceof Container) || !NAVIGATION.equals(((Container)child).getId())) continue;
                    page.getChildren().remove(i2);
                    if (!LOG.isInfoEnabled()) break;
                    LOG.info((Object)(pageName + " removed!"));
                    break;
                }
                this.dataStorage.save(page);
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)(((Object)((Object)this)).getClass().getName() + " finished successfully!"));
            }
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"An unexpected error occurs when migrating pages:", (Throwable)e);
            }
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isAfter((String)newVersion, (String)previousVersion);
    }
}

