/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.search.connector;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.search.domain.Document;
import org.exoplatform.commons.search.index.impl.ElasticIndexingServiceConnector;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class FileindexingConnector
extends ElasticIndexingServiceConnector {
    private static final Log LOGGER = ExoLogger.getExoLogger(FileindexingConnector.class);
    public static final String TYPE = "file";
    private RepositoryService repositoryService = (RepositoryService)CommonsUtils.getService(RepositoryService.class);
    private TrashService trashService = (TrashService)CommonsUtils.getService(TrashService.class);

    public FileindexingConnector(InitParams initParams) {
        super(initParams);
    }

    public boolean isNeedIngestPipeline() {
        return true;
    }

    public String getPipelineName() {
        return TYPE;
    }

    public String getMapping() {
        StringBuilder mapping = new StringBuilder().append("{").append("  \"properties\" : {\n").append("    \"repository\" : {\"type\" : \"keyword\"},\n").append("    \"workspace\" : {\"type\" : \"keyword\"},\n").append("    \"path\" : {\"type\" : \"keyword\"},\n").append("    \"author\" : {\"type\" : \"keyword\"},\n").append("    \"permissions\" : {\"type\" : \"keyword\"},\n").append("    \"createdDate\" : {\"type\" : \"date\", \"format\": \"epoch_millis\"},\n").append("    \"activityId\" : {\"type\" : \"text\"},\n").append("    \"lastUpdatedDate\" : {\"type\" : \"date\", \"format\": \"epoch_millis\"},\n").append("    \"fileType\" : {\"type\" : \"keyword\"},\n").append("    \"fileSize\" : {\"type\" : \"long\"},\n").append("    \"name\" : {\"type\" : \"text\", \"analyzer\": \"letter_lowercase_asciifolding\"},\n").append("    \"title\" : {\"type\" : \"text\", \"analyzer\": \"letter_lowercase_asciifolding\"},\n").append("    \"dc:title\" : {\"type\" : \"text\"},\n").append("    \"dc:creator\" : {\"type\" : \"text\"},\n").append("    \"dc:subject\" : {\"type\" : \"text\"},\n").append("    \"dc:description\" : {\"type\" : \"text\"},\n").append("    \"dc:publisher\" : {\"type\" : \"text\"},\n").append("    \"dc:contributor\" : {\"type\" : \"text\"},\n").append("    \"dc:date\" : {\"type\" : \"date\", \"format\": \"epoch_millis\"},\n").append("    \"dc:resourceType\" : {\"type\" : \"text\"},\n").append("    \"dc:format\" : {\"type\" : \"text\"},\n").append("    \"dc:identifier\" : {\"type\" : \"text\"},\n").append("    \"dc:source\" : {\"type\" : \"text\"},\n").append("    \"dc:language\" : {\"type\" : \"text\"},\n").append("    \"dc:relation\" : {\"type\" : \"text\"},\n").append("    \"dc:coverage\" : {\"type\" : \"text\"},\n").append("    \"dc:rights\" : {\"type\" : \"text\"}\n").append("  }\n").append("}");
        return mapping.toString();
    }

    public String getAttachmentProcessor() {
        StringBuilder processors = new StringBuilder().append("{").append("  \"description\" : \"File processor\",\n").append("  \"processors\" : [{\n").append("    \"attachment\" : {\n").append("      \"field\" : \"file\",\n").append("      \"indexed_chars\" : -1,\n").append("      \"properties\" : [\"content\"]\n").append("    }\n").append("  },{\n").append("    \"remove\" : {\n").append("      \"field\" : \"file\"\n").append("    }\n").append("  }]\n").append("}");
        return processors.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document create(String id) {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        ExtendedSession session = null;
        try {
            Node contentNode;
            session = (ExtendedSession)WCMCoreUtils.getSystemSessionProvider().getSession("collaboration", this.repositoryService.getCurrentRepository());
            Node node = session.getNodeByIdentifier(id);
            if (node == null || !node.isNodeType("nt:file") || this.trashService.isInTrash(node) || this.isInContentFolder(node)) {
                Document document = null;
                return document;
            }
            HashMap<String, String> fields = new HashMap<String, String>();
            fields.put("name", node.getName());
            fields.put("repository", ((ManageableRepository)session.getRepository()).getConfiguration().getName());
            fields.put("workspace", session.getWorkspace().getName());
            fields.put("path", node.getPath());
            if (node.hasProperty("exo:title")) {
                fields.put("title", node.getProperty("exo:title").getString());
            } else {
                fields.put("title", node.getName());
            }
            if (node.hasProperty("exo:owner")) {
                fields.put("author", node.getProperty("exo:owner").getString());
            }
            if (node.hasProperty("jcr:created")) {
                fields.put("createdDate", String.valueOf(node.getProperty("jcr:created").getDate().getTimeInMillis()));
            }
            if (node.hasProperty("exo:lastModifiedDate")) {
                fields.put("lastUpdatedDate", String.valueOf(node.getProperty("exo:lastModifiedDate").getDate().getTimeInMillis()));
            } else {
                fields.put("lastUpdatedDate", (String)fields.get("createdDate"));
            }
            if (node.hasProperty("exo:activityId")) {
                fields.put("activityId", node.getProperty("exo:activityId").getString());
            }
            if ((contentNode = node.getNode("jcr:content")) != null) {
                if (contentNode.hasProperty("jcr:mimeType")) {
                    fields.put("fileType", contentNode.getProperty("jcr:mimeType").getString());
                }
                InputStream fileStream = contentNode.getProperty("jcr:data").getStream();
                byte[] fileBytes = IOUtils.toByteArray((InputStream)fileStream);
                fields.put(TYPE, Base64.getEncoder().encodeToString(fileBytes));
                fields.put("fileSize", String.valueOf(fileBytes.length));
                Map<String, String> dublinCoreMetadata = this.extractDublinCoreMetadata(contentNode);
                if (dublinCoreMetadata != null) {
                    fields.putAll(dublinCoreMetadata);
                }
            }
            LOGGER.info("ES document generated for file with id={} path=\"{}\"", new Object[]{id, node.getPath()});
            Document document = new Document(TYPE, id, null, new Date(), this.computePermissions(node), fields);
            return document;
        }
        catch (IOException | RepositoryException e) {
            LOGGER.error((Object)("Error while indexing file " + id), e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return null;
    }

    protected boolean isInContentFolder(Node node) {
        try {
            return node.isNodeType("exo:htmlFile") && Utils.isDocument((Node)node.getParent()) || node.isNodeType("exo:cssFile") && Utils.isDocument((Node)node.getParent().getParent()) || node.isNodeType("exo:jsFile") && Utils.isDocument((Node)node.getParent().getParent()) || node.isNodeType("nt:file") && (node.getPath().contains("/medias/images") || node.getPath().contains("/medias/videos") || node.getPath().contains("/medias/audio")) && Utils.isDocument((Node)node.getParent().getParent().getParent());
        }
        catch (Exception e) {
            return false;
        }
    }

    public Document update(String id) {
        return this.create(id);
    }

    public List<String> getAllIds(int offset, int limit) {
        ArrayList<String> allIds = new ArrayList<String>();
        try {
            Session session = WCMCoreUtils.getSystemSessionProvider().getSession("collaboration", this.repositoryService.getCurrentRepository());
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query query = queryManager.createQuery("select * from nt:file", "sql");
            QueryImpl queryImpl = (QueryImpl)query;
            queryImpl.setOffset((long)offset);
            queryImpl.setLimit((long)limit);
            QueryResult result = queryImpl.execute();
            NodeIterator nodeIterator = result.getNodes();
            while (nodeIterator.hasNext()) {
                NodeImpl node = (NodeImpl)nodeIterator.nextNode();
                allIds.add(node.getInternalIdentifier());
            }
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Error while fetching all nt:file nodes", e);
        }
        if (Thread.currentThread().isInterrupted()) {
            throw new RuntimeException("Indexing queue processing interrupted");
        }
        LOGGER.info("Fetched {} files to push in indexing queue (offset={}, limit={})", new Object[]{allIds.size(), offset, limit});
        return allIds;
    }

    protected Map<String, String> extractDublinCoreMetadata(Node contentNode) throws RepositoryException {
        HashMap<String, String> dcFields = null;
        if (contentNode.isNodeType("dc:elementSet")) {
            PropertyDefinition[] dcPropertyDefinitions;
            dcFields = new HashMap<String, String>();
            ExtendedNodeTypeManager nodeTypeManager = this.repositoryService.getCurrentRepository().getNodeTypeManager();
            for (PropertyDefinition propertyDefinition : dcPropertyDefinitions = nodeTypeManager.getNodeType("dc:elementSet").getPropertyDefinitions()) {
                Property property;
                String propertyName = propertyDefinition.getName();
                if (!contentNode.hasProperty(propertyName) || (property = contentNode.getProperty(propertyName)) == null) continue;
                String strValue = null;
                if (propertyDefinition.isMultiple()) {
                    Value[] values = property.getValues();
                    if (values != null && values.length > 0) {
                        Value value = values[0];
                        strValue = property.getType() == 5 ? String.valueOf(value.getDate().toInstant().toEpochMilli()) : value.getString();
                    }
                } else {
                    strValue = property.getType() == 5 ? String.valueOf(property.getDate().toInstant().toEpochMilli()) : property.getString();
                }
                if (strValue == null) continue;
                dcFields.put(propertyName, strValue);
            }
        }
        return dcFields;
    }

    private Set<String> computePermissions(Node node) throws RepositoryException {
        HashSet<String> permissions = new HashSet<String>();
        AccessControlList acl = ((ExtendedNode)node).getACL();
        permissions.add(acl.getOwner());
        if (acl.getPermissionEntries() != null) {
            permissions.addAll(acl.getPermissionEntries().stream().map(permission -> permission.getIdentity()).collect(Collectors.toSet()));
        }
        return permissions;
    }
}

