/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.processor;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.social.core.BaseActivityProcessorPlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.service.LinkProvider;

public class MentionsProcessor
extends BaseActivityProcessorPlugin {
    private static final Pattern pattern = Pattern.compile("@([^\\s]+)|@([^\\s]+)$");
    private UserPortalConfigService userPortalConfigService;

    public MentionsProcessor(InitParams params, UserPortalConfigService userPortalConfigService) {
        super(params);
        this.userPortalConfigService = userPortalConfigService;
    }

    @Override
    public void processActivity(ExoSocialActivity activity) {
        if (activity != null) {
            String portalOwner = null;
            try {
                portalOwner = Util.getPortalRequestContext().getPortalOwner();
            }
            catch (Exception e) {
                portalOwner = this.userPortalConfigService.getDefaultPortal();
            }
            activity.setTitle(this.substituteUsernames(portalOwner, activity.getTitle()));
            activity.setBody(this.substituteUsernames(portalOwner, activity.getBody()));
            Map<String, String> templateParams = activity.getTemplateParams();
            List<String> templateParamKeys = this.getTemplateParamKeysToFilter(activity);
            for (String key : templateParamKeys) {
                templateParams.put(key, this.substituteUsernames(portalOwner, templateParams.get(key)));
            }
        }
    }

    private String substituteUsernames(String portalOwner, String message) {
        if (message == null || message.trim().isEmpty()) {
            return message;
        }
        Matcher matcher = pattern.matcher(message);
        StringBuffer buf = new StringBuffer();
        while (matcher.find()) {
            Identity identity;
            String username = matcher.group().substring(1);
            if (username == null || username.isEmpty() || (identity = LinkProvider.getIdentityManager().getOrCreateIdentity("organization", username, false)) == null || identity.isDeleted() || !identity.isEnable()) continue;
            try {
                username = LinkProvider.getProfileLink(username, portalOwner);
            }
            catch (Exception e) {
                continue;
            }
            if (username == null) continue;
            matcher.appendReplacement(buf, username);
        }
        if (buf.length() > 0) {
            matcher.appendTail(buf);
            return buf.toString();
        }
        return message;
    }
}

