/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.wikimodel.xhtml.handler;

import java.util.ArrayList;
import java.util.Stack;
import org.xwiki.rendering.wikimodel.WikiParameter;
import org.xwiki.rendering.wikimodel.WikiParameters;
import org.xwiki.rendering.wikimodel.impl.WikiScannerUtil;
import org.xwiki.rendering.wikimodel.xhtml.handler.TagHandler;
import org.xwiki.rendering.wikimodel.xhtml.impl.XhtmlHandler;

public class CommentHandler {
    private static final String MACRO_SEPARATOR = "|-|";

    public void onComment(String content, XhtmlHandler.TagStack stack) {
        if (content.startsWith("startmacro:")) {
            if (!((Boolean)stack.getStackParameter("ignoreElements")).booleanValue()) {
                String macroName;
                WikiParameters macroParams = WikiParameters.EMPTY;
                String macroContent = null;
                String macroString = content.substring("startmacro:".length());
                int index = macroString.indexOf(MACRO_SEPARATOR);
                if (index != -1) {
                    macroName = macroString.substring(0, index);
                    if ((index = (macroString = macroString.substring(index + MACRO_SEPARATOR.length())).indexOf(MACRO_SEPARATOR)) != -1) {
                        ArrayList<WikiParameter> parameters = new ArrayList<WikiParameter>();
                        index = WikiScannerUtil.splitToPairs(macroString, parameters, null, MACRO_SEPARATOR);
                        macroParams = new WikiParameters(parameters);
                        if (macroString.length() > index) {
                            macroContent = macroString.substring(index + MACRO_SEPARATOR.length());
                        }
                    } else {
                        macroParams = WikiParameters.newWikiParameters(macroString);
                    }
                } else {
                    macroName = macroString;
                }
                Stack insideBlockElementsStack = (Stack)stack.getStackParameter("insideBlockElement");
                if (!insideBlockElementsStack.isEmpty() && ((Boolean)insideBlockElementsStack.peek()).booleanValue()) {
                    stack.getScannerContext().onMacroInline(macroName, macroParams, macroContent);
                } else {
                    TagHandler.sendEmptyLines(stack);
                    stack.getScannerContext().onMacroBlock(macroName, macroParams, macroContent);
                }
            }
            stack.pushStackParameter("ignoreElements", true);
        } else if (content.startsWith("stopmacro")) {
            stack.popStackParameter("ignoreElements");
        }
    }
}

