/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.updater;

import java.io.InputStream;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.common.jcr.KSDataLocation;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

@Managed
@NameTemplate(value={@Property(key="product.group.id", value="org.exoplatform.forum")})
@ManagedDescription(value="Plugin that allows to migration category has add new node-type.")
public class ForumServiceUpdaterPlugin
extends UpgradeProductPlugin {
    private static Log LOG = ExoLogger.getLogger(ForumServiceUpdaterPlugin.class);

    public ForumServiceUpdaterPlugin(InitParams initParams) {
        super(initParams);
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        try {
            ForumServiceUpdaterPlugin.registerNodeTypes("jar:/conf/portal/forum-nodetypes.xml", 0);
            ForumServiceUpdaterPlugin.registerNodeTypes("jar:/conf/portal/forum-migrate-nodetypes.xml", 4);
            this.upgradeCategorySpace();
            LOG.info((Object)String.format("Successfully to migrate forum from %s to %s", oldVersion, newVersion));
        }
        catch (Exception e) {
            LOG.warn((Object)String.format("Failed to migrate forum from %s to %s", oldVersion, newVersion), (Throwable)e);
        }
    }

    private void upgradeCategorySpace() throws Exception {
        KSDataLocation dataLocator = (KSDataLocation)CommonUtils.getComponent(KSDataLocation.class);
        SessionProvider sProvider = CommonUtils.createSystemProvider();
        Session session = dataLocator.getSessionManager().getSession(sProvider);
        Node cateHome = session.getRootNode().getNode(dataLocator.getForumCategoriesLocation());
        NodeIterator iter = cateHome.getNodes();
        while (iter.hasNext()) {
            this.addMixinForumCategory(iter.nextNode());
        }
        session.save();
    }

    private void addMixinForumCategory(Node cateNode) {
        try {
            if (!cateNode.isNodeType("mix:forumCategory")) {
                cateNode.addMixin("mix:forumCategory");
                cateNode.setProperty("exo:includedSpace", cateNode.getName().equals(Utils.CATEGORY_SPACE_ID_PREFIX));
            }
        }
        catch (Exception e) {
            LOG.warn((Object)String.format("Upgrade the category %s is unsuccessful", cateNode.toString()), (Throwable)e);
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isAfter((String)newVersion, (String)previousVersion);
    }

    private static void registerNodeTypes(String nodeTypeFilesName, int alreadyExistsBehaviour) throws Exception {
        ConfigurationManager configurationService = (ConfigurationManager)CommonUtils.getComponent(ConfigurationManager.class);
        InputStream isXml = configurationService.getInputStream(nodeTypeFilesName);
        RepositoryService repositoryService = (RepositoryService)CommonUtils.getComponent(RepositoryService.class);
        ExtendedNodeTypeManager ntManager = repositoryService.getCurrentRepository().getNodeTypeManager();
        ntManager.registerNodeTypes(isXml, alreadyExistsBehaviour, "text/xml");
    }
}

