/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.common.account.setup.web;

import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.platform.common.account.setup.web.AccountSetup;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.MembershipTypeHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;

public class AccountSetupService {
    private static final Log LOG = ExoLogger.getLogger(AccountSetup.class);
    public static final String ACCOUNT_SETUP_NODE = "accountSetup";
    public static final String ACCOUNT_SETUP_SKIP_PROPERTY = "accountsetup.skip";
    private static final String ADMIN_FIRST_NAME = "root";
    private static final String PLATFORM_USERS_GROUP = "/platform/administrators";
    private static final String PLATFORM_WEB_CONTRIBUTORS_GROUP = "/platform/web-contributors";
    private static final String PLATFORM_DEVELOPERS_GROUP = "/developers";
    private static final String PLATFORM_PLATFORM_USERS_GROUP = "/platform/users";
    private static final String MEMBERSHIP_TYPE_MANAGER = "*";
    private SettingService settingService;
    private OrganizationService organizationService;
    private Boolean skipSetup = null;

    public AccountSetupService(SettingService settingService, OrganizationService organizationService) {
        this.settingService = settingService;
        this.organizationService = organizationService;
    }

    public void setSkipSetup(boolean skipSetup) {
        this.skipSetup = skipSetup;
        this.settingService.set(Context.GLOBAL, Scope.GLOBAL, ACCOUNT_SETUP_NODE, SettingValue.create((String)"true"));
    }

    public boolean mustSkipAccountSetup() {
        if (this.skipSetup == null) {
            SettingValue accountSetupNode = this.settingService.get(Context.GLOBAL, Scope.GLOBAL, ACCOUNT_SETUP_NODE);
            String propertySetupSkip = PropertyManager.getProperty((String)ACCOUNT_SETUP_SKIP_PROPERTY);
            if (propertySetupSkip == null) {
                LOG.debug((Object)"Property accountsetup.skip not found in configuration.properties");
                propertySetupSkip = "false";
            }
            this.skipSetup = accountSetupNode != null || propertySetupSkip.equals("true") || PropertyManager.isDevelopping();
        }
        return this.skipSetup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createAccount(String userNameAccount, String firstNameAccount, String lastNameAccount, String emailAccount, String userPasswordAccount, String adminPassword) {
        try {
            MembershipType membershipType;
            Group group;
            RequestLifeCycle.begin((ComponentRequestLifecycle)((ComponentRequestLifecycle)this.organizationService));
            MembershipTypeHandler membershipTypeHandler = this.organizationService.getMembershipTypeHandler();
            UserHandler userHandler = this.organizationService.getUserHandler();
            User user = userHandler.createUserInstance(userNameAccount);
            user.setPassword(userPasswordAccount);
            user.setFirstName(firstNameAccount);
            user.setLastName(lastNameAccount);
            user.setEmail(emailAccount);
            try {
                userHandler.createUser(user, true);
            }
            catch (Exception e) {
                LOG.error((Object)"Can not create User", (Throwable)e);
            }
            try {
                group = this.organizationService.getGroupHandler().findGroupById(PLATFORM_USERS_GROUP);
                membershipType = membershipTypeHandler.findMembershipType(MEMBERSHIP_TYPE_MANAGER);
                this.organizationService.getMembershipHandler().linkMembership(user, group, membershipType, true);
            }
            catch (Exception e) {
                LOG.error((Object)"Can not assign *:/platform/administrators membership to the created user", (Throwable)e);
            }
            try {
                group = this.organizationService.getGroupHandler().findGroupById(PLATFORM_WEB_CONTRIBUTORS_GROUP);
                membershipType = membershipTypeHandler.findMembershipType(MEMBERSHIP_TYPE_MANAGER);
                this.organizationService.getMembershipHandler().linkMembership(user, group, membershipType, true);
            }
            catch (Exception e) {
                LOG.error((Object)"Can not assign *:/platform/web-contributors membership to the created user", (Throwable)e);
            }
            try {
                group = this.organizationService.getGroupHandler().findGroupById(PLATFORM_DEVELOPERS_GROUP);
                membershipType = membershipTypeHandler.findMembershipType(MEMBERSHIP_TYPE_MANAGER);
                this.organizationService.getMembershipHandler().linkMembership(user, group, membershipType, true);
            }
            catch (Exception e) {
                LOG.error((Object)"Can not assign *:/developers membership to the created user", (Throwable)e);
            }
            try {
                group = this.organizationService.getGroupHandler().findGroupById(PLATFORM_PLATFORM_USERS_GROUP);
                membershipType = membershipTypeHandler.findMembershipType(MEMBERSHIP_TYPE_MANAGER);
                this.organizationService.getMembershipHandler().linkMembership(user, group, membershipType, true);
            }
            catch (Exception e) {
                LOG.error((Object)"Can not assign *:/platform/users membership to the created user", (Throwable)e);
            }
            try {
                User adminUser = userHandler.findUserByName(ADMIN_FIRST_NAME);
                adminUser.setPassword(adminPassword);
                this.organizationService.getUserHandler().saveUser(adminUser, false);
            }
            catch (Exception e) {
                LOG.error((Object)"Can not set password to the created user", (Throwable)e);
            }
            this.setSkipSetup(true);
        }
        finally {
            RequestLifeCycle.end();
        }
    }
}

