/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.management.rest.annotations.RESTEndpoint;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.cms.i18n.MultiLanguageService;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.ecm.publication.NotInPublicationLifecycleException;
import org.exoplatform.services.ecm.publication.PublicationPlugin;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.jcr.sessions.ACLSessionProviderService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.core.WCMService;
import org.exoplatform.services.wcm.publication.Result;
import org.exoplatform.services.wcm.publication.WCMComposer;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.picocontainer.Startable;

@Managed
@NameTemplate(value={@Property(key="view", value="portal"), @Property(key="service", value="composer"), @Property(key="type", value="content")})
@ManagedDescription(value="WCM Composer service")
@RESTEndpoint(path="wcmcomposerservice")
public class WCMComposerImpl
implements WCMComposer,
Startable {
    public static final String EXO_RESTORELOCATION = "exo:restoreLocation";
    private RepositoryService repositoryService;
    private LinkManager linkManager;
    private PublicationService publicationService;
    private TaxonomyService taxonomyService;
    private TemplateService templateService;
    private WCMService wcmService;
    private MultiLanguageService multiLanguageService;
    private ACLSessionProviderService aclSessionProviderService;
    private TrashService trashService;
    private static final Log LOG = ExoLogger.getLogger((String)WCMComposerImpl.class.getName());
    private String templatesFilter;
    private List<String> usedOrderBy;
    private List<String> usedLanguages;
    private List<String> usedPrimaryTypes;
    private String sharedGroup;

    public WCMComposerImpl(InitParams params) throws Exception {
        ValueParam sharedGroupParam;
        if (params != null && (sharedGroupParam = params.getValueParam("sharedGroup")) != null) {
            this.sharedGroup = sharedGroupParam.getValue();
        }
        this.repositoryService = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
        this.linkManager = (LinkManager)WCMCoreUtils.getService(LinkManager.class);
        this.publicationService = (PublicationService)WCMCoreUtils.getService(PublicationService.class);
        this.templateService = (TemplateService)WCMCoreUtils.getService(TemplateService.class);
        this.wcmService = (WCMService)WCMCoreUtils.getService(WCMService.class);
        this.multiLanguageService = (MultiLanguageService)WCMCoreUtils.getService(MultiLanguageService.class);
        this.aclSessionProviderService = (ACLSessionProviderService)WCMCoreUtils.getService(ACLSessionProviderService.class);
        this.usedLanguages = new ArrayList<String>();
        this.usedLanguages.add(null);
        this.usedOrderBy = new ArrayList<String>();
        this.usedOrderBy.add(null);
        this.usedPrimaryTypes = new ArrayList<String>();
        this.usedPrimaryTypes.add(null);
    }

    @Override
    public Node getContent(String workspace, String nodeIdentifier, HashMap<String, String> filters, SessionProvider sessionProvider) throws Exception {
        String remoteUser;
        String visibility;
        String version;
        String mode;
        block11: {
            String repository;
            block10: {
                mode = filters.get("filter-mode");
                version = filters.get("filter-version");
                visibility = filters.get("filter-visibility");
                remoteUser = this.getRemoteUser();
                repository = null;
                try {
                    repository = this.repositoryService.getCurrentRepository().getConfiguration().getName();
                }
                catch (Exception e) {
                    if (!LOG.isWarnEnabled()) break block10;
                    LOG.warn((Object)e.getMessage());
                }
            }
            if (workspace == null) {
                if (nodeIdentifier.lastIndexOf("/") == 0) {
                    nodeIdentifier = nodeIdentifier.substring(1);
                }
                String[] params = nodeIdentifier.split("/");
                workspace = params[1];
                try {
                    nodeIdentifier = nodeIdentifier.substring(repository.length() + workspace.length() + 1);
                }
                catch (Exception e) {
                    if (!LOG.isWarnEnabled()) break block11;
                    LOG.warn((Object)e.getMessage());
                }
            }
        }
        Node node = null;
        try {
            if ("public".equals(visibility) && "Live".equals(mode)) {
                sessionProvider = remoteUser == null ? this.aclSessionProviderService.getAnonymSessionProvider() : this.aclSessionProviderService.getACLSessionProvider(this.getAnyUserACL());
            }
            node = this.wcmService.getReferencedContent(sessionProvider, workspace, nodeIdentifier);
        }
        catch (RepositoryException e) {
            node = this.getNodeByCategory(nodeIdentifier);
        }
        if (version == null || !"base".equals(version)) {
            node = this.getViewableContent(node, filters);
        }
        return node;
    }

    @Override
    public List<Node> getContents(String workspace, String path, HashMap<String, String> filters, SessionProvider sessionProvider) throws Exception {
        ArrayList<Node> nodes;
        block9: {
            String mode = filters.get("filter-mode");
            String version = filters.get("filter-version");
            String orderBy = filters.get("filter-order-by");
            String orderType = filters.get("filter-order-type");
            String visibility = filters.get("filter-visibility");
            String remoteUser = null;
            remoteUser = "public".equals(visibility) ? "##PUBLIC##VISIBILITY" : this.getRemoteUser();
            if ("Edit".equals(mode) && "publication:liveDate".equals(orderBy)) {
                orderBy = "exo:dateModified";
                filters.put("filter-order-by", orderBy);
            }
            if ("exo:title".equals(orderBy)) {
                if ("Live".equals(mode)) {
                    orderBy = "exo:titlePublished " + orderType + ", exo:title";
                }
                if ("exo:taxonomy".equals(this.getTypeFromPath(workspace, path, sessionProvider))) {
                    orderBy = "exo:title " + orderType + ", exo:titlePublished";
                }
                filters.put("filter-order-by", orderBy);
            }
            nodes = new ArrayList<Node>();
            try {
                if ("public".equals(visibility) && "Live".equals(mode) && remoteUser != null) {
                    sessionProvider = this.aclSessionProviderService.getACLSessionProvider(this.getAnyUserACL());
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("##### " + path + ":" + version + ":" + remoteUser + ":" + orderBy + ":" + orderType));
                }
                NodeIterator nodeIterator = this.getViewableContents(workspace, path, filters, sessionProvider, false);
                Node node = null;
                Node viewNode = null;
                while (nodeIterator != null && nodeIterator.hasNext()) {
                    node = nodeIterator.nextNode();
                    viewNode = this.getViewableContent(node, filters);
                    if (viewNode == null) continue;
                    nodes.add(viewNode);
                }
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block9;
                LOG.warn((Object)e.getMessage());
            }
        }
        return nodes;
    }

    @Override
    public Result getPaginatedContents(NodeLocation nodeLocation, HashMap<String, String> filters, SessionProvider sessionProvider) throws Exception {
        String path = nodeLocation.getPath();
        String workspace = nodeLocation.getWorkspace();
        String mode = filters.get("filter-mode");
        String version = filters.get("filter-version");
        String orderBy = filters.get("filter-order-by");
        String orderType = filters.get("filter-order-type");
        String visibility = filters.get("filter-visibility");
        String remoteUser = this.getRemoteUser();
        if ("Edit".equals(mode) && "publication:liveDate".equals(orderBy)) {
            orderBy = "exo:dateModified";
            filters.put("filter-order-by", orderBy);
        }
        if ("Live".equals(mode) && "exo:title".equals(orderBy)) {
            orderBy = "exo:titlePublished " + orderType + ", exo:title";
            filters.put("filter-order-by", orderBy);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("##### " + path + ":" + version + ":" + remoteUser + ":" + orderBy + ":" + orderType));
        }
        if ("public".equals(visibility) && "Live".equals(mode)) {
            sessionProvider = remoteUser == null ? this.aclSessionProviderService.getAnonymSessionProvider() : this.aclSessionProviderService.getACLSessionProvider(this.getAnyUserACL());
        }
        ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
        Session session = sessionProvider.getSession(workspace, manageableRepository);
        Node currentFolder = null;
        Item item = session.getItem(path);
        if (item != null) {
            currentFolder = (Node)item;
        }
        Result result = currentFolder != null && currentFolder.isNodeType("exo:taxonomy") ? this.getPaginatedTaxonomiesContent(nodeLocation, workspace, filters, sessionProvider) : this.getPaginatedNodesContent(nodeLocation, workspace, filters, sessionProvider);
        return result;
    }

    private Result getPaginatedTaxonomiesContent(NodeLocation nodeLocation, String workspace, HashMap<String, String> filters, SessionProvider sessionProvider) throws Exception {
        long totalSize;
        long limit;
        long max;
        ArrayList<Node> nodes = new ArrayList<Node>();
        long offset = filters.get("filter-offset") != null ? new Long(filters.get("filter-offset")) : 0L;
        String path = nodeLocation.getPath();
        NodeIterator taxonomyNodeIterator = this.getViewableContents(workspace, path, filters, sessionProvider, false);
        ArrayList<Node> taxonomyNodes = new ArrayList<Node>();
        Node taxonomyNode = null;
        Node taxonomyViewNode = null;
        if (taxonomyNodeIterator != null) {
            while (taxonomyNodeIterator.hasNext()) {
                taxonomyNode = taxonomyNodeIterator.nextNode();
                taxonomyViewNode = this.getViewableContent(taxonomyNode, filters);
                if (taxonomyViewNode == null) continue;
                taxonomyNodes.add(taxonomyViewNode);
            }
        }
        if ((max = offset + (limit = filters.get("filter-limit") != null ? (long)new Integer(filters.get("filter-limit")).intValue() : 0L)) > (totalSize = (long)taxonomyNodes.size())) {
            max = totalSize;
        }
        for (long i = offset; i < max; ++i) {
            nodes.add((Node)taxonomyNodes.get((int)i));
        }
        Result result = new Result(nodes, offset, totalSize, nodeLocation, filters);
        return result;
    }

    private Result getPaginatedNodesContent(NodeLocation nodeLocation, String workspace, HashMap<String, String> filters, SessionProvider sessionProvider) throws Exception {
        ArrayList<Node> nodes = new ArrayList<Node>();
        long offset = filters.get("filter-offset") != null ? new Long(filters.get("filter-offset")) : 0L;
        String path = nodeLocation.getPath();
        long totalSize = this.getViewabaleContentsSize(path, workspace, filters, sessionProvider);
        NodeIterator nodeIterator = this.getViewableContents(workspace, path, filters, sessionProvider, true);
        Node node = null;
        Node viewNode = null;
        if (nodeIterator != null) {
            while (nodeIterator.hasNext()) {
                node = nodeIterator.nextNode();
                viewNode = this.getViewableContent(node, filters);
                if (viewNode == null) continue;
                nodes.add(viewNode);
            }
        }
        Result result = new Result(nodes, offset, totalSize, nodeLocation, filters);
        return result;
    }

    private long getViewabaleContentsSize(String path, String workspace, HashMap<String, String> filters, SessionProvider sessionProvider) throws Exception {
        NodeIterator nodeIterator;
        long totalSize;
        long l = totalSize = filters.get("filter-total-number") != null ? new Long(filters.get("filter-total-number")) : 0L;
        if (totalSize == 0L && (nodeIterator = this.getViewableContents(workspace, path, filters, sessionProvider, false)) != null) {
            totalSize = nodeIterator.getSize();
        }
        return totalSize;
    }

    private NodeIterator getViewableContents(String workspace, String path, HashMap<String, String> filters, SessionProvider sessionProvider, boolean paginated) throws Exception {
        ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
        Session session = sessionProvider.getSession(workspace, manageableRepository);
        QueryManager manager = session.getWorkspace().getQueryManager();
        String defaultLanguage = filters.get("filter-language");
        String mode = filters.get("filter-mode");
        String orderBy = filters.get("filter-order-by");
        Boolean translation = Boolean.parseBoolean(filters.get("filter-translation"));
        String orderFilter = this.getOrderSQLFilter(filters);
        String recursive = filters.get("filter-recursive");
        String primaryType = filters.get("filter-primary-type");
        String queryFilter = filters.get("filter-query");
        String queryFilterFull = filters.get("filter-query-full");
        StringBuffer statement = new StringBuffer();
        boolean filterTemplates = true;
        if (queryFilterFull != null) {
            statement.append(queryFilterFull);
            this.updateSymlinkByQuery(workspace, queryFilterFull, sessionProvider);
        } else {
            this.addUsedPrimaryTypes(primaryType);
            if (primaryType == null) {
                primaryType = "nt:base";
                Node currentFolder = null;
                if ("/".equals(path)) {
                    currentFolder = session.getRootNode();
                } else {
                    Item item = session.getItem(path);
                    if (item != null) {
                        currentFolder = (Node)item;
                    }
                }
                if (currentFolder != null && currentFolder.isNodeType("exo:taxonomy")) {
                    primaryType = "exo:taxonomyLink";
                }
            } else {
                filterTemplates = false;
            }
            this.addUsedOrderBy(orderBy);
            statement.append("SELECT * FROM " + primaryType + " WHERE (jcr:path LIKE '" + path + "/%'");
            if (recursive == null || "false".equals(recursive)) {
                statement.append(" AND NOT jcr:path LIKE '" + path + "/%/%')");
            } else {
                statement.append(")");
            }
            if (translation.booleanValue()) {
                statement.append(" AND ( exo:language = '" + defaultLanguage + "')");
            }
            if ("Live".equals(mode) && !"exo:taxonomyLink".equals(primaryType)) {
                statement.append(" AND NOT publication:currentState = 'unpublished' AND (publication:currentState IS NULL OR publication:currentState = 'published' OR exo:titlePublished IS NOT NULL)");
            }
            if (filterTemplates) {
                statement.append(" AND " + this.getTemplatesSQLFilter());
            }
            if (queryFilter != null) {
                statement.append(queryFilter);
            }
            statement.append(orderFilter);
            this.updateSymlink(workspace, path, sessionProvider);
        }
        Query query = manager.createQuery(statement.toString(), "sql");
        if (paginated) {
            long limit;
            long offset = filters.get("filter-offset") != null ? new Long(filters.get("filter-offset")) : 0L;
            long l = limit = filters.get("filter-limit") != null ? new Long(filters.get("filter-limit")) : 0L;
            if (limit > 0L) {
                ((QueryImpl)query).setOffset(offset);
                ((QueryImpl)query).setLimit(limit);
            }
        }
        ((QueryImpl)query).setCaseInsensitiveOrder(true);
        return query.execute().getNodes();
    }

    private Node getViewableContent(Node node, HashMap<String, String> filters) throws Exception {
        Node viewNode = null;
        if (this.trashService == null) {
            this.trashService = (TrashService)WCMCoreUtils.getService(TrashService.class);
        }
        try {
            node = this.getTargetNode(node);
        }
        catch (AccessDeniedException ade) {
            return null;
        }
        if (node != null && this.trashService.isInTrash(node)) {
            return null;
        }
        String languageFilter = filters.get("filter-language");
        Boolean translation = Boolean.parseBoolean(filters.get("filter-translation"));
        if (languageFilter != null && translation.booleanValue()) {
            Node lnode;
            block10: {
                this.addUsedLanguage(languageFilter);
                lnode = null;
                try {
                    lnode = this.multiLanguageService.getLanguage(node, languageFilter);
                }
                catch (AccessDeniedException e) {
                    if (!LOG.isTraceEnabled()) break block10;
                    LOG.trace((Object)("AccessDenied on " + languageFilter + " translation for " + node.getPath()));
                }
            }
            if (lnode != null) {
                viewNode = this.getPublishedContent(lnode, filters);
                if (viewNode != null) {
                    return viewNode;
                }
                return null;
            }
        }
        if (node != null) {
            viewNode = this.getPublishedContent(node, filters);
        }
        return viewNode;
    }

    private Node getPublishedContent(Node node, HashMap<String, String> filters) throws Exception {
        HashMap<String, Object> context = new HashMap<String, Object>();
        String mode = filters.get("filter-mode");
        context.put("filter-mode", mode);
        context.put("portlet-mode", filters.get("portlet-mode"));
        String lifecyleName = null;
        try {
            lifecyleName = this.publicationService.getNodeLifecycleName(node);
        }
        catch (NotInPublicationLifecycleException notInPublicationLifecycleException) {
            // empty catch block
        }
        if (lifecyleName == null) {
            return node;
        }
        PublicationPlugin publicationPlugin = this.publicationService.getPublicationPlugins().get(lifecyleName);
        Node viewNode = publicationPlugin.getNodeView(node, context);
        return viewNode;
    }

    private Node getTargetNode(Node showingNode) throws Exception {
        Node targetNode = null;
        if (this.linkManager.isLink((Item)showingNode)) {
            try {
                targetNode = this.linkManager.getTarget(showingNode);
            }
            catch (ItemNotFoundException e) {
                targetNode = showingNode;
            }
        } else {
            targetNode = showingNode;
        }
        return targetNode;
    }

    public List<Node> getCategories(Node node) throws Exception {
        if (this.taxonomyService == null) {
            this.taxonomyService = (TaxonomyService)WCMCoreUtils.getService(TaxonomyService.class);
        }
        ArrayList<Node> listCategories = new ArrayList<Node>();
        List<Node> listNode = this.getAllTaxonomyTrees();
        for (Node itemNode : listNode) {
            listCategories.addAll(this.taxonomyService.getCategories(node, itemNode.getName()));
        }
        return listCategories;
    }

    List<Node> getAllTaxonomyTrees() throws RepositoryException {
        if (this.taxonomyService == null) {
            this.taxonomyService = (TaxonomyService)WCMCoreUtils.getService(TaxonomyService.class);
        }
        return this.taxonomyService.getAllTaxonomyTrees();
    }

    String displayCategory(Node node, List<Node> taxonomyTrees) {
        block3: {
            try {
                for (Node taxonomyTree : taxonomyTrees) {
                    if (!node.getPath().contains(taxonomyTree.getPath())) continue;
                    return node.getPath().replace(taxonomyTree.getPath(), taxonomyTree.getName());
                }
            }
            catch (RepositoryException e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error((Object)"Unexpected error when getting node taxonomies");
            }
        }
        return "";
    }

    @Override
    public List<String> getAllowedStates(String mode) {
        ArrayList<String> states = new ArrayList<String>();
        if ("Live".equals(mode)) {
            states.add("published");
        } else if ("Edit".equals(mode)) {
            states.add("published");
            states.add("draft");
            states.add("pending");
            states.add("staged");
            states.add("approved");
        }
        return states;
    }

    @Override
    @Managed
    @ManagedDescription(value="Clean all templates in Composer")
    public void cleanTemplates() throws Exception {
        this.templatesFilter = null;
        this.getTemplatesSQLFilter();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"WCMComposer templates have been cleaned !");
        }
    }

    @Managed
    @ManagedDescription(value="Used Languages")
    public List<String> getUsedLanguages() {
        return this.usedLanguages;
    }

    @Managed
    @ManagedDescription(value="Used Primary Types")
    public List<String> getUsedPrimaryTypes() {
        return this.usedPrimaryTypes;
    }

    @Managed
    @ManagedDescription(value="Used Order By")
    public List<String> getUsedOrderBy() {
        return this.usedOrderBy;
    }

    public void start() {
    }

    public void stop() {
    }

    private String getOrderSQLFilter(HashMap<String, String> filters) {
        StringBuffer orderQuery = new StringBuffer(" ORDER BY ");
        String orderBy = filters.get("filter-order-by");
        String orderType = filters.get("filter-order-type");
        if (orderType == null) {
            orderType = "DESC";
        }
        if (orderBy == null) {
            orderBy = "exo:title";
        }
        orderQuery.append(orderBy).append(" ").append(orderType);
        return orderQuery.toString();
    }

    private String getTemplatesSQLFilter() {
        if (this.templatesFilter != null) {
            return this.templatesFilter;
        }
        return this.updateTemplatesSQLFilter();
    }

    @Override
    public String updateTemplatesSQLFilter() {
        try {
            List documentTypes = this.templateService.getDocumentTemplates();
            StringBuffer documentTypeClause = new StringBuffer("(");
            for (int i = 0; i < documentTypes.size(); ++i) {
                String documentType = (String)documentTypes.get(i);
                documentTypeClause.append("jcr:primaryType = '" + documentType + "'");
                if (i == documentTypes.size() - 1) continue;
                documentTypeClause.append(" OR ");
            }
            this.templatesFilter = documentTypeClause.toString();
            this.templatesFilter = this.templatesFilter + " OR jcr:primaryType = 'exo:taxonomyLink' OR jcr:primaryType = 'exo:symlink')";
            return this.templatesFilter;
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Error when perform getTemlatesSQLFilter: ", (Throwable)e);
            }
            return null;
        }
    }

    private Node getNodeByCategory(String parameters) throws Exception {
        try {
            if (this.taxonomyService == null) {
                this.taxonomyService = (TaxonomyService)WCMCoreUtils.getService(TaxonomyService.class);
            }
            Node taxonomyTree = this.taxonomyService.getTaxonomyTree(parameters.split("/")[0]);
            Node symlink = taxonomyTree.getNode(parameters.substring(parameters.indexOf("/") + 1));
            return this.linkManager.getTarget(symlink);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void addUsedLanguage(String lang) {
        if (!this.usedLanguages.contains(lang)) {
            this.usedLanguages.add(lang);
        }
    }

    private void addUsedOrderBy(String orderBy) {
        if (!this.usedOrderBy.contains(orderBy)) {
            this.usedOrderBy.add(orderBy);
        }
    }

    private void addUsedPrimaryTypes(String primaryType) {
        if (!this.usedPrimaryTypes.contains(primaryType)) {
            this.usedPrimaryTypes.add(primaryType);
        }
    }

    private List<AccessControlEntry> getAnyUserACL() {
        ArrayList<AccessControlEntry> ret = new ArrayList<AccessControlEntry>();
        ret.add(new AccessControlEntry(this.sharedGroup, "read"));
        return ret;
    }

    private String getRemoteUser() {
        ConversationState conversationState = ConversationState.getCurrent();
        Identity identity = conversationState.getIdentity();
        if (identity != null && !IdentityConstants.ANONIM.equals(identity.getUserId())) {
            return identity.getUserId();
        }
        return null;
    }

    private void updateSymlink(String workspace, String path, SessionProvider sessionProvider) {
        if ("/".equals(path)) {
            path = "";
        }
        StringBuilder statement = new StringBuilder();
        statement.append("SELECT * FROM exo:symlink WHERE (jcr:path LIKE '" + path + "/%'").append(" AND NOT jcr:path LIKE '" + path + "/%/%')");
        this.updateSymlinkByQuery(workspace, statement.toString(), sessionProvider);
    }

    private void updateSymlinkByQuery(String workspace, String statement, SessionProvider sessionProvider) {
        block5: {
            try {
                ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
                Session session = sessionProvider.getSession(workspace, manageableRepository);
                QueryManager manager = session.getWorkspace().getQueryManager();
                NodeIterator iter = manager.createQuery(statement, "sql").execute().getNodes();
                while (iter.hasNext()) {
                    try {
                        Node currentNode = iter.nextNode();
                        this.linkManager.updateSymlink(currentNode);
                    }
                    catch (Exception ex) {
                        if (!LOG.isErrorEnabled()) continue;
                        LOG.error((Object)"Can not update symlink data", (Throwable)ex);
                    }
                }
            }
            catch (RepositoryException e) {
                if (!LOG.isErrorEnabled()) break block5;
                LOG.error((Object)"Can not update symlinks data", (Throwable)e);
            }
        }
    }

    private String getTypeFromPath(String workspace, String path, SessionProvider sessionProvider) throws Exception {
        ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
        Session session = sessionProvider.getSession(workspace, manageableRepository);
        Object currentFolder = null;
        try {
            Node node = (Node)session.getItem(path);
            return node.getPrimaryNodeType().getName();
        }
        catch (PathNotFoundException pne) {
            return null;
        }
    }
}

