/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.portal.idm.impl.cache.infinispan.tree;

import java.util.Collection;
import java.util.Set;
import org.gatein.portal.idm.impl.cache.infinispan.tree.Fqn;
import org.gatein.portal.idm.impl.cache.infinispan.tree.IDMTreeCacheImpl;
import org.gatein.portal.idm.impl.cache.infinispan.tree.Node;
import org.infinispan.AdvancedCache;
import org.infinispan.atomic.AtomicMap;
import org.infinispan.commons.util.Immutables;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class IDMNodeImpl
implements Node {
    private static final Log log = LogFactory.getLog(IDMNodeImpl.class);
    private final Fqn nodeFqn;
    private final AdvancedCache<Fqn, Object> cache;
    private final IDMTreeCacheImpl treeCache;
    private final Object value;

    public IDMNodeImpl(Fqn nodeFqn, AdvancedCache<Fqn, Object> cache, IDMTreeCacheImpl treeCache, Object value) {
        this.nodeFqn = nodeFqn;
        this.cache = cache;
        this.treeCache = treeCache;
        this.value = value;
    }

    @Override
    public void put(String key, Object value) {
        throw new IllegalStateException("Not supported to rewrite value of persistent node");
    }

    @Override
    public Object get(String key) {
        Object result = this.value == null ? this.cache.get((Object)this.nodeFqn) : this.value;
        if ("query_unique".equals(key)) {
            Collection collection = (Collection)result;
            return collection.iterator().next();
        }
        return result;
    }

    @Override
    public boolean removeChild(Object childName) {
        Object child;
        AtomicMap<Object, Fqn> structure = this.treeCache.getStructure(this.nodeFqn);
        Fqn childFqn = (Fqn)structure.remove(childName);
        if (childFqn == null) {
            childFqn = Fqn.fromString(this.nodeFqn + "/" + childName);
        }
        if ((child = this.cache.get((Object)childFqn)) == null) {
            return false;
        }
        if (child instanceof AtomicMap) {
            IDMNodeImpl childNode = new IDMNodeImpl(childFqn, this.cache, this.treeCache, child);
            childNode.removeChildren();
        }
        Object o = this.cache.remove((Object)childFqn);
        if (log.isTraceEnabled()) {
            log.tracef("Removed node %s", (Object)childFqn);
        }
        return o != null;
    }

    @Override
    public void removeChildren() {
        AtomicMap<Object, Fqn> atomicMap = this.treeCache.getStructure(this.nodeFqn);
        for (Object o : Immutables.immutableSetCopy((Set)atomicMap.keySet())) {
            this.removeChild(o);
        }
    }

    @Override
    public Fqn getFqn() {
        return this.nodeFqn;
    }
}

