/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.utils;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.AccessControlException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.HTMLSanitizer;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.definition.PortalContainerConfig;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.ecm.webui.form.UIOpenDocumentForm;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.cms.thumbnail.ThumbnailService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.webui.reader.ContentReader;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.UIExtension;
import org.exoplatform.webui.ext.UIExtensionManager;

public class Utils {
    public static final String WORKSPACE_NAME = "workspace";
    public static final String JCR_PATH = "path";
    public static final String DRIVE_FOLDER = "allowCreateFolder";
    public static final String MIN_WIDTH = "minwidth";
    public static final String CB_DOCUMENT_NAME = "documentName";
    public static final String CB_SCRIPT_NAME = "scriptName";
    public static final String CB_REF_DOCUMENT = "reference";
    public static final String CB_CHILD_DOCUMENT = "child";
    public static final String CB_NB_PER_PAGE = "nbPerPage";
    public static final String CB_QUERY_STATEMENT = "queryStatement";
    public static final String CB_QUERY_ISNEW = "isAddNew";
    public static final String CB_QUERY_TYPE = "queryType";
    public static final String CB_QUERY_STORE = "queryStore";
    public static final String CB_QUERY_LANGUAGE = "queryLanguage";
    public static final String CB_VIEW_TOOLBAR = "viewToolbar";
    public static final String CB_VIEW_TAGMAP = "viewTagMap";
    public static final String CB_VIEW_COMMENT = "viewComment";
    public static final String CB_VIEW_VOTE = "viewVote";
    public static final String CB_SEARCH_LOCATION = "searchLocation";
    public static final String CB_ENABLE_SEARCH_LOCATION = "enableSearch";
    public static final String CB_FILTER_CATEGORY = "filterCategory";
    public static final String EXO_AUDITABLE = "exo:auditable";
    public static final String CB_BOX_TEMPLATE = "boxTemplate";
    public static final String CB_TEMPLATE = "template";
    public static final String CB_USECASE = "usecase";
    public static final String CB_ALLOW_PUBLISH = "isAllowPublish";
    public static final String FROM_PATH = "From Path";
    public static final String USE_DOCUMENT = "Document";
    public static final String USE_JCR_QUERY = "Using a JCR query";
    public static final String USE_SCRIPT = "Using a script";
    public static final String CB_USE_FROM_PATH = "path";
    public static final String CB_USE_DOCUMENT = "detail-document";
    public static final String CB_USE_JCR_QUERY = "query";
    public static final String CB_USE_SCRIPT = "script";
    public static final String SEMI_COLON = ";";
    public static final String COLON = ":";
    public static final String SLASH = "/";
    public static final String BACKSLASH = "\\";
    public static final String EXO_CREATED_DATE = "exo:dateCreated";
    public static final String EXO_DATETIME = "exo:datetime";
    public static final String EXO_MODIFIED_DATE = "exo:dateModified";
    public static final String EXO_OWNER = "exo:owner";
    public static final String[] SPECIALCHARACTER = new String[]{";", "/", "\\", "|", ">", "<", "\"", "?", "!", "#", "$", "&", "*", "(", ")", "{", "}", "[", "]", ":", ".", "'"};
    public static final String REPOSITORY = "repository";
    public static final String VIEWS = "views";
    public static final String DRIVE = "drive";
    public static final String TRASH_HOME_NODE_PATH = "trashHomeNodePath";
    public static final String TRASH_REPOSITORY = "trashRepository";
    public static final String TRASH_WORKSPACE = "trashWorkspace";
    public static final String JCR_INFO = "jcrInfo";
    public static final String NT_UNSTRUCTURED = "nt:unstructured";
    public static final String NT_FILE = "nt:file";
    public static final String NT_FOLDER = "nt:folder";
    public static final String NT_FROZEN = "nt:frozenNode";
    public static final String EXO_TITLE = "exo:title";
    public static final String EXO_SUMMARY = "exo:summary";
    public static final String EXO_RELATION = "exo:relation";
    public static final String EXO_TAXONOMY = "exo:taxonomy";
    public static final String EXO_IMAGE = "exo:image";
    public static final String EXO_LANGUAGE = "exo:language";
    public static final String LANGUAGES = "languages";
    public static final String EXO_METADATA = "exo:metadata";
    public static final String MIX_REFERENCEABLE = "mix:referenceable";
    public static final String MIX_VERSIONABLE = "mix:versionable";
    public static final String NT_RESOURCE = "nt:resource";
    public static final String NT_BASE = "nt:base";
    public static final String DEFAULT = "default";
    public static final String JCR_CONTENT = "jcr:content";
    public static final String JCR_CONTENT_DESCRIPTION = "jcr:content/dc:description";
    public static final String JCR_MIMETYPE = "jcr:mimeType";
    public static final String JCR_FROZEN = "jcr:frozenNode";
    public static final String JCR_LASTMODIFIED = "jcr:lastModified";
    public static final String JCR_PRIMARYTYPE = "jcr:primaryType";
    public static final String JCR_DATA = "jcr:data";
    public static final String JCR_SCORE = "jcr:score";
    public static final String EXO_ROLES = "exo:roles";
    public static final String EXO_TEMPLATEFILE = "exo:templateFile";
    public static final String EXO_TEMPLATE = "exo:template";
    public static final String EXO_ACTION = "exo:action";
    public static final String EXO_ACTIONS = "exo:actions";
    public static final String MIX_LOCKABLE = "mix:lockable";
    public static final String EXO_CATEGORIZED = "exo:categorized";
    public static final String EXO_CATEGORY = "exo:category";
    public static final String EXO_HIDDENABLE = "exo:hiddenable";
    public static final String EXO_ACCESSPERMISSION = "exo:accessPermissions";
    public static final String EXO_PERMISSIONS = "exo:permissions";
    public static final String EXO_FAVOURITE = "exo:favourite";
    public static final String EXO_FAVOURITE_FOLDER = "exo:favoriteFolder";
    public static final String EXO_FAVOURITER = "exo:favouriter";
    public static final String EXO_RESTOREPATH = "exo:restorePath";
    public static final String EXO_RESTORELOCATION = "exo:restoreLocation";
    public static final String EXO_RESTORE_WORKSPACE = "exo:restoreWorkspace";
    public static final String EXO_LASTMODIFIER = "exo:lastModifier";
    public static final String EXO_TRASH_FOLDER = "exo:trashFolder";
    public static final String EXO_TOTAL = "exo:total";
    public static final String EXO_WEBCONTENT = "exo:webContent";
    public static final String EXO_RSS_ENABLE = "exo:rss-enable";
    public static final String EXO_COMMENTS = "exo:comments";
    public static final String EXO_MUSICFOLDER = "exo:musicFolder";
    public static final String EXO_VIDEOFOLDER = "exo:videoFolder";
    public static final String EXO_PICTUREFOLDER = "exo:pictureFolder";
    public static final String EXO_DOCUMENTFOLDER = "exo:documentFolder";
    public static final String EXO_SEARCHFOLDER = "exo:searchFolder";
    public static final String MIX_COMMENTABLE = "mix:commentable";
    public static final String MIX_VOTABLE = "mix:votable";
    public static final String EXO_SYMLINK = "exo:symlink";
    public static final String EXO_PRIMARYTYPE = "exo:primaryType";
    public static final String INLINE_DRAFT = "Draft";
    public static final String INLINE_PUBLISHED = "Published";
    public static final String EXO_SORTABLE = "exo:sortable";
    public static final String EXO_RISIZEABLE = "exo:documentSize";
    public static final String FLASH_MIMETYPE = "flash";
    public static final String[] SPECIFIC_FOLDERS = new String[]{"exo:musicFolder", "exo:videoFolder", "exo:pictureFolder", "exo:documentFolder", "exo:searchFolder"};
    public static final String[] FOLDERS = new String[]{"nt:unstructured", "nt:folder"};
    public static final String[] NON_EDITABLE_NODETYPES = new String[]{"nt:unstructured", "nt:folder", "nt:resource"};
    public static final String[] CATEGORY_NODE_TYPES = new String[]{"nt:folder", "nt:unstructured", "exo:taxonomy"};
    public static final String CATEGORY_MANDATORY = "categoryMandatoryWhenFileUpload";
    public static final String UPLOAD_SIZE_LIMIT_MB = "uploadFileSizeLimitMB";
    public static final String FILE_VIEWER_EXTENSION_TYPE = "org.exoplatform.ecm.dms.FileViewer";
    public static final String MIME_TYPE = "mimeType";
    public static final String LOCALE_WEBUI_DMS = "locale.portlet.i18n.WebUIDms";
    public static final String REQUESTCONTEXT = "requestcontext";
    public static final String WORKSPACE_PARAM = "workspaceName";
    public static final String SPACE_GROUP = "/spaces";
    public static final String SITES_PATH = "/sites";
    public static final String COLLABORATION_WS = "collaboration";
    public static final int USER_DEPTH = 5;
    public static final String EMPTY = "";
    public static final String PUBLIC = "Public";
    public static final String GROUP = "Group";
    public static final String SITE = "Site";
    public static final String PRIVATE = "Private";
    public static final String URL_BACKTO = "backto";
    public static final String INPUT_TEXT_AREA = "TEXTAREA";
    public static final String INPUT_WYSIWYG = "WYSIWYG";
    public static final String INPUT_TEXT = "TEXT";
    public static final String DEFAULT_CSS_NAME = "InlineText";
    public static final String LEFT2RIGHT = "left-to-right";
    public static final String RIGHT2LEFT = "right-to-left";
    protected static final String SEPARATOR = "=";
    protected static final String TOOLBAR = "toolbar";
    protected static final String CSS = "CSSData";
    protected static final String HEIGHT = "height";
    protected static final String BUTTON_DIR = "button_direction";
    protected static final String PREV_HTML = "prev_html";
    protected static final String POST_HTML = "post_html";
    protected static final String FAST_PUBLISH_LINK = "fast_publish";
    private static final Log LOG = ExoLogger.getLogger((String)Utils.class.getName());

    public static String encodeHTML(String text) {
        return text.replaceAll("&", "&amp;").replaceAll("\"", "&quot;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public static String formatNodeName(String text) {
        return text.replaceAll("'", "\\\\'");
    }

    public static boolean isVersionable(Node node) throws RepositoryException {
        return node.isNodeType(MIX_VERSIONABLE);
    }

    public static boolean isTrashHomeNode(Node node) throws RepositoryException {
        return node.isNodeType(EXO_TRASH_FOLDER);
    }

    public static boolean isInTrash(Node node) throws RepositoryException {
        TrashService trashService = (TrashService)WCMCoreUtils.getService(TrashService.class);
        return trashService.isInTrash(node);
    }

    public static boolean targetNodeAndLinkInTrash(Node currentNode) throws Exception {
        Node targetNode;
        return Utils.isInTrash(currentNode) && Utils.isSymLink(currentNode) && Utils.isInTrash(targetNode = Utils.getNodeSymLink(currentNode));
    }

    public static boolean isAbleToRestore(Node currentNode) throws Exception {
        Node restoreLocationNode;
        if (!Utils.isInTrash(currentNode)) {
            return false;
        }
        if (EXO_ACTIONS.equals(currentNode.getName()) && Utils.isInTrash(currentNode)) {
            return false;
        }
        if (Utils.targetNodeAndLinkInTrash(currentNode)) {
            return false;
        }
        if (ConversationState.getCurrent().getIdentity().getUserId().equalsIgnoreCase(WCMCoreUtils.getSuperUser())) {
            return true;
        }
        if (!currentNode.isNodeType(EXO_RESTORELOCATION)) {
            return false;
        }
        String restorePath = currentNode.getProperty(EXO_RESTOREPATH).getString();
        String restoreWorkspace = currentNode.getProperty(EXO_RESTORE_WORKSPACE).getString();
        restorePath = restorePath.substring(0, restorePath.lastIndexOf(SLASH));
        Session session = WCMCoreUtils.getUserSessionProvider().getSession(restoreWorkspace, WCMCoreUtils.getRepository());
        try {
            restoreLocationNode = restorePath == null || restorePath.length() == 0 ? session.getRootNode() : (Node)session.getItem(restorePath);
        }
        catch (Exception e) {
            return false;
        }
        return PermissionUtil.canAddNode((Node)restoreLocationNode);
    }

    public static boolean isReferenceable(Node node) throws RepositoryException {
        return node.isNodeType(MIX_REFERENCEABLE);
    }

    public static boolean isNameValid(String name, String[] regexpression) {
        for (String c : regexpression) {
            if (name != null && !name.contains(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNameEmpty(String name) {
        return name == null || name.trim().length() == 0;
    }

    public static boolean isAuditable(Node node) throws RepositoryException {
        return node.isNodeType(EXO_AUDITABLE);
    }

    public static String getIndexName(Node node) throws RepositoryException {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(node.getName());
        int index = node.getIndex();
        if (index > 1) {
            buffer.append('[');
            buffer.append(index);
            buffer.append(']');
        }
        return buffer.toString();
    }

    public static List<String> getListAllowedFileType(Node currentNode, TemplateService templateService) throws Exception {
        ArrayList<String> nodeTypes;
        block10: {
            nodeTypes = new ArrayList<String>();
            NodeTypeManager ntManager = currentNode.getSession().getWorkspace().getNodeTypeManager();
            NodeType currentNodeType = currentNode.getPrimaryNodeType();
            NodeDefinition[] childDefs = currentNodeType.getChildNodeDefinitions();
            List templates = templateService.getDocumentTemplates();
            try {
                block2: for (int i = 0; i < templates.size(); ++i) {
                    String nodeTypeName = ((String)templates.get(i)).toString();
                    NodeType nodeType = ntManager.getNodeType(nodeTypeName);
                    NodeType[] superTypes = nodeType.getSupertypes();
                    boolean isCanCreateDocument = false;
                    for (NodeDefinition nodeDefinition : childDefs) {
                        NodeType[] requiredChilds;
                        NodeType[] nodeTypeArray = requiredChilds = nodeDefinition.getRequiredPrimaryTypes();
                        int n = nodeTypeArray.length;
                        for (int j = 0; j < n; ++j) {
                            NodeType requiredChild = nodeTypeArray[j];
                            if (!nodeTypeName.equals(requiredChild.getName())) continue;
                            isCanCreateDocument = true;
                            break;
                        }
                        if (!nodeTypeName.equals(nodeDefinition.getName()) && !isCanCreateDocument) continue;
                        if (!nodeTypes.contains(nodeTypeName)) {
                            nodeTypes.add(nodeTypeName);
                        }
                        isCanCreateDocument = true;
                    }
                    if (isCanCreateDocument) continue;
                    for (NodeDefinition nodeDefinition : superTypes) {
                        for (NodeDefinition childDef : childDefs) {
                            for (NodeType requiredType : childDef.getRequiredPrimaryTypes()) {
                                if (!nodeDefinition.getName().equals(requiredType.getName())) continue;
                                if (!nodeTypes.contains(nodeTypeName)) {
                                    nodeTypes.add(nodeTypeName);
                                }
                                isCanCreateDocument = true;
                                break;
                            }
                            if (isCanCreateDocument) break;
                        }
                        if (isCanCreateDocument) continue block2;
                    }
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block10;
                LOG.error((Object)"Unexpected error", (Throwable)e);
            }
        }
        return nodeTypes;
    }

    public static String getNodeTypeIcon(Node node, String appended, String mode) throws RepositoryException {
        return org.exoplatform.services.cms.impl.Utils.getNodeTypeIcon((Node)node, (String)appended, (String)mode);
    }

    public static String getNodeTypeIcon(Node node, String appended) throws RepositoryException {
        return org.exoplatform.services.cms.impl.Utils.getNodeTypeIcon((Node)node, (String)appended);
    }

    public static NodeIterator getAuthorizedChildNodes(Node node) throws Exception {
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            if (PermissionUtil.canRead((Node)iter.nextNode())) continue;
            iter.remove();
        }
        return iter;
    }

    public static List<Node> getAuthorizedChildList(Node node) throws Exception {
        ArrayList<Node> children = new ArrayList<Node>();
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            Node child = iter.nextNode();
            if (!PermissionUtil.canRead((Node)child)) continue;
            children.add(child);
        }
        return children;
    }

    public static boolean isLockTokenHolder(Node node) throws Exception {
        return node.getLock().getLockToken() != null;
    }

    public static List<String> getMemberships() throws Exception {
        return org.exoplatform.services.cms.impl.Utils.getMemberships();
    }

    public static List<String> getGroups() throws Exception {
        ConversationState conversationState = ConversationState.getCurrent();
        Identity identity = conversationState.getIdentity();
        Set groups = identity.getGroups();
        return new ArrayList<String>(groups);
    }

    public static String getNodeOwner(Node node) throws Exception {
        try {
            if (node.hasProperty(EXO_OWNER)) {
                return node.getProperty(EXO_OWNER).getString();
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public static Node findNodeByUUID(String uuid) throws Exception {
        RepositoryService repositoryService = (RepositoryService)Util.getUIPortal().getApplicationComponent(RepositoryService.class);
        SessionProviderService sessionProviderService = (SessionProviderService)Util.getUIPortal().getApplicationComponent(SessionProviderService.class);
        SessionProvider sessionProvider = sessionProviderService.getSessionProvider(null);
        ManageableRepository manageableRepository = repositoryService.getCurrentRepository();
        Node node = null;
        for (String wsName : manageableRepository.getWorkspaceNames()) {
            try {
                node = sessionProvider.getSession(wsName, manageableRepository).getNodeByUUID(uuid);
            }
            catch (ItemNotFoundException e) {
                // empty catch block
            }
        }
        return node;
    }

    public static boolean isSymLink(Node node) throws RepositoryException {
        LinkManager linkManager = (LinkManager)Util.getUIPortal().getApplicationComponent(LinkManager.class);
        return linkManager.isLink((Item)node);
    }

    public static Node getNodeSymLink(Node node) throws Exception {
        LinkManager linkManager = (LinkManager)Util.getUIPortal().getApplicationComponent(LinkManager.class);
        Node realNode = null;
        if (linkManager.isLink((Item)node)) {
            if (linkManager.isTargetReachable(node)) {
                realNode = linkManager.getTarget(node);
            }
        } else {
            realNode = node;
        }
        return realNode;
    }

    public static InputStream extractFirstEntryFromZipFile(ZipInputStream zipStream) throws Exception {
        return zipStream.getNextEntry() == null ? null : zipStream;
    }

    public static String getThumbnailImage(InputStream input, String downloadName) throws Exception {
        DownloadService dservice = (DownloadService)WCMCoreUtils.getService(DownloadService.class);
        InputStreamDownloadResource dresource = new InputStreamDownloadResource(input, "image");
        dresource.setDownloadName(downloadName);
        return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
    }

    public static String getThumbnailImage(Node node, String propertyName) throws Exception {
        Node thumbnailNode;
        String mimeType;
        ThumbnailService thumbnailService = (ThumbnailService)Util.getUIPortal().getApplicationComponent(ThumbnailService.class);
        if (node.isNodeType(NT_FILE) && (mimeType = node.getNode(JCR_CONTENT).getProperty(JCR_MIMETYPE).getString()).startsWith("image")) {
            Node thumbnailNode2 = thumbnailService.addThumbnailNode(node);
            InputStream inputStream = node.getNode(JCR_CONTENT).getProperty(JCR_DATA).getStream();
            thumbnailService.createSpecifiedThumbnail(thumbnailNode2, ImageIO.read(inputStream), propertyName);
        }
        if ((thumbnailNode = thumbnailService.getThumbnailNode(node)) != null && thumbnailNode.hasProperty(propertyName)) {
            DownloadService dservice = (DownloadService)Util.getUIPortal().getApplicationComponent(DownloadService.class);
            InputStream input = thumbnailNode.getProperty(propertyName).getStream();
            InputStreamDownloadResource dresource = new InputStreamDownloadResource(input, "image");
            dresource.setDownloadName(node.getName());
            return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
        }
        return null;
    }

    public static String calculateFileSize(double fileLengthLong) {
        int fileLengthDigitCount = Double.toString(fileLengthLong).length();
        double fileSizeKB = 0.0;
        String howBig = EMPTY;
        if (fileLengthDigitCount < 5) {
            fileSizeKB = Math.abs(fileLengthLong);
            howBig = "Byte(s)";
        } else if (fileLengthDigitCount >= 5 && fileLengthDigitCount <= 6) {
            fileSizeKB = Math.abs(fileLengthLong / 1024.0);
            howBig = "KB";
        } else if (fileLengthDigitCount >= 7 && fileLengthDigitCount <= 9) {
            fileSizeKB = Math.abs(fileLengthLong / 1048576.0);
            howBig = "MB";
        } else if (fileLengthDigitCount > 9) {
            fileSizeKB = Math.abs(fileLengthLong / 1.073741824E9);
            howBig = "GB";
        }
        String finalResult = Utils.roundTwoDecimals(fileSizeKB);
        return finalResult + " " + howBig;
    }

    private static String roundTwoDecimals(double d) {
        DecimalFormat twoDForm = new DecimalFormat("#.##");
        return twoDForm.format(d);
    }

    public static String getResourceBundle(String key) throws MissingResourceException {
        PortalRequestContext context = Util.getPortalRequestContext();
        ResourceBundle res = context.getApplicationResourceBundle();
        return res.getString(key);
    }

    public static String getResourceBundle(String name, String key, ClassLoader cl) {
        Locale locale = WebuiRequestContext.getCurrentInstance().getLocale();
        ResourceBundleService resourceBundleService = (ResourceBundleService)WCMCoreUtils.getService(ResourceBundleService.class);
        ResourceBundle resourceBundle = resourceBundleService.getResourceBundle(name, locale, cl);
        try {
            return resourceBundle.getString(key);
        }
        catch (MissingResourceException ex) {
            return key;
        }
    }

    public static String getRestContextName(String portalContainerName) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        PortalContainerConfig portalContainerConfig = (PortalContainerConfig)container.getComponentInstance(PortalContainerConfig.class);
        return portalContainerConfig.getRestContextName(portalContainerName);
    }

    public static String getInlineEditingField(Node orgNode, String propertyName) throws Exception {
        String defaultValue = EMPTY;
        String idGenerator = EMPTY;
        Pattern p = Pattern.compile("[^a-zA-Z0-9]");
        Matcher m = p.matcher(propertyName);
        if (orgNode.hasProperty(propertyName)) {
            defaultValue = orgNode.getProperty(propertyName).getString();
        }
        idGenerator = m.replaceAll("_");
        return Utils.getInlineEditingField(orgNode, propertyName, defaultValue, INPUT_TEXT, idGenerator, DEFAULT_CSS_NAME, true, new String[0]);
    }

    public static String getInlineEditingField(Node orgNode, String propertyName, String defaultValue, String inputType, String idGenerator, String cssClass, boolean isGenericProperty, String ... arguments) throws Exception {
        String currentValue;
        String siteName;
        String currentValueID;
        String newValueInputId;
        String editFormID;
        String editBlockEditorID;
        String showBlockId;
        String cancelButton;
        String acceptButton;
        String strSuggestion;
        String uuid;
        String workspace;
        String repo;
        StringBuffer actionsb;
        StringBuffer sb;
        String published;
        String draft;
        String language;
        String publishLink;
        String bDirection;
        block20: {
            ResourceBundle resourceBundle;
            block19: {
                HashMap<String, String> parsedArguments = Utils.parseArguments(arguments);
                String height = parsedArguments.get(HEIGHT);
                bDirection = parsedArguments.get(BUTTON_DIR);
                publishLink = parsedArguments.get(FAST_PUBLISH_LINK);
                Locale locale = WebuiRequestContext.getCurrentInstance().getLocale();
                language = locale.toString();
                ResourceBundleService resourceBundleService = (ResourceBundleService)WCMCoreUtils.getService(ResourceBundleService.class);
                resourceBundle = resourceBundleService.getResourceBundle(LOCALE_WEBUI_DMS, locale);
                draft = INLINE_DRAFT;
                published = INLINE_PUBLISHED;
                try {
                    draft = StringEscapeUtils.escapeHtml((String)resourceBundle.getString("PublicationStates.draft"));
                    published = StringEscapeUtils.escapeHtml((String)resourceBundle.getString("PublicationStates.published"));
                }
                catch (MissingResourceException ex) {
                    if (!LOG.isWarnEnabled()) break block19;
                    LOG.warn((Object)"Missing resource exception of draft/published status.", (Throwable)ex);
                }
            }
            String portletRealID = WebuiRequestContext.getCurrentInstance() instanceof PortletRequestContext ? org.exoplatform.wcm.webui.Utils.getRealPortletId((PortletRequestContext)WebuiRequestContext.getCurrentInstance()) : EMPTY;
            sb = new StringBuffer();
            actionsb = new StringBuffer();
            repo = ((ManageableRepository)orgNode.getSession().getRepository()).getConfiguration().getName();
            workspace = orgNode.getSession().getWorkspace().getName();
            uuid = orgNode.getUUID();
            strSuggestion = EMPTY;
            acceptButton = EMPTY;
            cancelButton = EMPTY;
            portletRealID = portletRealID.replace('-', '_');
            showBlockId = "Current" + idGenerator + "_" + portletRealID;
            editBlockEditorID = "Edit" + idGenerator + "_" + portletRealID;
            editFormID = "Edit" + idGenerator + "Form_" + portletRealID;
            newValueInputId = "new" + idGenerator + "_" + portletRealID;
            currentValueID = "old" + idGenerator + "_" + portletRealID;
            siteName = Util.getPortalRequestContext().getPortalOwner();
            currentValue = StringUtils.replace((String)defaultValue, (String)"{portalName}", (String)siteName);
            try {
                strSuggestion = StringEscapeUtils.escapeHtml((String)resourceBundle.getString("UIPresentation.label.EditingSuggestion"));
                acceptButton = StringEscapeUtils.escapeHtml((String)resourceBundle.getString("UIPresentation.title.AcceptButton"));
                cancelButton = StringEscapeUtils.escapeHtml((String)resourceBundle.getString("UIPresentation.title.CancelButton"));
            }
            catch (MissingResourceException e) {
                if (!LOG.isWarnEnabled()) break block20;
                LOG.warn((Object)"MissingResourceException of EditingSuggestion/Accept/Cancel buttons.", (Throwable)e);
            }
        }
        actionsb.append(" return InlineEditor.presentationRequestChange");
        if (isGenericProperty) {
            actionsb.append("Property").append("('").append("/property?', '").append(propertyName).append("', '");
        } else {
            actionsb.append(cssClass).append("('");
        }
        actionsb.append(currentValueID).append("', '").append(newValueInputId).append("', '").append(repo).append("', '").append(workspace).append("', '").append(uuid).append("', '").append(editBlockEditorID).append("', '").append(showBlockId).append("', '").append(siteName).append("', '").append(language);
        if (inputType.equals(INPUT_WYSIWYG)) {
            actionsb.append("', 1);");
        } else {
            actionsb.append("');");
        }
        String strAction = actionsb.toString();
        if (orgNode.hasProperty(propertyName)) {
            try {
                String propertyValue;
                if (propertyName.equals(EXO_TITLE)) {
                    return ContentReader.getXSSCompatibilityContent(orgNode.getProperty(propertyName).getString());
                }
                if (propertyName.equals(JCR_CONTENT_DESCRIPTION)) {
                    String propertyValue2 = orgNode.getProperty(propertyName).getValues()[0].getString();
                    return HTMLSanitizer.sanitize((String)propertyValue2);
                }
                if (orgNode.getProperty(propertyName).getDefinition().isMultiple()) {
                    propertyValue = orgNode.getProperty(propertyName).getValues()[0].getString();
                    propertyValue = ContentReader.simpleEscapeHtml(propertyValue);
                } else {
                    propertyValue = orgNode.getProperty(propertyName).getString();
                }
                if (org.exoplatform.wcm.webui.Utils.getCurrentMode().equals("Live")) {
                    return StringUtils.replace((String)propertyValue, (String)"{portalName}", (String)siteName);
                }
                return "<div class=\"WCMInlineEditable\" contenteditable=\"true\" propertyName=\"" + propertyName + "\" repo=\"" + repo + "\" workspace=\"" + workspace + "\" uuid=\"" + uuid + "\" siteName=\"" + siteName + "\" publishedMsg=\"" + published + "\" draftMsg=\"" + draft + "\" fastpublishlink=\"" + publishLink + "\" language=\"" + language + "\" >" + propertyValue + "</div>";
            }
            catch (Exception e) {
                if (org.exoplatform.wcm.webui.Utils.getCurrentMode().equals("Live")) {
                    return currentValue;
                }
                return "<div class=\"WCMInlineEditable\" contenteditable=\"true\" propertyName=\"" + propertyName + "\" repo=\"" + repo + "\" workspace=\"" + workspace + "\" uuid=\"" + uuid + "\" siteName=\"" + siteName + "\" publishedMsg=\"" + published + "\" draftMsg=\"" + draft + "\" fastpublishlink=\"" + publishLink + "\" language=\"" + language + "\" >" + defaultValue + "</div>";
            }
        }
        sb.append("<div class=\"InlineEditing\" >\n");
        sb.append("\n<div rel=\"tooltip\" data-placement=\"bottom\" id=\"").append(showBlockId).append("\" Class=\"").append(cssClass).append("\"");
        sb.append("title=\"").append(strSuggestion).append("\"");
        sb.append(" onClick=\"InlineEditor.presentationSwitchBlock('").append(showBlockId).append("', '").append(editBlockEditorID).append("');\"");
        sb.append("onmouseout=\"this.className='").append(cssClass).append("';\" onblur=\"this.className='").append(cssClass).append("';\" onfocus=\"this.className='").append(cssClass).append("Hover").append("';\" onmouseover=\"this.className='").append(cssClass).append("Hover';\">").append(currentValue).append("</div>\n");
        sb.append("\t<div id=\"").append(editBlockEditorID).append("\" class=\"Edit").append(cssClass).append("\">\n");
        sb.append("\t\t<form name=\"").append(editFormID).append("\" id=\"").append(editFormID).append("\" onSubmit=\"").append(strAction).append("\">\n");
        sb.append("<DIV style=\"display:none; visible:hidden\" id=\"").append(currentValueID).append("\" name=\"").append(currentValueID).append("\">").append(currentValue).append("</DIV>");
        if (bDirection != null && bDirection.equals(LEFT2RIGHT)) {
            sb.append("\t\t<a href=\"#\" rel=\"tooltip\" data-placement=\"bottom\"").append(" class =\"AcceptButton\" style=\"float:left\" onclick=\"").append(strAction).append("\" title=\"" + acceptButton + "\">&nbsp;</a>\n");
            sb.append("\t\t<a href=\"#\" rel=\"tooltip\" data-placement=\"bottom\" class =\"CancelButton\" style=\"float:left\" ").append("onClick=\"InlineEditor.presentationSwitchBlock('");
            sb.append(editBlockEditorID).append("', '").append(showBlockId).append("');\" title=\"" + cancelButton + "\">&nbsp;</a>\n");
        } else {
            sb.append("\t\t<a href=\"#\" rel=\"tooltip\" data-placement=\"bottom\" class =\"CancelButton\" ").append("onClick=\"InlineEditor.presentationSwitchBlock('");
            sb.append(editBlockEditorID).append("', '").append(showBlockId).append("');\" title=\"" + cancelButton + "\">&nbsp;</a>\n");
            sb.append("\t\t<a href=\"#\" rel=\"tooltip\" data-placement=\"bottom\" class =\"AcceptButton\" onclick=\"").append(strAction).append("\" title=\"" + acceptButton + "\">&nbsp;</a>\n");
        }
        sb.append("\t\t<div class=\"Edit").append(cssClass).append("Input\">\n ");
        sb.append("\n\t\t</div>\n\t</form>\n</div>\n\n</div>");
        return sb.toString();
    }

    private static HashMap<String, String> parseArguments(String ... arguments) {
        HashMap<String, String> map = new HashMap<String, String>();
        int sIndex = -1;
        for (String argument : arguments) {
            String value = null;
            sIndex = argument.indexOf(SEPARATOR);
            if (sIndex <= 0) continue;
            value = argument.substring(sIndex + 1);
            if (argument.startsWith("path")) {
                map.put("path", value);
                continue;
            }
            if (argument.startsWith(TOOLBAR)) {
                map.put(TOOLBAR, value);
                continue;
            }
            if (argument.startsWith(CSS)) {
                map.put(CSS, value);
                continue;
            }
            if (argument.startsWith(HEIGHT)) {
                map.put(HEIGHT, value);
                continue;
            }
            if (argument.startsWith(BUTTON_DIR)) {
                map.put(BUTTON_DIR, value);
                continue;
            }
            if (argument.startsWith(PREV_HTML)) {
                map.put(PREV_HTML, value);
                continue;
            }
            if (argument.startsWith(POST_HTML)) {
                map.put(POST_HTML, value);
                continue;
            }
            if (!argument.startsWith(FAST_PUBLISH_LINK)) continue;
            map.put(FAST_PUBLISH_LINK, value);
        }
        return map;
    }

    public static String getTitle(Node node) throws Exception {
        String title = null;
        try {
            title = node.getProperty(EXO_TITLE).getValue().getString();
        }
        catch (PathNotFoundException pnf1) {
            try {
                Value[] values = node.getNode(JCR_CONTENT).getProperty("dc:title").getValues();
                if (values.length != 0) {
                    title = values[0].getString();
                }
            }
            catch (PathNotFoundException pnf2) {
                title = null;
            }
        }
        catch (IllegalStateException | RepositoryException e) {
            title = null;
        }
        if (StringUtils.isBlank((String)title)) {
            title = node.getName();
        }
        return URLDecoder.decode(title, "UTF-8");
    }

    public static String getName(Node node) throws Exception {
        String name = null;
        try {
            name = node.getProperty("exo:name").getValue().getString();
        }
        catch (PathNotFoundException pnf1) {
            try {
                Value[] values = node.getNode(JCR_CONTENT).getProperty("dc:name").getValues();
                if (values.length != 0) {
                    name = values[0].getString();
                }
            }
            catch (PathNotFoundException pnf2) {
                name = null;
            }
        }
        catch (IllegalStateException | RepositoryException e) {
            name = null;
        }
        return URLDecoder.decode(name, "UTF-8");
    }

    public static String getTitleWithSymlink(Node node) throws Exception {
        Node content;
        String title = null;
        Node nProcessNode = node;
        if (title == null) {
            nProcessNode = node;
            if (nProcessNode.hasProperty(EXO_TITLE)) {
                title = nProcessNode.getProperty(EXO_TITLE).getValue().getString();
            }
            if (nProcessNode.hasNode(JCR_CONTENT) && (content = nProcessNode.getNode(JCR_CONTENT)).hasProperty("dc:title")) {
                try {
                    title = content.getProperty("dc:title").getValues()[0].getString();
                }
                catch (Exception e) {
                    title = null;
                }
            }
            if (title != null) {
                title = title.trim();
            }
        }
        if (title != null && title.length() > 0) {
            return ContentReader.getXSSCompatibilityContent(title);
        }
        if (Utils.isSymLink(node)) {
            if ((nProcessNode = Utils.getNodeSymLink(nProcessNode)) == null) {
                nProcessNode = node;
            }
            if (nProcessNode.hasProperty(EXO_TITLE)) {
                title = nProcessNode.getProperty(EXO_TITLE).getValue().getString();
            }
            if (nProcessNode.hasNode(JCR_CONTENT) && (content = nProcessNode.getNode(JCR_CONTENT)).hasProperty("dc:title")) {
                try {
                    title = content.getProperty("dc:title").getValues()[0].getString();
                }
                catch (Exception e) {
                    title = null;
                }
            }
            if (title != null && (title = title.trim()).length() == 0) {
                title = null;
            }
        }
        if (title == null) {
            title = nProcessNode.getName();
        }
        return ContentReader.getXSSCompatibilityContent(title);
    }

    public static UIComponent getUIComponent(String mimeType, UIContainer container) throws Exception {
        UIExtensionManager manager = (UIExtensionManager)WCMCoreUtils.getService(UIExtensionManager.class);
        List extensions = manager.getUIExtensions(FILE_VIEWER_EXTENSION_TYPE);
        HashMap<String, String> context = new HashMap<String, String>();
        context.put(MIME_TYPE, mimeType.toLowerCase());
        for (UIExtension extension : extensions) {
            UIComponent uiComponent = manager.addUIExtension(extension, context, container);
            if (uiComponent == null) continue;
            return uiComponent;
        }
        return null;
    }

    public static boolean isMakeVersionable(Node node, String[] nodeTypes) throws Exception {
        String ws = node.getSession().getWorkspace().getName();
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        ManageableRepository manageableRepository = WCMCoreUtils.getRepository();
        Session session = sessionProvider.getSession(ws, manageableRepository);
        node = (Node)session.getItem(node.getPath());
        int deep = node.getDepth();
        for (int i = 0; i < deep; ++i) {
            Node parent = node.getParent();
            for (String nodeType : nodeTypes) {
                if (nodeType == null || nodeType.length() <= 0 || !parent.isNodeType(nodeType)) continue;
                return false;
            }
            node = parent;
        }
        return true;
    }

    public static String getCookieByCookieName(String cookieName) {
        HttpServletRequest request = Util.getPortalRequestContext().getRequest();
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        for (int loopIndex = 0; loopIndex < cookies.length; ++loopIndex) {
            Cookie cookie1 = cookies[loopIndex];
            if (!cookie1.getName().equals(cookieName)) continue;
            return cookie1.getValue();
        }
        return null;
    }

    public static String getDownloadRestServiceLink(Node node) throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        PortalContainerInfo containerInfo = (PortalContainerInfo)container.getComponentInstanceOfType(PortalContainerInfo.class);
        String portalName = containerInfo.getContainerName();
        PortalContainerConfig portalContainerConfig = (PortalContainerConfig)container.getComponentInstance(PortalContainerConfig.class);
        String restContextName = portalContainerConfig.getRestContextName(portalName);
        StringBuilder sb = new StringBuilder();
        Node currentNode = org.exoplatform.wcm.webui.Utils.getRealNode(node);
        String ndPath = currentNode.getPath();
        if (ndPath.startsWith(SLASH)) {
            ndPath = ndPath.substring(1);
        }
        String encodedPath = Utils.encodePath(ndPath, "UTF-8");
        sb.append(SLASH).append(restContextName).append("/contents/download/");
        sb.append(currentNode.getSession().getWorkspace().getName()).append(SLASH).append(encodedPath);
        if (node.isNodeType(NT_FROZEN)) {
            sb.append("?version=" + node.getParent().getName());
        }
        return sb.toString();
    }

    public static String getPDFViewerLink(Node node) throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        PortalContainerInfo containerInfo = (PortalContainerInfo)container.getComponentInstanceOfType(PortalContainerInfo.class);
        String portalName = containerInfo.getContainerName();
        PortalContainerConfig portalContainerConfig = (PortalContainerConfig)container.getComponentInstance(PortalContainerConfig.class);
        String restContextName = portalContainerConfig.getRestContextName(portalName);
        StringBuilder sb = new StringBuilder();
        String repository = ((ManageableRepository)node.getSession().getRepository()).getConfiguration().getName();
        sb.append(SLASH).append(restContextName).append("/pdfviewer/");
        sb.append(repository).append(SLASH);
        sb.append(node.getSession().getWorkspace().getName()).append(SLASH).append(node.getUUID());
        return sb.toString();
    }

    public static List<String> getAllowedFolderTypesInCurrentPath(Node currentNode, DriveData currentDrive) throws Exception {
        ArrayList<String> allowedTypes = new ArrayList<String>();
        NodeTypeImpl currentNodeType = (NodeTypeImpl)currentNode.getPrimaryNodeType();
        String[] arrFoldertypes = currentDrive.getAllowCreateFolders().split(",");
        NodeTypeManager ntManager = currentNode.getSession().getWorkspace().getNodeTypeManager();
        for (String strFolderType : arrFoldertypes) {
            NodeType folderType;
            if (strFolderType.isEmpty() || !currentNodeType.isChildNodePrimaryTypeAllowed(Constants.JCR_ANY_NAME, ((NodeTypeImpl)(folderType = ntManager.getNodeType(strFolderType))).getQName())) continue;
            allowedTypes.add(strFolderType);
        }
        return allowedTypes;
    }

    public static String[] removeChildNodes(String srcPath) {
        if (StringUtils.isEmpty((String)srcPath)) {
            return new String[0];
        }
        if (!srcPath.contains(SEMI_COLON)) {
            return new String[]{srcPath};
        }
        String[] paths = srcPath.split(SEMI_COLON);
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < paths.length; ++i) {
            boolean ok = true;
            for (int j = 0; j < paths.length; ++j) {
                if (i == j || !paths[i].startsWith(paths[j]) || paths[i].length() <= paths[j].length() || paths[i].charAt(paths[j].length()) != '/') continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            ret.add(paths[i]);
        }
        return ret.toArray(new String[0]);
    }

    public static void openDocumentInDesktop(Node currentNode, UIPopupContainer popupContainer, Event<? extends UIComponent> event) throws Exception {
        HttpServletRequest httpServletRequest = Util.getPortalRequestContext().getRequest();
        String nodePath = currentNode.getPath();
        String ws = currentNode.getSession().getWorkspace().getName();
        String repo = WCMCoreUtils.getRepository().getConfiguration().getName();
        String filePath = httpServletRequest.getScheme() + "://" + httpServletRequest.getServerName() + COLON + httpServletRequest.getServerPort() + SLASH + WCMCoreUtils.getRestContextName() + "/private/jcr/" + repo + SLASH + ws + nodePath;
        String workspaceMountPath = httpServletRequest.getScheme() + "://" + httpServletRequest.getServerName() + COLON + httpServletRequest.getServerPort() + SLASH + WCMCoreUtils.getRestContextName() + "/private/jcr/" + repo + SLASH + ws;
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)WCMCoreUtils.getService(NodeHierarchyCreator.class);
        String mountPath = ((NodeImpl)currentNode.getParent()).isRoot() ? workspaceMountPath : workspaceMountPath + Utils.checkMountPath(currentNode, Utils.generateMountURL(nodePath, ws, nodeHierarchyCreator.getJcrPath("usersPath"), nodeHierarchyCreator.getJcrPath("groupsPath")));
        if (currentNode.isLocked()) {
            String[] userLock = new String[]{currentNode.getLock().getLockOwner()};
            UIOpenDocumentForm uiOpenDocumentForm = (UIOpenDocumentForm)popupContainer.activate(UIOpenDocumentForm.class, 600);
            uiOpenDocumentForm.setId("UIReadOnlyFileConfirmMessage");
            uiOpenDocumentForm.setMessageKey("UIPopupMenu.msg.lock-node-read-only");
            uiOpenDocumentForm.setArguments(userLock);
            uiOpenDocumentForm.setFilePath(nodePath);
            uiOpenDocumentForm.setMountPath(mountPath);
            uiOpenDocumentForm.setAbsolutePath(filePath);
            event.getRequestContext().getJavascriptManager().require("SHARED/openDocumentInOffice").addScripts("eXo.ecm.OpenDocumentInOffice.showConfirmBox();");
        } else {
            event.getRequestContext().getJavascriptManager().require("SHARED/openDocumentInOffice").addScripts("eXo.ecm.OpenDocumentInOffice.openDocument('" + filePath + "', '" + mountPath + "');");
        }
        event.getRequestContext().addUIComponentToUpdateByAjax(popupContainer.getParent());
    }

    public static void logUnavaiblePreview(String path) {
        LOG.warn((Object)("Can not preview the document having path : " + path));
    }

    public static String encodePath(String path, String encoding) {
        try {
            String encodedPath = URLEncoder.encode(path, encoding);
            encodedPath = encodedPath.replaceAll("%2F", SLASH);
            return encodedPath;
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)("Failed to encode path '" + path + "' with encoding '" + encoding + "'"), (Throwable)e);
            return null;
        }
    }

    public static String generateMountURL(String nodePath, String ws, String userPath, String groupPath) {
        if (StringUtils.isNotBlank((String)nodePath) && COLLABORATION_WS.equals(ws)) {
            StringBuilder mountPath = new StringBuilder();
            String[] ancestors = nodePath.substring(1).split(SLASH);
            if (ancestors.length <= 1) {
                return SLASH;
            }
            if (nodePath.startsWith(userPath)) {
                if (ancestors.length >= 6) {
                    mountPath.append(nodePath.substring(0, nodePath.indexOf(ancestors[6]) - 1));
                } else {
                    mountPath.append(nodePath.substring(0, nodePath.indexOf(ancestors[ancestors.length - 1]) - 1));
                }
            } else if (nodePath.startsWith(groupPath + SPACE_GROUP)) {
                if (ancestors.length > 4) {
                    mountPath.append(nodePath.substring(0, nodePath.indexOf(ancestors[4]) - 1));
                } else if (ancestors.length == 4) {
                    mountPath.append(nodePath.substring(0, nodePath.indexOf(ancestors[3]) - 1));
                } else {
                    mountPath.append(groupPath + SPACE_GROUP);
                }
            } else if (nodePath.startsWith(groupPath)) {
                if (ancestors.length > 2) {
                    mountPath.append(nodePath.substring(0, nodePath.indexOf(ancestors[2]) - 1));
                } else {
                    mountPath.append(groupPath);
                }
            } else if (nodePath.startsWith(SITES_PATH)) {
                if (ancestors.length > 2) {
                    mountPath.append(nodePath.substring(0, nodePath.indexOf(ancestors[2]) - 1));
                } else {
                    mountPath.append(SITES_PATH);
                }
            } else if (ancestors.length > 4) {
                mountPath.append(nodePath.substring(0, nodePath.indexOf(ancestors[3]) - 1));
            } else if (ancestors.length > 1) {
                mountPath.append(nodePath.substring(0, nodePath.indexOf(ancestors[ancestors.length - 1]) - 1));
            }
            return mountPath.toString();
        }
        return SLASH;
    }

    private static String checkMountPath(Node node, String mountPath) throws AccessControlException, RepositoryException {
        NodeImpl parent = (NodeImpl)node.getParent();
        boolean hasPermission = false;
        while (PermissionUtil.canRead((Node)parent)) {
            hasPermission = true;
            if (mountPath.equals(parent.getPath()) || parent.isRoot()) break;
            parent = parent.getParent();
        }
        if (hasPermission) {
            return parent.getPath();
        }
        LOG.warn("Cannot mount webdav path {} You don't have read permission access", new Object[]{parent.getPath()});
        throw new AccessControlException("You don't have read permission access to " + parent.getPath());
    }

    public static class NodeTypeNameComparator
    implements Comparator<NodeType> {
        @Override
        public int compare(NodeType n1, NodeType n2) throws ClassCastException {
            String name1 = n1.getName();
            String name2 = n2.getName();
            return name1.compareToIgnoreCase(name2);
        }
    }
}

