/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.updater;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PropertyIterator;
import javax.jcr.Value;
import org.chromattic.ext.ntdef.NTFile;
import org.exoplatform.commons.api.event.EventManager;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.social.core.chromattic.entity.IdentityEntity;
import org.exoplatform.social.core.chromattic.entity.ProviderEntity;
import org.exoplatform.social.core.jpa.updater.AbstractMigrationService;
import org.exoplatform.social.core.jpa.updater.MigrationContext;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.api.SpaceStorage;
import org.exoplatform.social.core.storage.exception.NodeNotFoundException;
import org.exoplatform.social.core.storage.impl.IdentityStorageImpl;

@Managed
@ManagedDescription(value="Social migration Spaces from JCR to RDBMS.")
@NameTemplate(value={@Property(key="service", value="social"), @Property(key="view", value="migration-spaces")})
public class SpaceMigrationService
extends AbstractMigrationService<Space> {
    public static final String EVENT_LISTENER_KEY = "SOC_SPACES_MIGRATION";
    protected static final String REMOVE_LIMIT_THRESHOLD_KEY = "REMOVE_LIMIT_THRESHOLD";
    private int REMOVE_LIMIT_THRESHOLD = 20;
    private long spaceNumber = 0L;
    private String spaceQuery;
    private SpaceStorage spaceStorage;
    private Set<String> spaceMigrateFailed = new HashSet<String>();
    private Set<String> spaceCleanupFailed = new HashSet<String>();

    public SpaceMigrationService(InitParams initParams, SpaceStorage spaceStorage, IdentityStorageImpl identityStorage, EventManager<Space, String> eventManager, EntityManagerService entityManagerService) {
        super(initParams, identityStorage, eventManager, entityManagerService);
        this.LIMIT_THRESHOLD = this.getInteger(initParams, "LIMIT_THRESHOLD", 200);
        this.REMOVE_LIMIT_THRESHOLD = this.getInteger(initParams, REMOVE_LIMIT_THRESHOLD_KEY, 20);
        this.spaceStorage = spaceStorage;
    }

    @Override
    protected void beforeMigration() throws Exception {
        MigrationContext.setSpaceDone(false);
        this.spaceMigrateFailed = new HashSet<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Managed
    @ManagedDescription(value="Manual to start run migration data of spaces from JCR to RDBMS.")
    public void doMigration() throws Exception {
        RequestLifeCycle.end();
        long totalSpace = this.getNumberSpaces();
        this.LOG.info((Object)"| \\ START::Spaces migration ---------------------------------");
        long t = System.currentTimeMillis();
        long offset = 0L;
        long numberSuccessful = 0L;
        boolean cont = true;
        while (cont && !this.forceStop) {
            long batchSize = 0L;
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            boolean begunTx = this.startTx();
            ArrayList<String> spaceInTransaction = new ArrayList<String>();
            try {
                NodeIterator nodeIter = this.getSpaceNodes(offset, this.LIMIT_THRESHOLD);
                long l = batchSize = nodeIter == null ? 0L : nodeIter.getSize();
                if (batchSize == 0L) {
                    cont = false;
                    continue;
                }
                Node spaceNode = null;
                while (nodeIter.hasNext() && !this.forceStop) {
                    spaceNode = nodeIter.nextNode();
                    String spaceName = spaceNode.getName();
                    spaceInTransaction.add(spaceName);
                    this.LOG.info((Object)String.format("|  \\ START::space number: %s/%s (%s space)", ++offset, totalSpace, spaceName));
                    long t1 = System.currentTimeMillis();
                    try {
                        Space space = this.migrateSpace(spaceNode);
                        this.broadcastListener(space, space.getId());
                        ++numberSuccessful;
                    }
                    catch (Exception ex) {
                        this.LOG.error((Object)("Error while migrate the space " + spaceName), (Throwable)ex);
                        this.spaceMigrateFailed.add(spaceName);
                    }
                    this.LOG.info((Object)String.format("|  / END::space number %s (%s space) consumed %s(ms)", offset, spaceNode.getName(), System.currentTimeMillis() - t1));
                }
            }
            finally {
                try {
                    this.endTx(begunTx);
                }
                catch (Exception ex) {
                    this.spaceMigrateFailed.addAll(spaceInTransaction);
                }
                RequestLifeCycle.end();
            }
        }
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        if (this.numberFailed > 0L) {
            this.LOG.info((Object)String.format("|   Space migration failed for (%s) space(s)", this.numberFailed));
        }
        this.LOG.info((Object)String.format("| / END::Space migration for (%s) space(s) consumed %s(ms)", numberSuccessful, System.currentTimeMillis() - t));
        this.LOG.info((Object)"| \\ START::Re-indexing space(s) ---------------------------------");
        IndexingService indexingService = (IndexingService)CommonsUtils.getService(IndexingService.class);
        indexingService.reindexAll("space");
        this.LOG.info((Object)"| / END::Re-indexing space(s) ---------------------------------");
    }

    private Space migrateSpace(Node spaceNode) throws Exception {
        NTFile avatar;
        String prettyName = this.getProperty(spaceNode, "soc:name");
        Space existing = this.spaceStorage.getSpaceByPrettyName(prettyName);
        if (existing != null) {
            return existing;
        }
        Space space = new Space();
        space.setApp(this.getProperty(spaceNode, "soc:app"));
        IdentityEntity identity = this.findIdentityEntity("space", this.getProperty(spaceNode, "soc:name"));
        if (identity != null && (avatar = identity.getProfile().getAvatar()) != null) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(avatar.getContentResource().getData());
            AvatarAttachment attach = new AvatarAttachment(avatar.getName(), avatar.getName(), avatar.getContentResource().getMimeType(), (InputStream)inputStream, null, avatar.getLastModified().getTime());
            space.setAvatarAttachment(attach);
            space.setAvatarLastUpdated(Long.valueOf(avatar.getLastModified().getTime()));
            space.setAvatarUrl(this.getSession().getPath((Object)avatar));
        }
        if (spaceNode.hasProperty("soc:createdTime")) {
            space.setCreatedTime(Long.valueOf(spaceNode.getProperty("soc:createdTime").getLong()));
        } else {
            space.setCreatedTime(Long.valueOf(System.currentTimeMillis()));
        }
        space.setDescription(this.getProperty(spaceNode, "soc:description"));
        space.setDisplayName(this.getProperty(spaceNode, "soc:displayName"));
        space.setGroupId(this.getProperty(spaceNode, "soc:groupId"));
        space.setInvitedUsers(this.getProperties(spaceNode, "soc:invitedMembersId"));
        space.setManagers(this.getProperties(spaceNode, "soc:managerMembersId"));
        space.setMembers(this.getProperties(spaceNode, "soc:membersId"));
        space.setPendingUsers(this.getProperties(spaceNode, "soc:pendingMembersId"));
        space.setPrettyName(this.getProperty(spaceNode, "soc:name"));
        space.setPriority(this.getProperty(spaceNode, "soc:priority"));
        space.setRegistration(this.getProperty(spaceNode, "soc:registration"));
        space.setType("classic");
        space.setUrl(this.getProperty(spaceNode, "soc:url"));
        space.setVisibility(this.getProperty(spaceNode, "soc:visibility"));
        this.spaceStorage.saveSpace(space, true);
        return space;
    }

    @Override
    protected void afterMigration() throws Exception {
        MigrationContext.setSpaceMigrateFailed(this.spaceMigrateFailed);
        if (!this.forceStop && this.spaceMigrateFailed.size() == 0) {
            MigrationContext.setSpaceDone(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRemove() throws Exception {
        this.spaceCleanupFailed = new HashSet<String>();
        long totalSpace = this.getNumberSpaces();
        this.LOG.info((Object)"| \\ START::cleanup Spaces ---------------------------------");
        long t = System.currentTimeMillis();
        long timePerSpace = System.currentTimeMillis();
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        int offset = 0;
        long failed = 0L;
        ArrayList<String> transactionList = new ArrayList<String>();
        try {
            NodeIterator nodeIter = this.getSpaceNodes(failed, this.REMOVE_LIMIT_THRESHOLD);
            transactionList = new ArrayList();
            if (nodeIter == null || nodeIter.getSize() == 0L) {
                return;
            }
            while (nodeIter.hasNext()) {
                ++offset;
                Node node = nodeIter.nextNode();
                String name = node.getName();
                if (!MigrationContext.isForceCleanup() && (MigrationContext.getSpaceMigrateFailed().contains(name) || MigrationContext.getIdentitiesCleanupFailed().contains(name))) {
                    this.spaceCleanupFailed.add(name);
                    this.LOG.warn((Object)"Will not remove this space because the migration or cleanup identity failed");
                    continue;
                }
                String prettyName = this.getProperty(node, "soc:name");
                Space sp = this.spaceStorage.getSpaceByPrettyName(prettyName);
                if (sp == null) {
                    this.LOG.warn((Object)"Will not remove this space because the migration or cleanup identity failed");
                    this.spaceCleanupFailed.add(name);
                    continue;
                }
                transactionList.add(name);
                this.LOG.info((Object)String.format("|  \\ START::cleanup Space number: %s/%s (%s space)", offset, totalSpace, node.getName()));
                try {
                    PropertyIterator pit = node.getReferences();
                    if (pit != null && pit.getSize() > 0L) {
                        int num = 0;
                        while (pit.hasNext()) {
                            pit.nextProperty().remove();
                            if (++num % this.REMOVE_LIMIT_THRESHOLD != 0) continue;
                            this.getSession().save();
                        }
                        this.getSession().save();
                    }
                    node.remove();
                }
                catch (Exception ex) {
                    this.spaceCleanupFailed.add(name);
                    this.LOG.error((Object)("Error while remove the space " + name), (Throwable)ex);
                }
                this.LOG.info((Object)String.format("|  / END::cleanup (%s space) consumed time %s(ms)", node.getName(), System.currentTimeMillis() - timePerSpace));
                timePerSpace = System.currentTimeMillis();
                if (offset % this.REMOVE_LIMIT_THRESHOLD != 0) continue;
                try {
                    this.getSession().save();
                }
                catch (Exception ex) {
                    this.LOG.error((Object)"Exception while cleanup spaces", (Throwable)ex);
                    this.spaceCleanupFailed.addAll(transactionList);
                }
                RequestLifeCycle.end();
                RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
                failed = this.spaceCleanupFailed.size();
                nodeIter = this.getSpaceNodes(failed, this.REMOVE_LIMIT_THRESHOLD);
                transactionList = new ArrayList();
            }
            this.LOG.info((Object)String.format("| / END::cleanup Spaces migration for (%s) space consumed %s(ms)", offset, System.currentTimeMillis() - t));
        }
        finally {
            try {
                this.getSession().save();
            }
            catch (Exception ex) {
                this.LOG.error((Object)"Exception while cleanup spaces", (Throwable)ex);
                this.spaceCleanupFailed.addAll(transactionList);
                this.getSession().getJCRSession().refresh(false);
            }
            RequestLifeCycle.end();
            MigrationContext.setSpaceCleanupFailed(this.spaceCleanupFailed);
        }
    }

    @Override
    @Managed
    @ManagedDescription(value="Manual to stop run miguration data of spaces from JCR to RDBMS.")
    public void stop() {
        super.stop();
    }

    @Override
    protected String getListenerKey() {
        return EVENT_LISTENER_KEY;
    }

    private IdentityEntity findIdentityEntity(String providerId, String remoteId) throws NodeNotFoundException {
        ProviderEntity providerEntity;
        try {
            providerEntity = (ProviderEntity)this.getProviderRoot().getProviders().get(providerId);
        }
        catch (Exception ex) {
            this.lifeCycle.getProviderRoot().set(null);
            providerEntity = (ProviderEntity)this.getProviderRoot().getProviders().get(providerId);
        }
        if (providerEntity == null) {
            throw new NodeNotFoundException("The node " + providerId + " doesn't exist");
        }
        IdentityEntity identityEntity = (IdentityEntity)providerEntity.getIdentities().get(remoteId);
        if (identityEntity == null) {
            throw new NodeNotFoundException("The node " + providerId + "/" + remoteId + " doesn't exist");
        }
        return identityEntity;
    }

    private NodeIterator getSpaceNodes(long offset, int LIMIT_THRESHOLD) {
        if (this.spaceQuery == null) {
            this.spaceQuery = new StringBuffer().append("SELECT * FROM soc:spacedefinition").toString();
        }
        return this.nodes(this.spaceQuery, offset, LIMIT_THRESHOLD);
    }

    private long getNumberSpaces() {
        if (this.spaceNumber <= 0L) {
            if (this.spaceQuery == null) {
                this.spaceQuery = new StringBuffer().append("SELECT * FROM soc:spacedefinition").toString();
            }
            this.spaceNumber = this.nodes(this.spaceQuery).getSize();
        }
        return this.spaceNumber;
    }

    private String getProperty(Node spaceNode, String propName) throws Exception {
        try {
            return spaceNode.getProperty(propName).getString();
        }
        catch (Exception ex) {
            return null;
        }
    }

    private String[] getProperties(Node spaceNode, String propName) throws Exception {
        LinkedList<String> values = new LinkedList<String>();
        try {
            for (Value val : spaceNode.getProperty(propName).getValues()) {
                values.add(val.getString());
            }
            return values.toArray(new String[values.size()]);
        }
        catch (Exception ex) {
            return null;
        }
    }
}

