/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.common.branding;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.ByteArrayInputStream;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.exoplatform.platform.common.branding.Branding;
import org.exoplatform.platform.common.branding.BrandingService;
import org.exoplatform.platform.common.branding.Logo;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.rest.api.ErrorResource;

@Path(value="v1/platform/branding")
@Api(tags={"v1/platform/branding"}, value="v1/platform/branding", description="Managing branding information")
public class BrandingRestResourcesV1
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(BrandingRestResourcesV1.class);
    private BrandingService brandingService;

    public BrandingRestResourcesV1(BrandingService brandingService) {
        this.brandingService = brandingService;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Get Branding information", httpMethod="GET", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Server error when retrieving branding information")})
    public Response getBrandingInformation() {
        try {
            return Response.ok((Object)this.brandingService.getBrandingInformation()).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error when retrieving branding information", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ErrorResource("Error when retrieving branding information", e.getMessage())).build();
        }
    }

    @PUT
    @RolesAllowed(value={"administrators"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update Branding information", httpMethod="POST", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Branding information updated"), @ApiResponse(code=500, message="Server error when updating branding information")})
    public Response updateBrandingInformation(Branding branding) {
        try {
            this.brandingService.updateBrandingInformation(branding);
        }
        catch (Exception e) {
            LOG.error((Object)"Error when updating branding information", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ErrorResource("Error when updating branding information", e.getMessage())).build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Path(value="/logo")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Get Branding logo", httpMethod="GET", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Branding logo retrieved"), @ApiResponse(code=404, message="Branding logo not found"), @ApiResponse(code=500, message="Server error when retrieving branding logo")})
    public Response getBrandingLogo(@Context Request request, @ApiParam(value="'404' to return a 404 http code when no logo has been uploaded, no value to return the logo define in the configuration or the default logo") @QueryParam(value="defaultLogo") String defaultLogo) {
        long lastUpdated;
        EntityTag eTag;
        Response.ResponseBuilder builder;
        Logo logo = this.brandingService.getLogo();
        if (logo == null) {
            if ("404".equals(defaultLogo)) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            logo = this.brandingService.getDefaultLogo();
            if (logo == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
        }
        if ((builder = request.evaluatePreconditions(eTag = new EntityTag(String.valueOf(lastUpdated = logo.getUpdatedDate())))) == null) {
            ByteArrayInputStream stream = new ByteArrayInputStream(logo.getData());
            builder = Response.ok((Object)stream, (String)"image/png");
            builder.tag(eTag);
        }
        CacheControl cc = new CacheControl();
        cc.setMaxAge(86400);
        builder.cacheControl(cc);
        return builder.cacheControl(cc).build();
    }

    @GET
    @Path(value="/defaultLogo")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Get Branding default logo", httpMethod="GET", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Branding default logo retrieved"), @ApiResponse(code=404, message="Branding default logo not found"), @ApiResponse(code=500, message="Server error when retrieving branding default logo")})
    public Response getBrandingDefaultLogo(@Context Request request) {
        Logo logo = this.brandingService.getDefaultLogo();
        if (logo == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        long lastUpdated = logo.getUpdatedDate();
        EntityTag eTag = new EntityTag(String.valueOf(lastUpdated));
        Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
        if (builder == null) {
            ByteArrayInputStream stream = new ByteArrayInputStream(logo.getData());
            builder = Response.ok((Object)stream, (String)"image/png");
            builder.tag(eTag);
        }
        CacheControl cc = new CacheControl();
        cc.setMaxAge(86400);
        builder.cacheControl(cc);
        return builder.cacheControl(cc).build();
    }
}

