/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.gadget.services.Online;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.RuntimeDelegate;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.impl.RuntimeDelegateImpl;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.service.LinkProvider;

@Path(value="/online")
public class OnlineRestService
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(OnlineRestService.class);
    private static final CacheControl cacheControl;

    @GET
    @Path(value="my-contacts")
    @Produces(value={"application/json"})
    public Response myContacts(@Context SecurityContext sc, @Context UriInfo uriInfo) {
        try {
            Identity[] myConnections;
            String viewerId = this.getUserId(sc, uriInfo);
            if (viewerId == null) {
                return Response.status((int)500).cacheControl(cacheControl).build();
            }
            IdentityManager identityManager = (IdentityManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(IdentityManager.class);
            RelationshipManager relationshipManager = (RelationshipManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RelationshipManager.class);
            ActivityManager activityManager = (ActivityManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ActivityManager.class);
            Identity identity = identityManager.getOrCreateIdentity("organization", viewerId, true);
            Profile profile = identity.getProfile();
            ListAccess confirmedContacts = relationshipManager.getConnections(identity);
            ArrayList<Object> contacts = new ArrayList<Object>(confirmedContacts.getSize());
            for (Identity contact : myConnections = (Identity[])confirmedContacts.load(0, confirmedContacts.getSize())) {
                profile = contact.getProfile();
                ContactBean contactBean = new ContactBean();
                contactBean.setId(contact.getRemoteId());
                contactBean.setFullName(profile.getFullName());
                contactBean.setAvatarUrl(profile.getAvatarUrl());
                Object position = profile.getProperty("position");
                contactBean.setPosition(position == null ? null : position.toString());
                RealtimeListAccess activities = activityManager.getActivitiesWithListAccess(contact);
                ExoSocialActivity[] latestAct = (ExoSocialActivity[])activities.load(0, 1);
                contactBean.setLatestActivity(latestAct.length == 0 ? null : latestAct[0].getTitle());
                String profileLink = LinkProvider.getProfileLink((String)contact.getRemoteId());
                contactBean.setProfileLink(profileLink);
                contacts.add(contactBean);
            }
            MessageBean data = new MessageBean();
            data.setData(contacts);
            return Response.ok((Object)data, (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            LOG.debug((Object)("Exception in my-contacts REST service: " + e.getMessage()), (Throwable)e);
            return Response.status((int)500).cacheControl(cacheControl).build();
        }
    }

    @GET
    @Path(value="online-users")
    @Produces(value={"application/json"})
    public Response onlineUsers(@Context SecurityContext sc, @Context UriInfo uriInfo) {
        try {
            String viewerId = this.getUserId(sc, uriInfo);
            if (viewerId == null) {
                return Response.status((int)500).cacheControl(cacheControl).build();
            }
            ForumService forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
            List users = forumService.getOnlineUsers();
            ArrayList<Object> profiles = new ArrayList<Object>(users.size());
            for (String userId : users) {
                if (userId.equals(viewerId)) continue;
                ContactBean contactBean = new ContactBean();
                contactBean.setId(userId);
                contactBean.setFullName(forumService.getUserInfo(userId).getFullName());
                String profileLink = LinkProvider.getProfileLink((String)userId);
                contactBean.setProfileLink(profileLink);
                profiles.add(contactBean);
            }
            MessageBean data = new MessageBean();
            data.setData(profiles);
            return Response.ok((Object)data, (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            LOG.debug((Object)("Exception in online-users REST service: " + e.getMessage()), (Throwable)e);
            return Response.status((int)500).cacheControl(cacheControl).build();
        }
    }

    private String getUserId(SecurityContext sc, UriInfo uriInfo) {
        try {
            return sc.getUserPrincipal().getName();
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
        cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
    }

    public class MessageBean {
        private List<Object> data;

        public void setData(List<Object> list) {
            this.data = list;
        }

        public List<Object> getData() {
            return this.data;
        }
    }

    public class ContactBean {
        private String id;
        private String fullName;
        private String avatarUrl;
        private String position;
        private String latestActivity;
        private String profileLink;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getFullName() {
            return this.fullName;
        }

        public void setFullName(String fullName) {
            this.fullName = fullName;
        }

        public String getAvatarUrl() {
            return this.avatarUrl;
        }

        public void setAvatarUrl(String avatarUrl) {
            this.avatarUrl = avatarUrl;
        }

        public String getPosition() {
            return this.position;
        }

        public void setPosition(String position) {
            this.position = position;
        }

        public String getLatestActivity() {
            return this.latestActivity;
        }

        public void setLatestActivity(String latestActivity) {
            this.latestActivity = latestActivity;
        }

        public String getProfileLink() {
            return this.profileLink;
        }

        public void setProfileLink(String profileLink) {
            this.profileLink = profileLink;
        }
    }
}

