/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.synchronization;

import java.util.List;
import org.exoplatform.social.common.service.ProcessContext;
import org.exoplatform.social.common.service.impl.SocialServiceContextImpl;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.storage.impl.ActivityStreamStorageImpl;
import org.exoplatform.social.core.storage.impl.IdentityStorageImpl;

public class SynchronizedActivityStreamStorage
extends ActivityStreamStorageImpl {
    public SynchronizedActivityStreamStorage(IdentityStorageImpl identityStorage) {
        super(identityStorage);
    }

    @Override
    public void save(ProcessContext ctx) {
        if (SocialServiceContextImpl.getInstance().isAsync()) {
            super.save(ctx);
        } else {
            boolean created = SynchronizedActivityStreamStorage.startSynchronization();
            try {
                super.save(ctx);
            }
            finally {
                SynchronizedActivityStreamStorage.stopSynchronization(created);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unLike(Identity removedLike, ExoSocialActivity activity) {
        boolean created = SynchronizedActivityStreamStorage.startSynchronization();
        try {
            super.unLike(removedLike, activity);
        }
        finally {
            SynchronizedActivityStreamStorage.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ExoSocialActivity> getFeed(Identity owner, int offset, int limit) {
        boolean created = SynchronizedActivityStreamStorage.startSynchronization();
        try {
            List<ExoSocialActivity> list = super.getFeed(owner, offset, limit);
            return list;
        }
        finally {
            SynchronizedActivityStreamStorage.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(Identity sender, Identity receiver) {
        boolean created = SynchronizedActivityStreamStorage.startSynchronization();
        try {
            super.connect(sender, receiver);
        }
        finally {
            SynchronizedActivityStreamStorage.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteConnect(Identity sender, Identity receiver) {
        boolean created = SynchronizedActivityStreamStorage.startSynchronization();
        try {
            super.deleteConnect(sender, receiver);
        }
        finally {
            SynchronizedActivityStreamStorage.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ExoSocialActivity> getConnections(Identity owner, int offset, int limit) {
        boolean created = SynchronizedActivityStreamStorage.startSynchronization();
        try {
            List<ExoSocialActivity> list = super.getConnections(owner, offset, limit);
            return list;
        }
        finally {
            SynchronizedActivityStreamStorage.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ExoSocialActivity> getMyActivities(Identity owner, int offset, int limit) {
        boolean created = SynchronizedActivityStreamStorage.startSynchronization();
        try {
            List<ExoSocialActivity> list = super.getMyActivities(owner, offset, limit);
            return list;
        }
        finally {
            SynchronizedActivityStreamStorage.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ExoSocialActivity> getMySpaces(Identity owner, int offset, int limit) {
        boolean created = SynchronizedActivityStreamStorage.startSynchronization();
        try {
            List<ExoSocialActivity> list = super.getMySpaces(owner, offset, limit);
            return list;
        }
        finally {
            SynchronizedActivityStreamStorage.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ExoSocialActivity> getSpaceStream(Identity owner, int offset, int limit) {
        boolean created = SynchronizedActivityStreamStorage.startSynchronization();
        try {
            List<ExoSocialActivity> list = super.getSpaceStream(owner, offset, limit);
            return list;
        }
        finally {
            SynchronizedActivityStreamStorage.stopSynchronization(created);
        }
    }

    @Override
    public void update(ProcessContext ctx) {
        boolean created = SynchronizedActivityStreamStorage.startSynchronization();
        try {
            super.update(ctx);
        }
        finally {
            SynchronizedActivityStreamStorage.stopSynchronization(created);
        }
    }

    @Override
    public void updateCommenter(ProcessContext ctx) {
        boolean created = SynchronizedActivityStreamStorage.startSynchronization();
        try {
            super.updateCommenter(ctx);
        }
        finally {
            SynchronizedActivityStreamStorage.stopSynchronization(created);
        }
    }

    @Override
    public void addMentioners(ProcessContext ctx) {
        boolean created = SynchronizedActivityStreamStorage.startSynchronization();
        try {
            super.addMentioners(ctx);
        }
        finally {
            SynchronizedActivityStreamStorage.stopSynchronization(created);
        }
    }
}

