/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.calendar.service.Attachment;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.util.CalendarUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.DateUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.mail.Message;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.resources.LocaleContextInfo;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.security.ConversationState;

public class MailNotification {
    public static final String FIELD_MESSAGE = "messageName";
    public static final String FIELD_EVENT = "eventName";
    public static final String FIELD_DESCRIPTION = "description";
    public static final String FIELD_ATTACHMENTS = "attachments";
    public static final String FIELD_FROM = "from";
    public static final String FIELD_TO = "to";
    public static final String FIELD_PLACE = "place";
    public static final String FIELD_MEETING = "participant";
    public static final String EXO_EMAIL_SMTP_FROM = System.getProperty("exo.email.smtp.from", "noreply@exoplatform.com");
    private static final AtomicBoolean isRBLoaded = new AtomicBoolean();
    private static final Log LOG = ExoLogger.getExoLogger(MailNotification.class);

    public static void sendEmail(CalendarEvent event, String username) throws Exception {
        byte[] icsFile;
        if (StringUtils.isBlank((String)username)) {
            throw new IllegalArgumentException("Username could not be be null or empty");
        }
        User invitor = (User)ConversationState.getCurrent().getAttribute("UserProfile");
        if (invitor == null) {
            return;
        }
        List<Attachment> atts = event.getAttachment();
        HashMap<String, String> eXoIdMap = new HashMap<String, String>();
        String toDisplayName = MailNotification.getParticiapntsDisplayName(event);
        String emailList = MailNotification.getEmailsInivtationList(event);
        for (String s : event.getParticipant()) {
            User user = CommonsUtils.getOrganizationService().getUserHandler().findUserByName(s);
            eXoIdMap.put(user.getEmail(), s);
        }
        User user = CommonsUtils.getOrganizationService().getUserHandler().findUserByName(username);
        String[] stringArray = null;
        try (OutputStream out = ((CalendarService)CommonsUtils.getService(CalendarService.class)).getCalendarImportExports("ICalendar(.ics)").exportEventCalendar(username, event.getCalendarId(), event.getCalType(), event.getId());){
            icsFile = out.toString().getBytes("UTF-8");
        }
        catch (Throwable object) {
            stringArray = object;
            throw object;
        }
        for (String userEmail : emailList.split(CalendarUtils.COMMA)) {
            if (CalendarUtils.isEmpty(userEmail)) continue;
            String userId = (String)eXoIdMap.get(userEmail);
            ResourceBundle res = null;
            CalendarSetting calendarSetting = ((CalendarService)CommonsUtils.getService(CalendarService.class)).getCalendarSetting(userId);
            UserProfile userProfile = CommonsUtils.getOrganizationService().getUserProfileHandler().findUserProfileByName(userId);
            String lang = userProfile == null ? null : (String)userProfile.getUserInfoMap().get("user.language");
            ResourceBundleService ressourceBundleService = (ResourceBundleService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ResourceBundleService.class);
            if (lang != null && !lang.isEmpty()) {
                res = ressourceBundleService.getResourceBundle("locale.portlet.calendar.CalendarPortlet", LocaleContextInfo.getLocale((String)lang));
            }
            if (res == null) {
                res = MailNotification.getResourceBundle();
            }
            SimpleDateFormat df = new SimpleDateFormat(calendarSetting.getDateFormat() + " " + calendarSetting.getTimeFormat());
            df.setTimeZone(DateUtils.getTimeZone((String)calendarSetting.getTimeZone()));
            Message message = new Message();
            message.setSubject(MailNotification.buildMailSubject(event, df, res));
            message.setBody(MailNotification.getBodyMail(MailNotification.buildMailBody(invitor, event, toDisplayName, df, CalendarUtils.generateTimeZoneLabel(calendarSetting.getTimeZone()), res), eXoIdMap, userEmail, invitor, event, res));
            message.setTo(userEmail);
            message.setMimeType("text/html");
            message.setFrom(user.getDisplayName() + "<" + EXO_EMAIL_SMTP_FROM + ">");
            message.setReplyTo(user.getEmail());
            if (icsFile != null) {
                try (ByteArrayInputStream is = new ByteArrayInputStream(icsFile);){
                    org.exoplatform.services.mail.Attachment attachmentCal = new org.exoplatform.services.mail.Attachment();
                    attachmentCal.setInputStream((InputStream)is);
                    attachmentCal.setName("icalendar.ics");
                    attachmentCal.setMimeType("text/calendar");
                    message.addAttachment(attachmentCal);
                }
            }
            if (!atts.isEmpty()) {
                for (Attachment att : atts) {
                    org.exoplatform.services.mail.Attachment attachment = new org.exoplatform.services.mail.Attachment();
                    attachment.setInputStream(att.getInputStream());
                    attachment.setMimeType(att.getMimeType());
                    attachment.setName(att.getName());
                    message.addAttachment(attachment);
                }
            }
            ((MailService)CommonsUtils.getService(MailService.class)).sendMessage(message);
        }
    }

    public static String getEmailsInivtationList(CalendarEvent event) throws Exception {
        User invitor = (User)ConversationState.getCurrent().getAttribute("UserProfile");
        StringBuilder emaillist = new StringBuilder("");
        for (String s : event.getParticipant()) {
            User user = CommonsUtils.getOrganizationService().getUserHandler().findUserByName(s);
            if (user == null || user.getEmail().equals(invitor.getEmail())) continue;
            if (emaillist.length() > 0) {
                emaillist.append(",");
            }
            emaillist.append(user.getEmail());
        }
        return String.valueOf(emaillist);
    }

    public static String getParticiapntsDisplayName(CalendarEvent event) throws Exception {
        StringBuilder usersDisplayNameList = new StringBuilder("");
        for (String s : event.getParticipant()) {
            User user = CommonsUtils.getOrganizationService().getUserHandler().findUserByName(s);
            if (user == null) continue;
            if (usersDisplayNameList.length() > 0) {
                usersDisplayNameList.append(",");
            }
            usersDisplayNameList.append(user.getDisplayName());
        }
        return String.valueOf(usersDisplayNameList);
    }

    private static String getBodyMail(Object sbBody, Map<String, String> eXoIdMap, String userEmail, User invitor, CalendarEvent event, ResourceBundle res) throws Exception {
        StringBuilder body = new StringBuilder(sbBody.toString());
        String eXoId = CalendarUtils.isEmpty(eXoIdMap.get(userEmail)) ? "null" : eXoIdMap.get(userEmail);
        body.append("<tr>");
        body.append("<td style=\"padding: 4px;  text-align: right; vertical-align: top; white-space:nowrap;\">");
        body.append(" </td><td> <a href=\"" + MailNotification.getReplyInvitationLink(1, invitor, userEmail, eXoId, event) + "\" >" + MailNotification.getLabel(res, "yes") + "</a> - <a href=\"" + MailNotification.getReplyInvitationLink(2, invitor, userEmail, eXoId, event) + "\" >" + MailNotification.getLabel(res, "notSure") + "</a> - <a href=\"" + MailNotification.getReplyInvitationLink(0, invitor, userEmail, eXoId, event) + "\" >" + MailNotification.getLabel(res, "no") + "</a>");
        body.append("</td></tr>");
        body.append("<tr>");
        body.append("<td style=\"padding: 4px;  text-align: right; vertical-align: top; white-space:nowrap;\">");
        body.append(MailNotification.getLabel(res, "seeMoreDetails") + " </td><td><a href=\"" + MailNotification.getReplyInvitationLink(3, invitor, userEmail, eXoId, event) + "\" >" + MailNotification.getLabel(res, "importToExoCalendar") + "</a> " + MailNotification.getLabel(res, "or") + " <a href=\"" + MailNotification.getReplyInvitationLink(4, invitor, userEmail, eXoId, event) + "\" >" + MailNotification.getLabel(res, "jumpToExoCalendar") + "</a>");
        body.append("</td></tr>");
        body.append("</tbody>");
        body.append("</table>");
        body.append("</div>");
        return body.toString();
    }

    private static String getReplyInvitationLink(int answer, User invitor, String invitee, String eXoId, CalendarEvent event) throws Exception {
        String portalURL = CalendarUtils.getServerBaseUrl() + "/" + PortalContainer.getCurrentPortalContainerName();
        String restURL = portalURL + "/" + PortalContainer.getCurrentRestContextName();
        String calendarURL = portalURL + "/intranet/calendar";
        if (answer == 1 || answer == 0 || answer == 2) {
            return restURL + "/cs/calendar" + "/invitation/" + event.getCalendarId() + "/" + event.getCalType() + "/" + event.getId() + "/" + invitor.getUserName() + "/" + invitee + "/" + eXoId + "/" + answer;
        }
        if (answer == 3) {
            return calendarURL + "/invitation/import/" + invitor.getUserName() + "/" + event.getId() + "/" + event.getCalType();
        }
        if (answer == 4) {
            return calendarURL + "/invitation/detail/" + invitor.getUserName() + "/" + event.getId() + "/" + event.getCalType();
        }
        return "";
    }

    private static String buildMailBody(User invitor, CalendarEvent event, String toDisplayName, DateFormat df, String timezone, ResourceBundle res) throws Exception {
        List<Attachment> atts = event.getAttachment();
        StringBuilder sbBody = new StringBuilder();
        sbBody.append("<div style=\"margin: 20px auto; padding: 8px; background: rgb(224, 236, 255) none repeat scroll 0%; -moz-background-clip: -moz-initial; -moz-background-origin: -moz-initial; -moz-background-inline-policy: -moz-initial; width: 500px;\">");
        sbBody.append("<table style=\"margin: 0px; padding: 0px; border-collapse: collapse; border-spacing: 0px; width: 100%; line-height: 16px;\">");
        sbBody.append("<tbody>");
        sbBody.append("<tr>");
        sbBody.append("<td style=\"padding: 4px;  text-align: right; vertical-align: top; white-space:nowrap; \">" + MailNotification.getLabel(res, "fromWho") + ":</td>");
        sbBody.append("<td style=\"padding: 4px;\"> " + invitor.getDisplayName() + " (" + invitor.getEmail() + ") </td>");
        sbBody.append("</tr>");
        sbBody.append("<tr>");
        sbBody.append("<td style=\"padding: 4px;  text-align: right; vertical-align: top; white-space:nowrap;\">" + MailNotification.getLabel(res, FIELD_MESSAGE) + ":</td>");
        sbBody.append("<td style=\"padding: 4px;\">" + event.getMessage() + "</td>");
        sbBody.append("</tr>");
        sbBody.append("<tr>");
        sbBody.append("<td style=\"padding: 4px;  text-align: right; vertical-align: top; white-space:nowrap;\">" + MailNotification.getLabel(res, FIELD_EVENT) + ":</td>");
        sbBody.append("<td style=\"padding: 4px;\">" + event.getSummary() + "</td>");
        sbBody.append("</tr>");
        sbBody.append("<tr>");
        sbBody.append("<td style=\"padding: 4px;  text-align: right; vertical-align: top; white-space:nowrap;\">" + MailNotification.getLabel(res, FIELD_DESCRIPTION) + ":</td>");
        sbBody.append("<td style=\"padding: 4px;\">" + (event.getDescription() != null && event.getDescription().trim().length() > 0 ? event.getDescription() : " ") + "</td>");
        sbBody.append("</tr>");
        sbBody.append("<tr>");
        sbBody.append("<td style=\"padding: 4px;  text-align: right; vertical-align: top; white-space:nowrap;\">" + MailNotification.getLabel(res, "when") + ":</td>");
        sbBody.append("<td style=\"padding: 4px;\"> <div>" + MailNotification.getLabel(res, FIELD_FROM) + ": " + df.format(event.getFromDateTime()) + " " + timezone + "</div>");
        sbBody.append("<div>" + MailNotification.getLabel(res, FIELD_TO) + ": " + df.format(event.getToDateTime()) + " " + timezone + "</div></td>");
        sbBody.append("</tr>");
        sbBody.append("<tr>");
        sbBody.append("<td style=\"padding: 4px;  text-align: right; vertical-align: top; white-space:nowrap;\">" + MailNotification.getLabel(res, FIELD_PLACE) + ":</td>");
        sbBody.append("<td style=\"padding: 4px;\">" + (event.getLocation() != null && event.getLocation().trim().length() > 0 ? event.getLocation() : " ") + "</td>");
        sbBody.append("</tr>");
        sbBody.append("<tr>");
        sbBody.append("<td style=\"padding: 4px;  text-align: right; vertical-align: top; white-space:nowrap;\">" + MailNotification.getLabel(res, FIELD_MEETING) + "</td>");
        sbBody.append("<td style=\"padding: 4px;\">" + toDisplayName + "</td>");
        sbBody.append("</tr>");
        if (!atts.isEmpty()) {
            sbBody.append("<tr>");
            sbBody.append("<td style=\"padding: 4px;  text-align: right; vertical-align: top; white-space:nowrap;\">" + MailNotification.getLabel(res, FIELD_ATTACHMENTS) + ":</td>");
            StringBuilder sbf = new StringBuilder();
            for (Attachment att : atts) {
                if (sbf.length() > 0) {
                    sbf.append(",");
                }
                sbf.append(att.getName());
            }
            sbBody.append("<td style=\"padding: 4px;\"> (" + atts.size() + ") " + sbf.toString() + " </td>");
            sbBody.append("</tr>");
        }
        return sbBody.toString();
    }

    private static String buildMailSubject(CalendarEvent event, DateFormat df, ResourceBundle res) {
        StringBuilder sbSubject = new StringBuilder("[" + MailNotification.getLabel(res, "invitation") + "] ");
        sbSubject.append(event.getSummary());
        Date fromDateTime = event.getFromDateTime();
        if (fromDateTime != null) {
            sbSubject.append(" ");
            sbSubject.append(df.format(fromDateTime));
        }
        return sbSubject.toString();
    }

    public static String getLabel(ResourceBundle res, String label) {
        if (res != null) {
            String resKey = ".label." + label;
            try {
                return res.getString(resKey);
            }
            catch (MissingResourceException e) {
                return label;
            }
        }
        return label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceBundle getResourceBundle() throws Exception {
        ResourceBundle resourceBundle = null;
        if (!isRBLoaded.get()) {
            AtomicBoolean atomicBoolean = isRBLoaded;
            synchronized (atomicBoolean) {
                if (!isRBLoaded.get()) {
                    try {
                        resourceBundle = ((ResourceBundleService)CommonsUtils.getService(ResourceBundleService.class)).getResourceBundle("locale.portlet.calendar.CalendarPortlet", Locale.getDefault());
                    }
                    catch (MissingResourceException e) {
                        resourceBundle = null;
                    }
                    isRBLoaded.set(true);
                }
            }
        }
        return resourceBundle;
    }
}

