/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.poll.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.poll.service.Poll;

public class Utils {
    public static final String COLON = ":".intern();
    public static final int MAX_TITLE = 255;

    public static Calendar getGreenwichMeanTime() {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setLenient(false);
        int gmtoffset = calendar.get(16) + calendar.get(15);
        calendar.setTimeInMillis(System.currentTimeMillis() - (long)gmtoffset);
        return calendar;
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().length() <= 0;
    }

    public static boolean isListEmpty(List<String> list) {
        if (list == null || list.size() == 0) {
            return true;
        }
        for (String string : list) {
            if (Utils.isEmpty(string)) continue;
            return false;
        }
        return true;
    }

    public static Poll calculateVote(Poll poll, String userId, String voteOptions) throws Exception {
        ArrayList<String> userVote = new ArrayList<String>(Arrays.asList(poll.getUserVote()));
        String currentVote = "";
        for (String uv : userVote) {
            if (!uv.startsWith(userId + COLON)) continue;
            currentVote = uv;
            break;
        }
        userVote.remove(currentVote);
        if (voteOptions.indexOf(COLON) > 0) {
            voteOptions = StringUtils.join(new HashSet<String>(Arrays.asList(voteOptions.split(COLON))), (String)COLON);
        }
        userVote.add(userId + COLON + voteOptions);
        int[] votes = new int[poll.getOption().length];
        int total = userVote.size();
        for (String uv : userVote) {
            String[] uvArr = uv.split(COLON);
            for (int i = 1; i < uvArr.length; ++i) {
                int n = Integer.parseInt(uvArr[i].trim());
                votes[n] = votes[n] + 1;
            }
        }
        String[] sVotes = new String[votes.length];
        for (int i = 0; i < sVotes.length; ++i) {
            sVotes[i] = (float)votes[i] / (float)total * 100.0f + "";
        }
        poll.setUserVote(userVote.toArray(new String[0]));
        poll.setVote(sVotes);
        return poll;
    }

    public static String getInfoVote(Poll poll) {
        StringBuilder sb = new StringBuilder();
        String[] infoVote = poll.getInfoVote();
        String[] options = poll.getOption();
        if (infoVote == null) {
            for (int j = 0; j < options.length; ++j) {
                sb.append(options[j]).append(":0%:0|");
            }
            sb.append("0");
        } else {
            for (int i = 0; i < infoVote.length - 1; ++i) {
                String[] list = infoVote[i].split(":");
                if (Integer.parseInt(list[1].split("\\.")[0]) > 1) {
                    sb.append(options[i]).append(":").append(list[0]).append("%:").append(list[1].split("\\.")[0]).append("|");
                    continue;
                }
                sb.append(options[i]).append(":").append(list[0]).append("%:").append(list[1].split("\\.")[0]).append("|");
            }
            if (Integer.parseInt(infoVote[infoVote.length - 1]) > 1) {
                sb.append(infoVote[infoVote.length - 1]);
            } else {
                sb.append(infoVote[infoVote.length - 1]);
            }
        }
        return sb.toString();
    }

    public static String getUserVote(Poll poll, String userName) {
        StringBuilder sb = new StringBuilder();
        String[] votes = poll.getUserVote();
        String[] options = poll.getOption();
        if (votes.length == 0) {
            return sb.toString().trim();
        }
        for (String element : votes) {
            String[] userVote = element.split(":");
            if (!userVote[0].equals(userName)) continue;
            for (int i = 1; i < userVote.length; ++i) {
                int j = Integer.parseInt(userVote[i]);
                sb.append(" ").append(options[j]);
            }
        }
        return sb.toString().trim();
    }

    public static String getCurrentUserVote(Poll poll) {
        String[] votes = poll.getUserVote();
        if (votes.length == 0) {
            return poll.getOwner();
        }
        return votes[votes.length - 1].split(":")[0];
    }
}

