/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pdf;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDNameTreeNode;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.apache.pdfbox.pdmodel.interactive.action.type.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.type.PDActionURI;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationMarkup;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineNode;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.apache.pdfbox.util.PDFTextStripper;
import org.apache.pdfbox.util.TextPosition;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.ParsingEmbeddedDocumentExtractor;
import org.apache.tika.io.IOExceptionWithCause;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.pdf.PDFParserConfig;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class PDF2XHTML
extends PDFTextStripper {
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private static final int MAX_ACROFORM_RECURSIONS = 10;
    private boolean inParagraph = false;
    private final ContentHandler originalHandler;
    private final ParseContext context;
    private final XHTMLContentHandler handler;
    private final PDFParserConfig config;

    public static void process(PDDocument document, ContentHandler handler, ParseContext context, Metadata metadata, PDFParserConfig config) throws SAXException, TikaException {
        try {
            PDF2XHTML pdf2XHTML = new PDF2XHTML(handler, context, metadata, config);
            pdf2XHTML.writeText(document, new Writer(){

                @Override
                public void write(char[] cbuf, int off, int len) {
                }

                @Override
                public void flush() {
                }

                @Override
                public void close() {
                }
            });
        }
        catch (IOException e) {
            if (e.getCause() instanceof SAXException) {
                throw (SAXException)e.getCause();
            }
            throw new TikaException("Unable to extract PDF content", (Throwable)e);
        }
    }

    private PDF2XHTML(ContentHandler handler, ParseContext context, Metadata metadata, PDFParserConfig config) throws IOException {
        this.config = config;
        this.originalHandler = handler;
        this.context = context;
        this.handler = new XHTMLContentHandler(handler, metadata);
        this.setForceParsing(true);
        this.setSortByPosition(config.getSortByPosition());
        if (config.getEnableAutoSpace()) {
            this.setWordSeparator(" ");
        } else {
            this.setWordSeparator("");
        }
        this.setSuppressDuplicateOverlappingText(config.getSuppressDuplicateOverlappingText());
    }

    void extractBookmarkText() throws SAXException {
        PDDocumentOutline outline = this.document.getDocumentCatalog().getDocumentOutline();
        if (outline != null) {
            this.extractBookmarkText((PDOutlineNode)outline);
        }
    }

    void extractBookmarkText(PDOutlineNode bookmark) throws SAXException {
        PDOutlineItem current = bookmark.getFirstChild();
        if (current != null) {
            this.handler.startElement("ul");
            while (current != null) {
                this.handler.startElement("li");
                this.handler.characters(current.getTitle());
                this.handler.endElement("li");
                this.extractBookmarkText((PDOutlineNode)current);
                current = current.getNextSibling();
            }
            this.handler.endElement("ul");
        }
    }

    protected void startDocument(PDDocument pdf) throws IOException {
        try {
            this.handler.startDocument();
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to start a document", (Throwable)e);
        }
    }

    protected void endDocument(PDDocument pdf) throws IOException {
        try {
            this.extractBookmarkText();
            this.extractEmbeddedDocuments(pdf, this.originalHandler);
            if (this.config.getExtractAcroFormContent()) {
                this.extractAcroForm(pdf, this.handler);
            }
            this.handler.endDocument();
        }
        catch (TikaException e) {
            throw new IOExceptionWithCause("Unable to end a document", (Throwable)e);
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to end a document", (Throwable)e);
        }
    }

    protected void startPage(PDPage page) throws IOException {
        try {
            this.handler.startElement("div", "class", "page");
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to start a page", (Throwable)e);
        }
        this.writeParagraphStart();
    }

    protected void endPage(PDPage page) throws IOException {
        try {
            this.writeParagraphEnd();
            if (this.config.getExtractAnnotationText()) {
                for (Object o : page.getAnnotations()) {
                    PDActionURI uri;
                    String link;
                    PDAction action;
                    PDAnnotationLink annotationlink;
                    if (o instanceof PDAnnotationLink && (annotationlink = (PDAnnotationLink)o).getAction() != null && (action = annotationlink.getAction()) instanceof PDActionURI && (link = (uri = (PDActionURI)action).getURI()) != null) {
                        this.handler.startElement("div", "class", "annotation");
                        this.handler.startElement("a", "href", link);
                        this.handler.endElement("a");
                        this.handler.endElement("div");
                    }
                    if (!(o instanceof PDAnnotationMarkup)) continue;
                    PDAnnotationMarkup annot = (PDAnnotationMarkup)o;
                    String title = annot.getTitlePopup();
                    String subject = annot.getSubject();
                    String contents = annot.getContents();
                    if (title == null && subject == null && contents == null) continue;
                    this.handler.startElement("div", "class", "annotation");
                    if (title != null) {
                        this.handler.startElement("div", "class", "annotationTitle");
                        this.handler.characters(title);
                        this.handler.endElement("div");
                    }
                    if (subject != null) {
                        this.handler.startElement("div", "class", "annotationSubject");
                        this.handler.characters(subject);
                        this.handler.endElement("div");
                    }
                    if (contents != null) {
                        this.handler.startElement("div", "class", "annotationContents");
                        this.handler.characters(contents);
                        this.handler.endElement("div");
                    }
                    this.handler.endElement("div");
                }
            }
            this.handler.endElement("div");
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to end a page", (Throwable)e);
        }
    }

    protected void writeParagraphStart() throws IOException {
        if (this.inParagraph) {
            this.writeParagraphEnd();
        }
        assert (!this.inParagraph);
        this.inParagraph = true;
        try {
            this.handler.startElement("p");
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to start a paragraph", (Throwable)e);
        }
    }

    protected void writeParagraphEnd() throws IOException {
        if (!this.inParagraph) {
            this.writeParagraphStart();
        }
        assert (this.inParagraph);
        this.inParagraph = false;
        try {
            this.handler.endElement("p");
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to end a paragraph", (Throwable)e);
        }
    }

    protected void writeString(String text) throws IOException {
        try {
            this.handler.characters(text);
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to write a string: " + text, (Throwable)e);
        }
    }

    protected void writeCharacters(TextPosition text) throws IOException {
        try {
            this.handler.characters(text.getCharacter());
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to write a character: " + text.getCharacter(), (Throwable)e);
        }
    }

    protected void writeWordSeparator() throws IOException {
        try {
            this.handler.characters(this.getWordSeparator());
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to write a space character", (Throwable)e);
        }
    }

    protected void writeLineSeparator() throws IOException {
        try {
            this.handler.newline();
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to write a newline character", (Throwable)e);
        }
    }

    private void extractEmbeddedDocuments(PDDocument document, ContentHandler handler) throws IOException, SAXException, TikaException {
        Map embeddedFileNames;
        PDDocumentCatalog catalog = document.getDocumentCatalog();
        PDDocumentNameDictionary names = catalog.getNames();
        if (names == null) {
            return;
        }
        PDEmbeddedFilesNameTreeNode embeddedFiles = names.getEmbeddedFiles();
        if (embeddedFiles == null) {
            return;
        }
        EmbeddedDocumentExtractor embeddedExtractor = (EmbeddedDocumentExtractor)this.context.get(EmbeddedDocumentExtractor.class);
        if (embeddedExtractor == null) {
            embeddedExtractor = new ParsingEmbeddedDocumentExtractor(this.context);
        }
        if ((embeddedFileNames = embeddedFiles.getNames()) != null) {
            this.processEmbeddedDocNames(embeddedFileNames, embeddedExtractor);
        } else {
            List kids = embeddedFiles.getKids();
            if (kids == null) {
                return;
            }
            for (PDNameTreeNode n : kids) {
                Map childNames = n.getNames();
                if (childNames == null) continue;
                this.processEmbeddedDocNames(childNames, embeddedExtractor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEmbeddedDocNames(Map<String, COSObjectable> embeddedFileNames, EmbeddedDocumentExtractor embeddedExtractor) throws IOException, SAXException, TikaException {
        if (embeddedFileNames == null) {
            return;
        }
        for (Map.Entry<String, COSObjectable> ent : embeddedFileNames.entrySet()) {
            PDComplexFileSpecification spec = (PDComplexFileSpecification)ent.getValue();
            PDEmbeddedFile file = spec.getEmbeddedFile();
            Metadata metadata = new Metadata();
            metadata.set("resourceName", ent.getKey());
            metadata.set("Content-Type", file.getSubtype());
            metadata.set("Content-Length", Long.toString(file.getSize()));
            if (!embeddedExtractor.shouldParseEmbedded(metadata)) continue;
            TikaInputStream stream = TikaInputStream.get((InputStream)file.createInputStream());
            try {
                embeddedExtractor.parseEmbedded((InputStream)stream, (ContentHandler)new EmbeddedContentHandler((ContentHandler)this.handler), metadata, false);
            }
            finally {
                stream.close();
            }
        }
    }

    private void extractAcroForm(PDDocument pdf, XHTMLContentHandler handler) throws IOException, SAXException {
        PDDocumentCatalog catalog = pdf.getDocumentCatalog();
        if (catalog == null) {
            return;
        }
        PDAcroForm form = catalog.getAcroForm();
        if (form == null) {
            return;
        }
        List fields = form.getFields();
        if (fields == null) {
            return;
        }
        ListIterator itr = fields.listIterator();
        if (itr == null) {
            return;
        }
        handler.startElement("div", "class", "acroform");
        handler.startElement("ol");
        while (itr.hasNext()) {
            Object obj = itr.next();
            if (obj == null || !(obj instanceof PDField)) continue;
            this.processAcroField((PDField)obj, handler, 0);
        }
        handler.endElement("ol");
        handler.endElement("div");
    }

    private void processAcroField(PDField field, XHTMLContentHandler handler, int recurseDepth) throws SAXException, IOException {
        if (recurseDepth >= 10) {
            return;
        }
        this.addFieldString(field, handler);
        List kids = field.getKids();
        if (kids != null) {
            Iterator kidsIter = kids.iterator();
            if (kidsIter == null) {
                return;
            }
            int r = recurseDepth + 1;
            handler.startElement("ol");
            while (kidsIter.hasNext()) {
                Object pdfObj = kidsIter.next();
                if (pdfObj == null || !(pdfObj instanceof PDField)) continue;
                PDField kid = (PDField)pdfObj;
                this.processAcroField(kid, handler, r);
            }
            handler.endElement("ol");
        }
    }

    private void addFieldString(PDField field, XHTMLContentHandler handler) throws SAXException {
        String partName = field.getPartialName();
        String altName = field.getAlternateFieldName();
        StringBuilder sb = new StringBuilder();
        AttributesImpl attrs = new AttributesImpl();
        if (partName != null) {
            sb.append(partName).append(": ");
        }
        if (altName != null) {
            attrs.addAttribute("", "altName", "altName", "CDATA", altName);
        }
        if (field instanceof PDSignatureField) {
            this.handleSignature(attrs, (PDSignatureField)field, handler);
            return;
        }
        try {
            String value = field.getValue();
            if (value != null && !value.equals("null")) {
                sb.append(value);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (attrs.getLength() > 0 || sb.length() > 0) {
            handler.startElement("li", attrs);
            handler.characters(sb.toString());
            handler.endElement("li");
        }
    }

    private void handleSignature(AttributesImpl parentAttributes, PDSignatureField sigField, XHTMLContentHandler handler) throws SAXException {
        PDSignature sig = sigField.getSignature();
        if (sig == null) {
            return;
        }
        TreeMap<String, String> vals = new TreeMap<String, String>();
        vals.put("name", sig.getName());
        vals.put("contactInfo", sig.getContactInfo());
        vals.put("location", sig.getLocation());
        vals.put("reason", sig.getReason());
        Calendar cal = sig.getSignDate();
        if (cal != null) {
            this.dateFormat.setTimeZone(cal.getTimeZone());
            vals.put("date", this.dateFormat.format(cal.getTime()));
        }
        int nonNull = 0;
        for (String val : vals.keySet()) {
            if (val == null || val.equals("")) continue;
            ++nonNull;
        }
        if (nonNull > 0) {
            handler.startElement("li", parentAttributes);
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", "type", "type", "CDATA", "signaturedata");
            handler.startElement("ol", attrs);
            for (Map.Entry e : vals.entrySet()) {
                if (e.getValue() == null || ((String)e.getValue()).equals("")) continue;
                attrs = new AttributesImpl();
                attrs.addAttribute("", "signdata", "signdata", "CDATA", (String)e.getKey());
                handler.startElement("li", attrs);
                handler.characters((String)e.getValue());
                handler.endElement("li");
            }
            handler.endElement("ol");
            handler.endElement("li");
        }
    }
}

