/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.upgrade.nodetype;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class FlashNodeTypeUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger((String)FlashNodeTypeUpgradePlugin.class.getName());
    private RepositoryService repositoryService_;
    public static final String EXO_RISIZEABLE = "exo:documentSize";
    public static final String FLASH_MIMETYPE = "flash";

    public FlashNodeTypeUpgradePlugin(RepositoryService repoService, InitParams initParams) {
        super(initParams);
        this.repositoryService_ = repoService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Start " + ((Object)((Object)this)).getClass().getName() + "............."));
        }
        try (SessionProvider sessionProvider = null;){
            sessionProvider = SessionProvider.createSystemProvider();
            String[] workspaces = this.repositoryService_.getCurrentRepository().getWorkspaceNames();
            if (workspaces.length > 0) {
                for (String workspace : workspaces) {
                    Session session = sessionProvider.getSession(workspace, this.repositoryService_.getCurrentRepository());
                    QueryManager queryManager = session.getWorkspace().getQueryManager();
                    String queryStatement = "SELECT * FROM nt:resource WHERE jcr:mimeType IS NOT NULL AND jcr:mimeType LIKE '%flash%'";
                    Query query = queryManager.createQuery(queryStatement, "sql");
                    NodeIterator iter = query.execute().getNodes();
                    while (iter.hasNext()) {
                        Node node = iter.nextNode();
                        Node flashNode = node.getParent();
                        if (!flashNode.canAddMixin(EXO_RISIZEABLE)) continue;
                        flashNode.addMixin(EXO_RISIZEABLE);
                        flashNode.save();
                    }
                }
            }
        }
    }

    public boolean shouldProceedToUpgrade(String previousVersion, String newVersion) {
        return VersionComparator.isAfter((String)newVersion, (String)previousVersion);
    }
}

