/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.entities.domain.configuration;

import java.io.Serializable;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.exoplatform.addons.gamification.entities.domain.configuration.AbstractAuditingEntity;
import org.exoplatform.commons.api.persistence.ExoEntity;

@Entity(name="GamificationDomain")
@ExoEntity
@Table(name="GAMIFICATION_DOMAIN")
@NamedQueries(value={@NamedQuery(name="GamificationDomain.getAllDomains", query="SELECT domain FROM GamificationDomain domain  WHERE domain.isDeleted = false"), @NamedQuery(name="GamificationDomain.findDomainByTitle", query="SELECT domain FROM GamificationDomain domain where domain.title = :domainTitle"), @NamedQuery(name="GamificationDomain.deleteDomainByTitle", query="DELETE FROM GamificationDomain domain WHERE domain.title = :domainTitle")})
public class DomainEntity
extends AbstractAuditingEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @SequenceGenerator(name="SEQ_GAMIFICATION_DOMAIN_ID", sequenceName="SEQ_GAMIFICATION_DOMAIN_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_GAMIFICATION_DOMAIN_ID")
    protected Long id;
    @Column(name="TITLE", unique=true, nullable=false)
    protected String title;
    @Column(name="DESCRIPTION")
    protected String description;
    @Column(name="PRIORITY")
    protected int priority;
    @Column(name="DELETED", nullable=false)
    protected boolean isDeleted;
    @Column(name="ENABLED", nullable=false)
    protected boolean isEnabled;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public void setDeleted(boolean deleted) {
        this.isDeleted = deleted;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DomainEntity domainEntity = (DomainEntity)o;
        return domainEntity.getId() != null && this.getId() != null && Objects.equals(this.getId(), domainEntity.getId());
    }

    public int hashCode() {
        return Objects.hashCode(this.getId());
    }

    public String toString() {
        return "Badge{title='" + this.title + '\'' + ", description='" + this.description + '\'' + "}";
    }
}

