/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service;

public class PermissionOwner {
    private String id;
    private String groupId;
    private String membership;
    private String ownerType;
    public static final String USER_OWNER = "user";
    public static final String GROUP_OWNER = "group";
    public static final String MEMBERSHIP_OWNER = "membership";

    public String getId() {
        return this.id;
    }

    public void setId(String permissionId) {
        this.id = permissionId;
    }

    public String getMembership() {
        return this.membership;
    }

    public void setMembership(String membership) {
        this.membership = membership;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getOwnerType() {
        return this.ownerType;
    }

    public void setOwnerType(String ownerType) {
        this.ownerType = ownerType;
    }

    public static PermissionOwner createPermissionOwnerFrom(String permissionStatement) {
        PermissionOwner owner = new PermissionOwner();
        owner.setId(permissionStatement);
        if (permissionStatement.indexOf("/:") == -1 || permissionStatement.indexOf("*.") == -1) {
            owner.setGroupId("");
            owner.setMembership("");
            owner.setOwnerType(USER_OWNER);
            owner.setId(owner.getMeaningfulPermissionOwnerStatement());
            return owner;
        }
        int indexOfSlashColon = permissionStatement.indexOf("/:");
        owner.setGroupId(permissionStatement.substring(0, indexOfSlashColon));
        if (permissionStatement.indexOf("*.*") == -1) {
            int indexAnyOf = permissionStatement.indexOf("*.");
            owner.setMembership(permissionStatement.substring(indexAnyOf + 2, permissionStatement.length()));
            owner.setOwnerType(MEMBERSHIP_OWNER);
            return owner;
        }
        owner.setMembership("*");
        owner.setOwnerType(GROUP_OWNER);
        return owner;
    }

    private String truncateGroupId() {
        String[] groupIdParts = this.groupId.split("/");
        char[] newGroupId = groupIdParts[groupIdParts.length - 1].toCharArray();
        newGroupId[0] = Character.toUpperCase(newGroupId[0]);
        return new String(newGroupId).replaceAll("[^a-zA-Z0-9]+", " ");
    }

    private String getMeaningfulMembership() {
        if (this.membership.equals("*")) {
            return "Anybody";
        }
        return this.membership;
    }

    public String getMeaningfulPermissionOwnerStatement() {
        if (this.ownerType.equals(USER_OWNER)) {
            int slashIdx = this.id.indexOf("/:");
            if (slashIdx == -1) {
                return this.id;
            }
            return this.id.substring(slashIdx + "/:".length(), this.id.length());
        }
        if (this.ownerType.equals(GROUP_OWNER)) {
            return "Anybody in " + this.truncateGroupId();
        }
        return this.getMeaningfulMembership() + " in " + this.truncateGroupId();
    }

    public String toString() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PermissionOwner)) {
            return false;
        }
        PermissionOwner owner = (PermissionOwner)o;
        return this.id.equals(owner.getId());
    }

    public int hashCode() {
        return Math.abs(this.id.hashCode());
    }
}

