/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.calendar.service.CalendarHandler;
import org.exoplatform.calendar.service.EventHandler;
import org.exoplatform.calendar.service.ExtendedCalendarService;
import org.exoplatform.calendar.service.impl.CalendarHandlerImpl;
import org.exoplatform.calendar.service.impl.EventHandlerImpl;
import org.exoplatform.calendar.storage.Storage;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.cache.CacheService;

public class ExtendedCalendarServiceImpl
implements ExtendedCalendarService {
    private CalendarHandler calendarHandler;
    private EventHandler eventHandler;
    private Map<String, Storage> storages = new HashMap<String, Storage>();

    public ExtendedCalendarServiceImpl(CacheService cacheService) {
        this.calendarHandler = new CalendarHandlerImpl(this);
        this.eventHandler = new EventHandlerImpl(this, cacheService);
    }

    @Override
    public Storage lookForDS(String id) {
        if (id != null) {
            return this.storages.get(id);
        }
        return this.storages.get("jcr");
    }

    @Override
    public CalendarHandler getCalendarHandler() {
        return this.calendarHandler;
    }

    @Override
    public EventHandler getEventHandler() {
        return this.eventHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataStore(ComponentPlugin dao) {
        if (dao instanceof Storage) {
            Storage storage = (Storage)dao;
            ExtendedCalendarServiceImpl extendedCalendarServiceImpl = this;
            synchronized (extendedCalendarServiceImpl) {
                this.storages.put(storage.getId(), storage);
            }
        }
    }

    List<Storage> getAllStorage() {
        return new ArrayList<Storage>(this.storages.values());
    }
}

