/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.upgrade.plugins;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class UpgradeDefaultSkin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger(UpgradeDefaultSkin.class);
    private static final String UPGRADE_FROM_VERSION = "5.0";
    private UserPortalConfigService userPortalConfigService;

    public UpgradeDefaultSkin(InitParams initParams, UserPortalConfigService userPortalConfigService) {
        super(initParams);
        this.userPortalConfigService = userPortalConfigService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        RequestLifeCycle.begin((ExoContainer)ExoContainerContext.getCurrentContainer());
        try {
            List allPortalNames = this.userPortalConfigService.getDataStorage().getAllPortalNames();
            for (String portalName : allPortalNames) {
                try {
                    PortalConfig portalConfig = this.userPortalConfigService.getDataStorage().getPortalConfig(portalName);
                    if (!StringUtils.isEmpty((String)portalConfig.getSkin())) continue;
                    portalConfig.setSkin("Default");
                    this.userPortalConfigService.getDataStorage().save(portalConfig);
                }
                catch (Exception e) {
                    LOG.error((Object)("Cannot update default skin of portal " + portalName), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot get list of portal names", (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isBefore((String)previousVersion, (String)UPGRADE_FROM_VERSION);
    }
}

