/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.portal.idm.impl.cache.infinispan.tree;

import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.gatein.portal.idm.impl.cache.infinispan.tree.Fqn;
import org.gatein.portal.idm.impl.cache.infinispan.tree.IDMNodeImpl;
import org.gatein.portal.idm.impl.cache.infinispan.tree.IDMTransientNodeImpl;
import org.gatein.portal.idm.impl.cache.infinispan.tree.Node;
import org.gatein.portal.idm.impl.cache.infinispan.tree.TreeCache;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.atomic.AtomicMap;
import org.infinispan.atomic.AtomicMapLookup;
import org.infinispan.batch.AutoBatchSupport;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.util.Immutables;
import org.infinispan.executors.DefaultScheduledExecutorFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class IDMTreeCacheImpl
extends AutoBatchSupport
implements TreeCache {
    private final AdvancedCache<Fqn, Object> cache;
    private static final Log log = LogFactory.getLog(IDMTreeCacheImpl.class);
    private final boolean attachLifespanToLeafNodes;
    private final long leafNodeLifespan;

    public IDMTreeCacheImpl(Cache<?, ?> cache, boolean attachLifespanToLeafNodes, long leafNodeLifespan, long staleNodesLinksCleanerDelay) {
        this(cache.getAdvancedCache(), attachLifespanToLeafNodes, leafNodeLifespan, staleNodesLinksCleanerDelay);
    }

    private IDMTreeCacheImpl(AdvancedCache<?, ?> cache, boolean attachLifespanToLeafNodes, long leafNodeLifespan, long staleNodesLinksCleanerDelay) {
        this.cache = cache;
        this.batchContainer = cache.getBatchContainer();
        if (cache.getCacheConfiguration().indexing().index().isEnabled()) {
            throw new CacheConfigurationException("TreeCache cannot be used with a Cache instance configured to use indexing!");
        }
        this.attachLifespanToLeafNodes = attachLifespanToLeafNodes;
        this.leafNodeLifespan = leafNodeLifespan;
        this.createRoot();
        if (staleNodesLinksCleanerDelay > 0L) {
            this.startStaleNodesLinkCleaner(staleNodesLinksCleanerDelay);
        }
    }

    @Override
    public boolean exists(Fqn f) {
        return this.cache.containsKey((Object)f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Node addLeafNode(Fqn nodeFqn, Object value) {
        this.startAtomic();
        try {
            this.createNodeInCache(nodeFqn, true);
            this.putValueToCacheLeafNode(nodeFqn, value);
            IDMNodeImpl iDMNodeImpl = new IDMNodeImpl(nodeFqn, this.cache, this, value);
            return iDMNodeImpl;
        }
        finally {
            this.endAtomic();
        }
    }

    @Override
    public Node getTransientLeafNode(Fqn nodeFqn) {
        return new IDMTransientNodeImpl(nodeFqn, this);
    }

    @Override
    public Node getNode(Fqn nodeFqn) {
        Object value = this.cache.get((Object)nodeFqn);
        if (value != null) {
            return new IDMNodeImpl(nodeFqn, this.cache, this, value);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeNode(Fqn nodeFqn) {
        if (nodeFqn.isRoot()) {
            return false;
        }
        this.startAtomic();
        try {
            Object cacheObject = this.cache.get((Object)nodeFqn);
            if (cacheObject != null && cacheObject instanceof AtomicMap) {
                Node myNode = this.getNode(nodeFqn);
                myNode.removeChildren();
                boolean bl = true;
                return bl;
            }
            Node parentNode = this.getNode(nodeFqn.getParent());
            boolean bl = parentNode != null && parentNode.removeChild(nodeFqn.getLastElement());
            return bl;
        }
        finally {
            this.endAtomic();
        }
    }

    @Override
    public boolean removeNode(String fqnString) {
        return this.removeNode(Fqn.fromString(fqnString));
    }

    @Override
    public Cache getCache() {
        return this.cache;
    }

    private void createRoot() {
        if (!this.exists(Fqn.ROOT)) {
            this.createNodeInCache(Fqn.ROOT, false);
        }
    }

    private boolean createNodeInCache(Fqn fqn, boolean isLeafNode) {
        if (this.cache.containsKey((Object)fqn)) {
            return false;
        }
        Fqn parent = fqn.getParent();
        if (!fqn.isRoot()) {
            if (!this.exists(parent)) {
                this.createNodeInCache(parent, false);
            }
            AtomicMap<Object, Fqn> parentStructure = this.getStructure(parent);
            parentStructure.put(fqn.getLastElement(), (Object)fqn);
        }
        if (!isLeafNode) {
            this.getStructure(fqn);
        }
        if (log.isTraceEnabled()) {
            log.tracef("Created node %s", (Object)fqn);
        }
        return true;
    }

    AtomicMap<Object, Fqn> getStructure(Fqn fqn) {
        return AtomicMapLookup.getAtomicMap(this.cache, (Object)fqn);
    }

    void putValueToCacheLeafNode(Fqn key, Object value) {
        if (this.attachLifespanToLeafNodes) {
            this.cache.put((Object)key, value, this.leafNodeLifespan, TimeUnit.MILLISECONDS);
            if (log.isTraceEnabled()) {
                log.tracef("Added record %s with leafNodeLifespan " + this.leafNodeLifespan + "ms", (Object)key);
            }
        } else {
            this.cache.put((Object)key, value);
            if (log.isTraceEnabled()) {
                log.tracef("Added record %s with infinite leafNodeLifespan", (Object)key);
            }
        }
    }

    @Override
    public String printTree() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n\n");
        sb.append("+ ").append("/");
        Object rootNodeContent = this.cache.get((Object)Fqn.ROOT);
        if (rootNodeContent == null) {
            sb.append("NULL_CONTENT\n\n");
            return sb.toString();
        }
        if (rootNodeContent instanceof AtomicMap) {
            sb.append("  NO_DATA");
        } else {
            sb.append("  ").append(rootNodeContent);
        }
        sb.append("\n");
        this.printChildren(this.getNode(Fqn.ROOT), 1, sb);
        return sb.toString();
    }

    private void printChildren(Node node, int depth, StringBuilder sb) {
        AtomicMap<Object, Fqn> structure = this.getStructure(node.getFqn());
        for (Fqn childFqn : structure.values()) {
            for (int i = 0; i < depth; ++i) {
                sb.append("  ");
            }
            sb.append("+ ");
            sb.append(childFqn.getLastElementAsString()).append("/");
            Object cacheValue = this.cache.get((Object)childFqn);
            if (cacheValue instanceof AtomicMap) {
                sb.append("  NO_DATA\n");
                IDMNodeImpl n = new IDMNodeImpl(childFqn, this.cache, this, cacheValue);
                this.printChildren(n, depth + 1, sb);
            } else {
                sb.append("  ").append(this.cache.get((Object)childFqn));
            }
            sb.append("\n");
        }
    }

    private void startStaleNodesLinkCleaner(long staleNodesLinksCleanerDelay) {
        Properties props = new Properties();
        props.put("threadNamePrefix", "StaleNodesLinksCleaner");
        ScheduledExecutorService executorService = new DefaultScheduledExecutorFactory().getScheduledExecutor(props);
        executorService.scheduleWithFixedDelay(new StaleNodesLinksCleaner(), staleNodesLinksCleanerDelay, staleNodesLinksCleanerDelay, TimeUnit.MILLISECONDS);
        log.info((Object)("StaleNodesCleaner started successfully with delay " + staleNodesLinksCleanerDelay));
    }

    private class StaleNodesLinksCleaner
    implements Runnable {
        private StaleNodesLinksCleaner() {
        }

        @Override
        public void run() {
            Node root = IDMTreeCacheImpl.this.getNode(Fqn.ROOT);
            if (root != null) {
                log.debug((Object)"Going to process root node in StaleNodesLinksCleaner");
                this.processNode(root);
            } else {
                log.debug((Object)"Root is missing. Going to clear whole cache in StaleNodesLinksCleaner");
                IDMTreeCacheImpl.this.cache.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processNode(Node node) {
            if (node.get("") instanceof AtomicMap) {
                Fqn nodeFqn = node.getFqn();
                AtomicMap<Object, Fqn> structure = IDMTreeCacheImpl.this.getStructure(node.getFqn());
                LinkedList<IDMNodeImpl> childPathNodes = new LinkedList<IDMNodeImpl>();
                Set structureCopy = Immutables.immutableSetCopy((Set)structure.keySet());
                IDMTreeCacheImpl.this.startAtomic();
                try {
                    for (Object e : structureCopy) {
                        Fqn childFqn = (Fqn)structure.get(e);
                        Object cacheValue = IDMTreeCacheImpl.this.cache.get((Object)childFqn);
                        if (cacheValue == null) {
                            if (log.isTraceEnabled()) {
                                log.tracef("Removing node link %s from parent structure", (Object)childFqn);
                            }
                            structure.remove(e);
                            continue;
                        }
                        if (!(cacheValue instanceof AtomicMap)) continue;
                        IDMNodeImpl child = new IDMNodeImpl(childFqn, (AdvancedCache<Fqn, Object>)IDMTreeCacheImpl.this.cache, IDMTreeCacheImpl.this, cacheValue);
                        childPathNodes.add(child);
                    }
                }
                finally {
                    IDMTreeCacheImpl.this.endAtomic();
                }
                for (Node node2 : childPathNodes) {
                    this.processNode(node2);
                }
            }
        }
    }
}

