/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.ext.component.activity;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jcr.Node;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.pdfbox.io.IOUtils;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.NodeLocation;

public class ActivityFilesDownloadResource
extends DownloadResource {
    private static final Log LOG = ExoLogger.getLogger(ActivityFilesDownloadResource.class);
    private NodeLocation[] nodeLocations;

    public ActivityFilesDownloadResource(NodeLocation[] nodelocations) {
        super("application/zip");
        this.nodeLocations = nodelocations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() throws IOException {
        if (this.nodeLocations == null || this.nodeLocations.length == 0) {
            return null;
        }
        File zipFile = File.createTempFile("activity_files", ".zip");
        ZipArchiveOutputStream zipOutputStream = new ZipArchiveOutputStream(zipFile);
        try {
            zipOutputStream.setCreateUnicodeExtraFields(ZipArchiveOutputStream.UnicodeExtraFieldPolicy.ALWAYS);
            zipOutputStream.setEncoding("UTF-8");
            for (NodeLocation nodeLocation : this.nodeLocations) {
                Node contentNode;
                Node node = NodeLocation.getNodeByLocation((NodeLocation)nodeLocation);
                if (!node.isNodeType("nt:file") || !node.hasNode("jcr:content") || !(contentNode = node.getNode("jcr:content")).hasProperty("jcr:data")) continue;
                String fileName = node.hasProperty("exo:name") ? node.getProperty("exo:name").getString() : node.getName();
                ZipArchiveEntry entry = new ZipArchiveEntry(fileName);
                zipOutputStream.putArchiveEntry((ArchiveEntry)entry);
                try (InputStream inputStream = null;){
                    inputStream = contentNode.getProperty("jcr:data").getStream();
                    IOUtils.copy((InputStream)inputStream, (OutputStream)zipOutputStream);
                }
                zipOutputStream.closeArchiveEntry();
            }
        }
        catch (Exception exp) {
            IOUtils.closeQuietly((OutputStream)zipOutputStream);
            zipFile.delete();
            LOG.error((Object)"An error occurred when generating the ZIP file", (Throwable)exp);
            throw new RuntimeException("An error occurred when generating the ZIP file", exp);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)zipOutputStream);
        }
        return new FileInputStream(zipFile);
    }
}

