/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.common.branding;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.file.services.FileStorageException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.platform.common.branding.Branding;
import org.exoplatform.platform.common.branding.BrandingService;
import org.exoplatform.platform.common.branding.Logo;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;

public class BrandingServiceImpl
implements BrandingService {
    private static final Log LOG = ExoLogger.getExoLogger(BrandingServiceImpl.class);
    public static final String BRANDING_COMPANY_NAME_INIT_PARAM = "exo.branding.company.name";
    public static final String BRANDING_LOGO_INIT_PARAM = "exo.branding.company.logo";
    public static final String BRANDING_COMPANY_NAME_SETTING_KEY = "exo.branding.company.name";
    public static final String BRANDING_TOPBAR_THEME_SETTING_KEY = "bar_navigation_style";
    public static final String BRANDING_LOGO_ID_SETTING_KEY = "exo.branding.company.id";
    public static final String FILE_API_NAME_SPACE = "CompanyBranding";
    public static final String BRANDING_DEFAULT_LOGO_PATH = "/logo/DefaultLogo.png";
    private SettingService settingService;
    private FileService fileService;
    private UploadService uploadService;
    public static String LOGO_NAME = "logo.png";
    private String defaultCompanyName = "";
    private String defaultTopbarTheme = "Dark";
    private String defaultConfiguredLogoPath = null;

    public BrandingServiceImpl(InitParams initParams, SettingService settingService, FileService fileService, UploadService uploadService) {
        this.settingService = settingService;
        this.fileService = fileService;
        this.uploadService = uploadService;
        this.loadInitParams(initParams);
    }

    private void loadInitParams(InitParams initParams) {
        if (initParams != null) {
            ValueParam logoParam;
            ValueParam companyNameParam = initParams.getValueParam("exo.branding.company.name");
            if (companyNameParam != null) {
                this.defaultCompanyName = companyNameParam.getValue();
            }
            if ((logoParam = initParams.getValueParam(BRANDING_LOGO_INIT_PARAM)) != null) {
                this.defaultConfiguredLogoPath = logoParam.getValue();
            }
        }
    }

    @Override
    public Branding getBrandingInformation() {
        Branding branding = new Branding();
        branding.setCompanyName(this.getCompanyName());
        branding.setTopBarTheme(this.getTopBarTheme());
        branding.setLogo(this.getLogo());
        return branding;
    }

    @Override
    public void updateBrandingInformation(Branding branding) throws Exception {
        this.updateCompanyName(branding.getCompanyName());
        this.updateTopBarTheme(branding.getTopBarTheme());
        this.updateLogo(branding.getLogo());
    }

    @Override
    public String getCompanyName() {
        SettingValue brandingCompanyName = this.settingService.get(Context.GLOBAL, Scope.GLOBAL, "exo.branding.company.name");
        if (brandingCompanyName != null && StringUtils.isNotBlank((CharSequence)((CharSequence)brandingCompanyName.getValue()))) {
            return (String)brandingCompanyName.getValue();
        }
        return this.defaultCompanyName;
    }

    @Override
    public void updateCompanyName(String companyName) {
        if (StringUtils.isEmpty((CharSequence)companyName)) {
            this.settingService.remove(Context.GLOBAL, Scope.GLOBAL, "exo.branding.company.name");
        } else {
            this.settingService.set(Context.GLOBAL, Scope.GLOBAL, "exo.branding.company.name", SettingValue.create((String)companyName));
        }
    }

    @Override
    public String getTopBarTheme() {
        SettingValue topBarTheme = this.settingService.get(Context.GLOBAL, Scope.GLOBAL, BRANDING_TOPBAR_THEME_SETTING_KEY);
        if (topBarTheme != null && StringUtils.isNotBlank((CharSequence)((CharSequence)topBarTheme.getValue()))) {
            return (String)topBarTheme.getValue();
        }
        return this.defaultTopbarTheme;
    }

    @Override
    public Long getLogoId() {
        SettingValue logoId = this.settingService.get(Context.GLOBAL, Scope.GLOBAL, BRANDING_LOGO_ID_SETTING_KEY);
        if (logoId != null && logoId.getValue() != null) {
            return Long.parseLong((String)logoId.getValue());
        }
        return null;
    }

    @Override
    public Logo getLogo() {
        Long imageId = this.getLogoId();
        if (imageId != null) {
            try {
                FileItem fileItem = this.fileService.getFile(imageId.longValue());
                if (fileItem != null) {
                    Logo logo = new Logo();
                    logo.setData(fileItem.getAsByte());
                    logo.setSize(fileItem.getFileInfo().getSize());
                    logo.setUpdatedDate(fileItem.getFileInfo().getUpdatedDate().getTime());
                    return logo;
                }
            }
            catch (FileStorageException e) {
                LOG.error((Object)"Error while retrieving branding logo", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public Logo getDefaultLogo() {
        if (StringUtils.isNotBlank((CharSequence)this.defaultConfiguredLogoPath)) {
            try {
                File file = new File(this.defaultConfiguredLogoPath);
                if (file.exists()) {
                    return new Logo(null, Files.readAllBytes(file.toPath()), file.length(), file.lastModified());
                }
            }
            catch (IOException e) {
                LOG.warn((Object)("The file of the default configured logo cannot be retrieved (" + this.defaultConfiguredLogoPath + ")"), (Throwable)e);
                return null;
            }
        }
        try {
            byte[] bytes = IOUtils.toByteArray((InputStream)this.getClass().getResourceAsStream(BRANDING_DEFAULT_LOGO_PATH));
            return new Logo(null, bytes, bytes.length, 0L);
        }
        catch (IOException e) {
            LOG.warn((Object)"The file of the default platform logo cannot be retrieved", (Throwable)e);
            return null;
        }
    }

    @Override
    public void updateTopBarTheme(String topBarTheme) {
        if (StringUtils.isBlank((CharSequence)topBarTheme)) {
            this.settingService.remove(Context.GLOBAL, Scope.GLOBAL, BRANDING_TOPBAR_THEME_SETTING_KEY);
        } else {
            this.settingService.set(Context.GLOBAL, Scope.GLOBAL, BRANDING_TOPBAR_THEME_SETTING_KEY, SettingValue.create((String)topBarTheme));
        }
    }

    @Override
    public void updateLogo(Logo logo) throws Exception {
        if (logo == null || (logo.getData() == null || logo.getData().length <= 0) && StringUtils.isBlank((CharSequence)logo.getUploadId())) {
            Long logoId = this.getLogoId();
            if (logoId != null) {
                this.fileService.deleteFile(logoId.longValue());
                this.settingService.remove(Context.GLOBAL, Scope.GLOBAL, BRANDING_LOGO_ID_SETTING_KEY);
            }
        } else {
            InputStream inputStream;
            if (logo.getData() != null && logo.getData().length > 0) {
                inputStream = new ByteArrayInputStream(logo.getData());
            } else if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{logo.getUploadId()})) {
                inputStream = this.getUploadDataAsStream(logo.getUploadId());
            } else {
                throw new IllegalArgumentException("Cannot update branding logo, the logo object must contain the image data or an upload id");
            }
            String currentUserId = this.getCurrentUserId();
            Long logoId = this.getLogoId();
            if (logoId == null) {
                FileItem fileItem = new FileItem(null, LOGO_NAME, "image/png", FILE_API_NAME_SPACE, logo.getSize(), new Date(), currentUserId, false, inputStream);
                fileItem = this.fileService.writeFile(fileItem);
                this.settingService.set(Context.GLOBAL, Scope.GLOBAL, BRANDING_LOGO_ID_SETTING_KEY, SettingValue.create((String)String.valueOf(fileItem.getFileInfo().getId())));
            } else {
                FileItem fileItem = new FileItem(logoId, LOGO_NAME, "image/png", FILE_API_NAME_SPACE, logo.getSize(), new Date(), currentUserId, false, inputStream);
                this.fileService.updateFile(fileItem);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getUploadDataAsStream(String uploadId) throws FileNotFoundException {
        UploadResource uploadResource = this.uploadService.getUploadResource(uploadId);
        if (uploadResource == null) {
            return null;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(new File(uploadResource.getStoreLocation()));
            return fileInputStream;
        }
        finally {
            this.uploadService.removeUploadResource(uploadId);
        }
    }

    private String getCurrentUserId() {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null && conversationState.getIdentity() != null) {
            return conversationState.getIdentity().getUserId();
        }
        return null;
    }
}

