/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.common.software.register.web;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.exoplatform.commons.info.MissingProductInformationException;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.platform.common.software.register.UnlockService;
import org.exoplatform.platform.common.software.register.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class UnlockServlet
extends HttpServlet {
    private static final long serialVersionUID = -4806814673109318163L;
    private static final Log LOG = ExoLogger.getExoLogger(UnlockServlet.class);

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        UnlockService unlockService = (UnlockService)PortalContainer.getInstance().getComponentInstanceOfType(UnlockService.class);
        String hashMD5Added = request.getParameter("hashMD5");
        String pc = request.getParameter("pc");
        boolean callPingBack = false;
        if (hashMD5Added != null) {
            String productEdition;
            int delay;
            try {
                delay = pc != null && !pc.equals(unlockService.getProductCode()) ? unlockService.decodeKey(pc, hashMD5Added) : unlockService.decodeKey(unlockService.getProductCode(), hashMD5Added);
            }
            catch (Exception exception) {
                delay = 0;
            }
            if (delay > -1 && delay <= 0) {
                request.setAttribute("errorMessage", (Object)"Invalid unlock key.");
                request.getRequestDispatcher("WEB-INF/jsp/welcome-screens/unlockTrial.jsp").include((ServletRequest)request, (ServletResponse)response);
                return;
            }
            try {
                productEdition = unlockService.getProductInformations().getEdition();
            }
            catch (MissingProductInformationException MPIE) {
                LOG.error((Object)"[Unlock Service] : cannot load le platform edition from JCR ", (Throwable)MPIE);
                productEdition = "EXPRESS";
            }
            if (delay == -1) {
                if (pc != null && !pc.equals(unlockService.getProductCode())) {
                    unlockService.setProductCode(pc);
                }
                Utils.writeToFile("license", hashMD5Added, Utils.HOME_CONFIG_FILE_LOCATION);
                Utils.writeToFile("ProductCode", unlockService.getProductCode(), Utils.HOME_CONFIG_FILE_LOCATION);
                unlockService.setOutdated(false);
                unlockService.setUnlocked(true);
                if (!callPingBack && productEdition.equalsIgnoreCase("ENTERPRISE") && this.callPingBack()) {
                    LOG.info((Object)("[Ping Back] : call to " + unlockService.getDefaultPingBackUrl().concat("-ent") + " is done succesfully "));
                }
                if (unlockService.getExecutor() != null) {
                    unlockService.getExecutor().shutdown();
                }
                response.sendRedirect(unlockService.getCalledUrl());
                return;
            }
            unlockService.setDelayPeriod(delay);
            unlockService.setProductCode(unlockService.generateProductCode());
            Utils.writeToFile("ProductCode", unlockService.getProductCode(), Utils.HOME_CONFIG_FILE_LOCATION);
            unlockService.setOutdated(false);
            String rdate = unlockService.computeRemindDateFromTodayBase64();
            try {
                unlockService.setRemindDate(Utils.parseDateBase64(rdate));
                unlockService.computeUnlockedInformation();
                if (!unlockService.isOutdated()) {
                    Utils.writeRemindDate(rdate, Utils.HOME_CONFIG_FILE_LOCATION);
                    Utils.writeToFile("extension", new String(Base64.encodeBase64((byte[])"true".getBytes())), Utils.HOME_CONFIG_FILE_LOCATION);
                    unlockService.setUnlocked(true);
                }
                if (!callPingBack && productEdition.equalsIgnoreCase("ENTERPRISE") && this.callPingBack()) {
                    LOG.info((Object)("[Ping Back] : call to " + unlockService.getDefaultPingBackUrl().concat("-ent") + " is done succesfully "));
                }
                response.sendRedirect(unlockService.getCalledUrl());
                return;
            }
            catch (Exception exception) {
                response.sendRedirect(unlockService.getCalledUrl());
                return;
            }
        }
        if (!unlockService.isUnlocked()) {
            request.getRequestDispatcher("WEB-INF/jsp/welcome-screens/unlockTrial.jsp").include((ServletRequest)request, (ServletResponse)response);
        } else {
            response.sendRedirect("/portal/intranet");
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean callPingBack() {
        UnlockService unlockService = (UnlockService)PortalContainer.getInstance().getComponentInstanceOfType(UnlockService.class);
        String pingServerURL = unlockService.getDefaultPingBackUrl().concat("-ent");
        HttpURLConnection urlConn = null;
        try {
            URL url = new URL(pingServerURL);
            urlConn = (HttpURLConnection)url.openConnection();
            urlConn.connect();
            boolean bl = 404 != urlConn.getResponseCode();
            return bl;
        }
        catch (MalformedURLException e) {
            LOG.error((Object)("[Ping Back Call] : Error creating HTTP connection to  : " + pingServerURL));
        }
        catch (IOException e) {
            LOG.error((Object)("[Ping Back Call] : Error creating HTTP connection to : " + pingServerURL));
        }
        finally {
            urlConn.disconnect();
            LOG.info((Object)("[Ping Back Call] : connection to [" + pingServerURL + "] is released"));
        }
        return false;
    }
}

