/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.gadget.services.LoginHistory;

import java.util.List;
import java.util.Set;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.platform.gadget.services.LoginHistory.LastLoginBean;
import org.exoplatform.platform.gadget.services.LoginHistory.LoginCounterBean;
import org.exoplatform.platform.gadget.services.LoginHistory.LoginHistoryBean;
import org.exoplatform.platform.gadget.services.LoginHistory.LoginHistoryService;
import org.exoplatform.platform.gadget.services.LoginHistory.storage.LoginHistoryStorage;

public class LoginHistoryServiceImpl
implements LoginHistoryService {
    private boolean enableLoginHistory = true;
    private LoginHistoryStorage loginHistoryStorage;

    public LoginHistoryServiceImpl(LoginHistoryStorage loginHistoryStorage, InitParams params) {
        this.loginHistoryStorage = loginHistoryStorage;
        if (params != null && params.containsKey((Object)"exo.audit.login.enabled")) {
            String enableLoginHistoryString = params.getValueParam("exo.audit.login.enabled").getValue();
            this.enableLoginHistory = enableLoginHistoryString.equalsIgnoreCase("true");
        }
    }

    @Override
    public long getLastLogin(String userId) throws Exception {
        return this.loginHistoryStorage.getLastLogin(userId);
    }

    @Override
    public List<LastLoginBean> getLastLogins(int numItems, String userIdFilter) throws Exception {
        return this.loginHistoryStorage.getLastLogins(numItems, userIdFilter);
    }

    @Override
    public void addLoginHistoryEntry(String userId, long loginTime) throws Exception {
        this.loginHistoryStorage.addLoginHistoryEntry(userId, loginTime);
    }

    @Override
    public List<LoginHistoryBean> getLoginHistory(String userId, long fromTime, long toTime) throws Exception {
        return this.loginHistoryStorage.getLoginHistory(userId, fromTime, toTime);
    }

    public List<LoginCounterBean> getLoginCountPerDaysInRange(String userId, long fromDate, long toDate) throws Exception {
        return this.getLoginCountPerDaysInRange(userId, fromDate, toDate);
    }

    @Override
    public List<LoginCounterBean> getLoginCountPerDaysInWeek(String userId, long week) throws Exception {
        return this.loginHistoryStorage.getLoginCountPerDaysInWeek(userId, week);
    }

    @Override
    public List<LoginCounterBean> getLoginCountPerWeeksInMonths(String userId, long fromMonth, int numOfMonths) throws Exception {
        return this.loginHistoryStorage.getLoginCountPerWeeksInMonths(userId, fromMonth, numOfMonths);
    }

    @Override
    public List<LoginCounterBean> getLoginCountPerMonthsInYear(String userId, long year) throws Exception {
        return this.loginHistoryStorage.getLoginCountPerMonthsInYear(userId, year);
    }

    @Override
    public Set<String> getLastUsersLogin(long fromTime) throws Exception {
        return this.loginHistoryStorage.getLastUsersLogin(fromTime);
    }

    @Override
    public long getBeforeLastLogin(String userId) throws Exception {
        return this.loginHistoryStorage.getBeforeLastLogin(userId);
    }

    @Override
    public boolean isEnabled() {
        return this.enableLoginHistory;
    }
}

