/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.push.service.fcm;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.jackson.JacksonFactory;
import com.google.api.client.util.PemReader;
import com.google.api.client.util.SecurityUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.exoplatform.commons.api.notification.plugin.NotificationPluginUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.push.domain.Message;
import org.exoplatform.push.exception.InvalidTokenException;
import org.exoplatform.push.service.MessagePublisher;
import org.exoplatform.push.service.fcm.FCMServiceAccountConfiguration;
import org.exoplatform.push.service.fcm.FcmDetail;
import org.exoplatform.push.service.fcm.FcmError;
import org.exoplatform.push.service.fcm.FcmResponse;
import org.exoplatform.push.util.StringUtil;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;

public class FCMMessagePublisher
implements MessagePublisher {
    private static final Log LOG = ExoLogger.getLogger(FCMMessagePublisher.class);
    public static final String LOG_SERVICE_NAME = "firebase-cloud-messaging";
    public static final String LOG_OPERATION_NAME = "send-push-notification";
    private ResourceBundleService resourceBundleService;
    private CloseableHttpClient httpClient;
    private String fcmServiceAccountFilePath;
    private FCMServiceAccountConfiguration fcmServiceAccountConfiguration;
    private GoogleCredential googleCredential;
    private Integer fcmMessageExpirationTime = null;

    public FCMMessagePublisher(InitParams initParams, ResourceBundleService resourceBundleService) {
        this(initParams, resourceBundleService, HttpClientBuilder.create().build());
    }

    public FCMMessagePublisher(InitParams initParams, ResourceBundleService resourceBundleService, CloseableHttpClient httpClient) {
        if (initParams != null) {
            ValueParam serviceAccountFilePathValueParam = initParams.getValueParam("serviceAccountFilePath");
            if (serviceAccountFilePathValueParam != null) {
                this.fcmServiceAccountFilePath = serviceAccountFilePathValueParam.getValue();
            }
            if (StringUtils.isNotBlank((String)this.fcmServiceAccountFilePath)) {
                try {
                    if (!this.fcmServiceAccountFilePath.startsWith("/")) {
                        String gateinConfDir = System.getProperty("gatein.conf.dir");
                        this.fcmServiceAccountFilePath = gateinConfDir + "/" + this.fcmServiceAccountFilePath;
                    }
                    this.fcmServiceAccountConfiguration = this.loadConfiguration(this.fcmServiceAccountFilePath);
                    this.googleCredential = this.getCredentialsFromStream(this.fcmServiceAccountConfiguration);
                }
                catch (FileNotFoundException e) {
                    LOG.warn((Object)("Push notifications - Firebase Cloud Messaging service account config file does not exist, meaning Push Notifications will not work. Add the file at " + this.fcmServiceAccountFilePath + " to make it work."));
                }
                catch (Exception e) {
                    LOG.error((Object)("Push notifications - Error while loading Firebase Cloud Messaging configuration from config file " + this.fcmServiceAccountFilePath), (Throwable)e);
                }
            } else {
                LOG.warn((Object)"Push notifications - Firebase Cloud Messaging service account config file path is not configured, meaning Push Notifications will not work. Configure it with exo.push.fcm.serviceAccountFilePath property.");
            }
            ValueParam fcmMessageExpirationTimeValueParam = initParams.getValueParam("messageExpirationTime");
            if (fcmMessageExpirationTimeValueParam != null && StringUtils.isNotBlank((String)fcmMessageExpirationTimeValueParam.getValue())) {
                try {
                    this.fcmMessageExpirationTime = Integer.parseInt(fcmMessageExpirationTimeValueParam.getValue());
                }
                catch (NumberFormatException e) {
                    LOG.error((Object)("Push Notifications - FCM message expiration time is not a valid number (" + fcmMessageExpirationTimeValueParam.getValue() + "), using default value from FCM"), (Throwable)e);
                }
            }
        }
        this.resourceBundleService = resourceBundleService;
        this.httpClient = httpClient;
    }

    @Override
    public void send(Message message) throws Exception {
        if (this.googleCredential == null) {
            return;
        }
        HttpPost post = new HttpPost("https://fcm.googleapis.com/v1/projects/" + this.fcmServiceAccountConfiguration.getServiceAccountProjectId() + "/messages:send");
        post.setHeader("Authorization", "Bearer " + this.getAccessToken());
        post.setHeader("Content-Type", "application/json");
        String messageBody = this.processBody(message);
        StringBuilder requestBody = new StringBuilder().append("{").append("  \"validate_only\": false,").append("  \"message\": {");
        if (StringUtils.isNotBlank((String)message.getDeviceType()) && message.getDeviceType().equals("android")) {
            requestBody.append("    \"data\": {").append("      \"title\": \"").append(message.getTitle().replaceAll("\"", "\\\\\"")).append("\",").append("      \"body\": \"").append(messageBody).append("\",").append("      \"url\": \"").append(message.getUrl()).append("\"").append("    },");
        } else {
            requestBody.append("    \"data\": {").append("      \"url\": \"").append(message.getUrl()).append("\"").append("    },").append("    \"notification\": {").append("      \"title\": \"").append(message.getTitle().replaceAll("\\<[^>]*>", "").replaceAll("\"", "\\\\\"")).append("\",").append("      \"body\": \"").append(messageBody.replaceAll("\\<[^>]*>", "")).append("\"").append("    },");
        }
        if (this.fcmMessageExpirationTime != null && StringUtils.isNotBlank((String)message.getDeviceType())) {
            if (message.getDeviceType().equals("android")) {
                requestBody.append("    \"android\": {").append("      \"ttl\": \"").append(this.fcmMessageExpirationTime).append("s\"").append("    },");
            } else if (message.getDeviceType().equals("ios")) {
                Instant expirationInstant = Instant.now().minus(this.fcmMessageExpirationTime.intValue(), ChronoUnit.SECONDS);
                requestBody.append("    \"apns\": {").append("      \"headers\": {").append("        \"apns-expiration\": \"").append(expirationInstant.getEpochSecond()).append("\"").append("      }").append("    },");
            }
        }
        requestBody.append("    \"token\":\"").append(message.getToken()).append("\"").append("  }").append("}");
        post.setEntity((HttpEntity)new ByteArrayEntity(requestBody.toString().getBytes()));
        long startTimeSendingMessage = System.currentTimeMillis();
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)post);){
            long sendMessageExecutionTime = System.currentTimeMillis() - startTimeSendingMessage;
            if (response == null || response.getStatusLine() == null) {
                String errorMessage = "Error sending Push Notification, HTTP response or HTTP response code is null";
                LOG.info("remote_service={} operation={} parameters=\"user:{},token:{},type:{}\" status=ko duration_ms={} error_msg=\"{}\"", new Object[]{LOG_SERVICE_NAME, LOG_OPERATION_NAME, message.getReceiver(), StringUtil.mask(message.getToken(), 4), message.getDeviceType(), sendMessageExecutionTime, errorMessage});
                throw new Exception(errorMessage);
            }
            if (response.getStatusLine().getStatusCode() != 200) {
                String errorMessage = "Error sending Push Notification, response is " + response.getStatusLine().getStatusCode() + " - " + response.getStatusLine().getReasonPhrase();
                LOG.info("remote_service={} operation={} parameters=\"user:{},token:{},type:{}\" status=ko status_code={} duration_ms={} error_msg=\"{}\"", new Object[]{LOG_SERVICE_NAME, LOG_OPERATION_NAME, message.getReceiver(), StringUtil.mask(message.getToken(), 4), message.getDeviceType(), response.getStatusLine().getStatusCode(), sendMessageExecutionTime, errorMessage});
                if (this.isTokenInvalid(response)) {
                    throw new InvalidTokenException(errorMessage);
                }
                throw new Exception(errorMessage);
            }
            LOG.info("remote_service={} operation={} parameters=\"user:{},token:{},type:{}\" status=ok duration_ms={}", new Object[]{LOG_SERVICE_NAME, LOG_OPERATION_NAME, message.getReceiver(), StringUtil.mask(message.getToken(), 4), message.getDeviceType(), sendMessageExecutionTime});
            LOG.info("Message sent to Firebase : username={}, token={}, type={}", new Object[]{message.getReceiver(), StringUtil.mask(message.getToken(), 4), message.getDeviceType()});
        }
    }

    protected String processBody(Message message) {
        String language = NotificationPluginUtils.getLanguage((String)message.getReceiver());
        Locale locale = StringUtils.isNotEmpty((String)language) ? new Locale(language) : Locale.ENGLISH;
        ResourceBundle resourceBundle = this.resourceBundleService.getResourceBundle("locale.portlet.notification.PushNotifications", locale);
        String messageBody = message.getBody();
        messageBody = SocialNotificationUtils.processImageTitle((String)messageBody, (String)resourceBundle.getString("Notification.push.label.InlineImage"));
        messageBody = messageBody.replaceAll("\"", "\\\\\"");
        return messageBody;
    }

    private boolean isTokenInvalid(CloseableHttpResponse response) throws IOException {
        String errorStatus;
        JacksonFactory jsonFactory;
        JsonObjectParser parser;
        FcmResponse responseContent;
        FcmError error;
        if (response.getStatusLine().getStatusCode() == 400 && (error = (responseContent = (FcmResponse)(parser = new JsonObjectParser((JsonFactory)(jsonFactory = new JacksonFactory()))).parseAndClose(response.getEntity().getContent(), Charset.forName("UTF-8"), FcmResponse.class)).getError()) != null && (errorStatus = error.getStatus()) != null) {
            List<FcmDetail> details;
            if (errorStatus.equals("UNREGISTERED")) {
                return true;
            }
            if (errorStatus.equals("INVALID_ARGUMENT") && (details = error.getDetails()) != null) {
                for (FcmDetail detail : details) {
                    List fieldViolations = (List)detail.get("fieldViolations");
                    if (fieldViolations == null || !fieldViolations.stream().anyMatch(fieldViolation -> fieldViolation.get((Object)"field") != null && fieldViolation.get((Object)"field").equals("message.token"))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected FCMServiceAccountConfiguration loadConfiguration(String fcmServiceAccountFilePath) throws IOException {
        LOG.info((Object)("Loading Firebase configuration for Push Notifications from file " + fcmServiceAccountFilePath));
        File jsonFile = new File(fcmServiceAccountFilePath);
        FileInputStream fcmServiceAccountFile = new FileInputStream(jsonFile);
        JacksonFactory jsonFactory = new JacksonFactory();
        JsonObjectParser parser = new JsonObjectParser((JsonFactory)jsonFactory);
        GenericJson fileContents = (GenericJson)parser.parseAndClose((InputStream)fcmServiceAccountFile, Charset.forName("UTF-8"), GenericJson.class);
        String clientId = (String)fileContents.get((Object)"client_id");
        String clientEmail = (String)fileContents.get((Object)"client_email");
        String privateKeyPem = (String)fileContents.get((Object)"private_key");
        String privateKeyId = (String)fileContents.get((Object)"private_key_id");
        if (clientId != null && clientEmail != null && privateKeyPem != null && privateKeyId != null) {
            String tokenUri;
            FCMServiceAccountConfiguration fcmServiceAccountConfiguration = new FCMServiceAccountConfiguration();
            fcmServiceAccountConfiguration.setServiceAccountId(clientEmail);
            fcmServiceAccountConfiguration.setServiceAccountClientId(clientId);
            fcmServiceAccountConfiguration.setServiceAccountPrivateKeyPem(privateKeyPem);
            fcmServiceAccountConfiguration.setServiceAccountPrivateKeyId(privateKeyId);
            String projectId = (String)fileContents.get((Object)"project_id");
            if (projectId != null) {
                fcmServiceAccountConfiguration.setServiceAccountProjectId(projectId);
            }
            if ((tokenUri = (String)fileContents.get((Object)"token_uri")) != null) {
                fcmServiceAccountConfiguration.setTokenServerEncodedUrl(tokenUri);
            }
            return fcmServiceAccountConfiguration;
        }
        throw new IOException("Error reading service account configuration from file, expecting 'client_id', 'client_email', 'private_key' and 'private_key_id'.");
    }

    protected GoogleCredential getCredentialsFromStream(FCMServiceAccountConfiguration configuration) throws Exception {
        Method setServiceAccountScopesMethod;
        PrivateKey privateKey = this.getPrivateKeyFromPkcs8(configuration.getServiceAccountPrivateKeyPem());
        GoogleCredential.Builder credentialBuilder = new GoogleCredential.Builder().setTransport((HttpTransport)GoogleNetHttpTransport.newTrustedTransport()).setJsonFactory((JsonFactory)new JacksonFactory()).setServiceAccountId(configuration.getServiceAccountId()).setServiceAccountPrivateKey(privateKey);
        try {
            setServiceAccountScopesMethod = credentialBuilder.getClass().getDeclaredMethod("setServiceAccountScopes", Iterable.class);
        }
        catch (NoSuchMethodException e) {
            try {
                setServiceAccountScopesMethod = credentialBuilder.getClass().getDeclaredMethod("setServiceAccountScopes", Collection.class);
            }
            catch (NoSuchMethodException e1) {
                throw new Exception("Cannot find suitable method setServiceAccountScopes in GoogleCredential.Builder class", e1);
            }
        }
        if (setServiceAccountScopesMethod != null) {
            setServiceAccountScopesMethod.invoke((Object)credentialBuilder, Collections.singletonList("https://www.googleapis.com/auth/firebase.messaging"));
        }
        return credentialBuilder.build();
    }

    protected PrivateKey getPrivateKeyFromPkcs8(String privateKeyPem) throws IOException {
        StringReader reader = new StringReader(privateKeyPem);
        PemReader.Section section = PemReader.readFirstSectionAndClose((Reader)reader, (String)"PRIVATE KEY");
        if (section == null) {
            throw new IOException("Invalid PKCS8 data.");
        }
        byte[] bytes = section.getBase64DecodedBytes();
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(bytes);
        GeneralSecurityException unexpectedException = null;
        try {
            KeyFactory keyFactory = SecurityUtils.getRsaKeyFactory();
            PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
            return privateKey;
        }
        catch (NoSuchAlgorithmException exception) {
            unexpectedException = exception;
        }
        catch (InvalidKeySpecException exception) {
            unexpectedException = exception;
        }
        throw new IOException("Unexpected exception reading PKCS data", unexpectedException);
    }

    protected String getAccessToken() throws IOException {
        this.googleCredential.refreshToken();
        return this.googleCredential.getAccessToken();
    }
}

