/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.ws;

import java.util.Calendar;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.commons.utils.ISO8601;

public class RestEventQuery
extends EventQuery {
    public String getQueryStatement() throws Exception {
        int i;
        String[] categoryIds;
        StringBuilder sql = new StringBuilder("SELECT exo:id FROM ");
        sql.append("exo:calendarEvent");
        sql.append(" WHERE");
        if (this.getCalendarId() != null || this.getParticipants() != null) {
            sql.append(" AND (");
            if (this.getCalendarId() != null) {
                for (String calId : this.getCalendarId()) {
                    sql.append(" OR ").append("exo:calendarId").append(" = '").append(calId).append("'");
                }
            }
            if (this.getParticipants() != null) {
                for (String participant : this.getParticipants()) {
                    if (this.getCalendarPath() != null) {
                        sql.append(" AND ");
                    } else {
                        sql.append(" OR ");
                    }
                    if (CalendarEvent.TYPE_TASK.equals(this.getEventType())) {
                        sql.append("CONTAINS(").append("exo:taskDelegator");
                        sql.append(",'").append(participant).append("')");
                        continue;
                    }
                    sql.append("exo:participant").append(" = '").append(participant).append("'");
                }
            }
            sql.append(")");
        }
        if (this.getFromDate() != null) {
            sql.append(" AND (").append("exo:fromDateTime").append(" >= TIMESTAMP '").append(ISO8601.format((Calendar)this.getFromDate())).append("')");
        }
        if (this.getToDate() != null) {
            sql.append(" AND (").append("exo:fromDateTime").append(" <= TIMESTAMP '").append(ISO8601.format((Calendar)this.getToDate())).append("')");
        }
        if ((categoryIds = this.getCategoryId()) != null && categoryIds.length > 0) {
            sql.append(" AND (");
            for (i = 0; i < categoryIds.length; ++i) {
                sql.append("exo:eventCategoryId");
                sql.append(" = '").append(categoryIds[i]).append("'");
                if (i >= categoryIds.length - 1) continue;
                sql.append(" OR ");
            }
            sql.append(")");
        }
        if (!Utils.isEmpty((String)this.getEventType())) {
            sql.append(" AND ").append("exo:eventType").append("='");
            sql.append(this.getEventType()).append("'");
        }
        if ((i = sql.indexOf("WHERE AND")) != -1) {
            sql.replace(i, i + 9, "WHERE");
        }
        if ((i = sql.indexOf("( OR")) != -1) {
            sql.replace(i, i + 4, "(");
        }
        if ((i = sql.indexOf("( AND")) != -1) {
            sql.replace(i, i + 5, "(");
        }
        Object[] orderBy = this.getOrderBy();
        String orderType = " " + this.getOrderType();
        if (orderBy != null && orderBy.length > 0) {
            sql.append(" ORDER BY ");
            for (int j = 0; j < orderBy.length; ++j) {
                orderBy[j] = (String)orderBy[j] + orderType;
            }
            sql.append(StringUtils.join((Object[])orderBy, (String)","));
        }
        return sql.toString();
    }
}

