/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.database.impl;

import java.io.Serializable;
import java.util.Properties;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.impl.CacheServiceImpl;
import org.exoplatform.services.database.impl.regions.ExoCacheCollectionRegion;
import org.exoplatform.services.database.impl.regions.ExoCacheEntityRegion;
import org.exoplatform.services.database.impl.regions.ExoCacheNaturalIdRegion;
import org.exoplatform.services.database.impl.regions.ExoCacheQueryResultsRegion;
import org.exoplatform.services.database.impl.regions.ExoCacheTimestampsRegion;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.CollectionRegion;
import org.hibernate.cache.spi.EntityRegion;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.TimestampsRegion;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cfg.Settings;

public class ExoCacheRegionFactory
implements RegionFactory {
    private CacheService cacheService;

    public ExoCacheRegionFactory() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        this.cacheService = (CacheService)container.getComponentInstanceOfType(CacheServiceImpl.class);
    }

    public void start(Settings settings, Properties properties) throws CacheException {
    }

    public void stop() {
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return true;
    }

    public AccessType getDefaultAccessType() {
        return AccessType.READ_WRITE;
    }

    public long nextTimestamp() {
        return System.currentTimeMillis() / 100L;
    }

    public EntityRegion buildEntityRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        ExoCache cache = this.cacheService.getCacheInstance("ExoCacheRegionFactory-Entity-" + regionName);
        return new ExoCacheEntityRegion((ExoCache<Serializable, Object>)cache, metadata);
    }

    public NaturalIdRegion buildNaturalIdRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        ExoCache cache = this.cacheService.getCacheInstance("ExoCacheRegionFactory-NaturalId-" + regionName);
        return new ExoCacheNaturalIdRegion((ExoCache<Serializable, Object>)cache, metadata);
    }

    public CollectionRegion buildCollectionRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        ExoCache cache = this.cacheService.getCacheInstance("ExoCacheRegionFactory-Collection-" + regionName);
        return new ExoCacheCollectionRegion((ExoCache<Serializable, Object>)cache, metadata);
    }

    public QueryResultsRegion buildQueryResultsRegion(String regionName, Properties properties) throws CacheException {
        ExoCache cache = this.cacheService.getCacheInstance("ExoCacheRegionFactory-QueryResults-" + regionName);
        return new ExoCacheQueryResultsRegion((ExoCache<Serializable, Object>)cache);
    }

    public TimestampsRegion buildTimestampsRegion(String regionName, Properties properties) throws CacheException {
        ExoCache cache = this.cacheService.getCacheInstance("ExoCacheRegionFactory-Timestamps-" + regionName);
        return new ExoCacheTimestampsRegion((ExoCache<Serializable, Object>)cache);
    }
}

